/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERBitString;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERNull;
import netscape.ldap.ber.stream.BERNumericString;
import netscape.ldap.ber.stream.BERObjectId;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERPrintableString;
import netscape.ldap.ber.stream.BERReal;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.ber.stream.BERTagDecoder;
import netscape.ldap.ber.stream.BERUTCTime;
import netscape.ldap.ber.stream.BERVisibleString;

public abstract class BERElement {
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BITSTRING = 3;
    public static final int OCTETSTRING = 4;
    public static final int NULL = 5;
    public static final int OBJECTID = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int SET = 49;
    public static final int SEQUENCE = 48;
    public static final int NUMERICSTRING = 18;
    public static final int PRINTABLESTRING = 19;
    public static final int TELETEXSTRING = 20;
    public static final int VIDEOTEXSTRING = 21;
    public static final int IA5STRING = 22;
    public static final int UTCTIME = 23;
    public static final int GRAPHICSTRING = 25;
    public static final int VISIBLESTRING = 26;
    public static final int GENERALSTRING = 27;
    public static final int TAG = -1;
    public static final int CHOICE = -2;
    public static final int ANY = -3;
    public static final int EOC = 0;
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int SASLCONTEXT = 160;
    public static final int PRIVATE = 192;
    public static final int PRIMITIVE = 0;
    public static final int CONSTRUCTED = 32;
    public static final int MRA_OID = 1;
    public static final int MRA_TYPE = 2;
    public static final int MRA_VALUE = 3;
    public static final int MRA_DNATTRS = 4;
    public static final int EXOP_REQ_OID = 0;
    public static final int EXOP_REQ_VALUE = 1;
    public static final int EXOP_RES_OID = 10;
    public static final int EXOP_RES_VALUE = 11;
    public static final int SK_MATCHRULE = 0;
    public static final int SK_REVERSE = 1;
    public static final int SR_ATTRTYPE = 0;

    public static BERElement getElement(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        BERElement bERElement = null;
        int n = inputStream.read();
        nArray[0] = 1;
        if (n == 0) {
            inputStream.read();
            nArray[0] = 1;
            bERElement = null;
        } else if (n == 1) {
            bERElement = new BERBoolean(inputStream, nArray);
        } else if (n == 2) {
            bERElement = new BERInteger(inputStream, nArray);
        } else if (n == 3) {
            bERElement = new BERBitString(inputStream, nArray);
        } else if (n == 35) {
            bERElement = new BERBitString(bERTagDecoder, inputStream, nArray);
        } else if (n == 4) {
            bERElement = new BEROctetString(inputStream, nArray);
        } else if (n == 36) {
            bERElement = new BEROctetString(bERTagDecoder, inputStream, nArray);
        } else if (n == 5) {
            bERElement = new BERNull(inputStream, nArray);
        } else if (n == 6) {
            bERElement = new BERObjectId(inputStream, nArray);
        } else if (n == 9) {
            bERElement = new BERReal(inputStream, nArray);
        } else if (n == 10) {
            bERElement = new BEREnumerated(inputStream, nArray);
        } else if (n == 48) {
            bERElement = new BERSequence(bERTagDecoder, inputStream, nArray);
        } else if (n == 49) {
            bERElement = new BERSet(bERTagDecoder, inputStream, nArray);
        } else if (n == 18) {
            bERElement = new BERNumericString(inputStream, nArray);
        } else if (n == 50) {
            bERElement = new BERNumericString(bERTagDecoder, inputStream, nArray);
        } else if (n == 19) {
            bERElement = new BERPrintableString(inputStream, nArray);
        } else if (n == 51) {
            bERElement = new BERPrintableString(bERTagDecoder, inputStream, nArray);
        } else if (n == 23) {
            bERElement = new BERUTCTime(inputStream, nArray);
        } else if (n == 55) {
            bERElement = new BERUTCTime(bERTagDecoder, inputStream, nArray);
        } else if (n == 26) {
            bERElement = new BERVisibleString(inputStream, nArray);
        } else if (n == 58) {
            bERElement = new BERVisibleString(bERTagDecoder, inputStream, nArray);
        } else if ((n & 0xC0) > 0) {
            bERElement = new BERTag(bERTagDecoder, n, inputStream, nArray);
        } else {
            throw new IOException("invalid tag " + n);
        }
        return bERElement;
    }

    public static int readLengthOctets(InputStream inputStream, int[] nArray) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        nArray[0] = nArray[0] + 1;
        if (n2 == 128) {
            n = -1;
        } else if ((n2 & 0x80) > 0) {
            int n3 = n2 & 0x7F;
            int n4 = 0;
            while (n4 < n3) {
                n2 = inputStream.read();
                nArray[0] = nArray[0] + 1;
                n = (n << 8) + n2;
                ++n4;
            }
        } else {
            n = n2;
        }
        return n;
    }

    public static void sendDefiniteLength(OutputStream outputStream, int n) throws IOException {
        if (n <= 127) {
            outputStream.write(n);
            return;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 >= 0) {
            ++n2;
            if ((n3 >>= 8) <= 0) break;
        }
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = (byte)(0x80 | n2);
        n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            byArray[n4] = (byte)(n3 & 0xFF);
            n3 >>= 8;
            --n4;
        }
        outputStream.write(byArray);
    }

    protected int readUnsignedBinary(InputStream inputStream, int[] nArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = inputStream.read();
            nArray[0] = nArray[0] + 1;
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        return n2;
    }

    protected int readTwosComplement(InputStream inputStream, int[] nArray, int n) throws IOException {
        int n2 = 0;
        if (n > 0) {
            boolean bl = false;
            int n3 = inputStream.read();
            nArray[0] = nArray[0] + 1;
            if ((n3 & 0x80) > 0) {
                bl = true;
            }
            int n4 = 0;
            while (n4 < n) {
                if (n4 > 0) {
                    n3 = inputStream.read();
                    nArray[0] = nArray[0] + 1;
                }
                n2 = bl ? (n2 << 8) + (n3 ^ 0xFF) & 0xFF : (n2 << 8) + (n3 & 0xFF);
                ++n4;
            }
            if (bl) {
                n2 = (n2 + 1) * -1;
            }
        }
        return n2;
    }

    public String byteToHexString(byte by) {
        if (by < 0) {
            return Integer.toHexString((by & 0x7F) + 128);
        }
        return Integer.toHexString(by);
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract int getType();

    public abstract String toString();
}

