% This is `ghyph31.tex' as of 13. Feb 94.
%
% Copyright (C) 1988,1991 Rechenzentrum der Ruhr-Universitaet Bochum
%               [german hyphen patterns]
% Copyright (C) 1993,1994 Bernd Raichle/DANTE e.V.
%               [macros, adaption for TeX 2]
%
% General permission for use and non-profit redistribution is granted.
% For special commercial use, contact the below address.
%
% Commercial use is generally granted, if a reference copy
%  - for use by the Rechenzentrum of the Ruhr-Universitaet -
% is received.
%
%
% This file contains 5719 german hyphen patterns with umlauts
% in the recommended version of September 27, 1990.
% It is an experimental version for testing the integration of
% umlauts and `es-zett', but without `c-k' and triple consonants.
%
% For use with TeX generated by
%
%          Norbert Schwarz
%          Rechenzentrum Ruhr-Universitaet Bochum
%          Universitaetsstrasse 150
%          D-44721 Bochum, FRG
%
%    Email (X.400):
%          Norbert.Schwarz@RUBA.RZ.RUHR-UNI-BOCHUM.DBP.DE
%
%
% Adaption of these patterns for TeX, Version 2.x and 3.x and
% all fonts in `Cork'/EC/DC and/or CM encoding by
%
%          Bernd Raichle
%          Stettener Str. 73
%          D-73732 Esslingen, FRG
%   Email: raichle@Informatik.Uni-Stuttgart.DE
%
%
% Error reports in case of UNCHANGED versions to
%
%          DANTE e.V., Koordinator `german.sty'
%          Postfach 10 18 40
%          D-69008 Heidelberg, FRG
%   Email: german@Dante.DE
%
% or one of the addresses given above.
%
% Changes:
%  1990-09-27 First version of `ghyphen3.tex' (Norbert Schwarz)
%  1991-02-13 PC umlauts changed to ^^xx  (Norbert Schwarz)
%  1993-08-27 Umlauts/\ss changed to "a/\3 macros, added macro
%             definitions and additional logic to select correct
%             patterns/encoding  (Bernd Raichle)
%  1994-02-13 Release of `ghyph31.tex'
%
%
% For more informations see the additional documentation
% at the end of this file.
%
% -----------------------------------------------------------------
%
\message{German Hyphenation Patterns `ghyphen' Version 3.1a <94/02/13>}
%
\begingroup
\ifnum 0\ifx\inputlineno\undefined \else
        \ifnum\inputlineno<1 \else 1\fi\fi<1
  \let\x=\endgroup
\else
  \def\x{\endgroup
%
% The following commands ensure correct \catcodes, \lccodes and
% \uccodes if your TeX implementations uses these character codes.
%
\catcode"E4=11 \catcode"C4=11 % \"a \"A
\catcode"F6=11 \catcode"D6=11 % \"o \"O
\catcode"FC=11 \catcode"DC=11 % \"u \"U
\catcode"FF=11 \catcode"DF=11 % \ss  SS
%
\lccode"C4="E4 \uccode"C4="C4  \lccode"E4="E4 \uccode"E4="C4
\lccode"D6="F6 \uccode"D6="D6  \lccode"F6="F6 \uccode"F6="D6
\lccode"DC="FC \uccode"DC="DC  \lccode"FC="FC \uccode"FC="DC
\lccode"DF="FF \uccode"DF="DF  \lccode"FF="FF \uccode"FF="DF
%
}
\fi
% Now execute the changes of the above \*codes for TeX 3.x
\x


%
% Next we define some commands, which are used inside the patterns.
% To keep them local, we enclose the rest of the file in a group
% (The \patterns command globally changes the hyphenation trie!).
%
\begingroup
%
% Because we use ^^e4, ^^f6, ... in the following definition,
% we have to ensure that the catcodes of ^^e and ^^f are ok
% for TeX 2.  (The macro is not used for TeX 2.)
\catcode"0E=12 \catcode"0F=12
%
% And we have to change the \lccode of ^^Y to make sure that
% we can include this character in the hyphenation patterns.
\catcode`\^^Y=11 \lccode`\^^Y=`\^^Y
%
% Define a simple " macro...
\catcode`\"=13
\def"#1{\ifx#1a^^e4\else \ifx#1o^^f6\else
  \ifx#1u^^fc\else
    \errmessage{Hyphenation pattern file corrupted!}%
  \fi\fi\fi}
%
% ... and define a macro to allow the use of this file
% with TeX 2 and TeX 3.
\ifnum 0\ifx\inputlineno\undefined \else
        \ifnum\inputlineno<1 \else 1\fi\fi<1
  % for TeX 2:
  %   ignore the patterns with umlauts
  \def\n#1{}
  %   ignore the duplicated patterns with \ss
  \def\c#1{}
  %   define \3 to be code ^^Y
  \def\3{^^Y}
\else
  % for TeX 3:
  %   patterns with umlauts are ok
  \def\n#1{#1}
  %   duplicated patterns are ok (for CM fonts)
  \def\c#1{#1}
  %   >>>>>>  UNCOMMENT the next line, if you do not want
  %   >>>>>>  to use fonts with CM layout
  %\def\c#1{}
  %   define \3 to be code `\^^ff (\ss in DC/EC font layout)
  %   define \9 to be code `\^^Y  (\ss in CM font layout)
  \def\3{^^ff}
  \def\9{^^Y}
\fi
%
%
\patterns{%
.aa6l .ab3a4s .ab3ei .abi2 .ab3it .ab1l .ab1r .ab3u .ad3o4r .alti6
.ana3c .an5alg .an1e .ang8s .an1s .ap1p .ar6sc .ar6ta .ar6tei .as2z
.au2f1 .au2s3 .be5erb .be3na .ber6t5r .bie6r5 .bim6s5t .brot3 .bru6s
.ch6 .che6f5 .da8c .da2r .dar5in .dar5u .den6ka .de5r6en .des6pe
.de8spo .de3sz .dia3s4 .dien4 .dy2s1 .ehren5 .eine6 .ei6n5eh .ei8nen
.ein5sa .en6der .en6d5r .en3k4 .en8ta8 .en8tei .en4t3r .epo1 .er6ban
.er6b5ei .er6bla .er6d5um .er3ei .er5er .er3in .er3o4b .erwi5s .es1p
.es8t .ex1a2 .ex3em .fal6sc .fe6st5a .flu4g3 .furch8 .ga6ner .ge3n4a
\n{.ge5r"o} .ges6 .halb5 .halbe6 .hal6br .haup4 .hau4t .heima6 .he4r3e
.her6za .he5x .hin3 .hir8sc .ho4c .hu3sa .hy5o .ibe5 .ima6ge .in1
.ini6 .is5chi .jagd5 .kal6k5o .ka6ph .ki4e .kop6f3 .kraf6 \n{.k"u5ra}
.lab6br .liie6 .lo6s5k \n{.l"o4s3t} .ma5d .mi2t1 .no6th .no6top
.obe8ri .ob1l .obs2 .ob6st5e .or3c .ort6s5e .ost3a .oste8r .pe4re
.pe3ts .ph6 .po8str .rau4m3 .re5an .ro8q .ru5the \n{.r"u5be}
\n{.r"u8stet} .sch8 .se6e .se5n6h .se5ra .si2e .spi6ke .st4 .sy2n
.tages5 .tan6kl .ta8th .te6e .te8str .to6der .to8nin .to6we .um1
.umpf4 .un1 .une6 .unge5n .ur1c .ur5en .ve6rin .vora8 .wah6l5 .we8ges
.wo6r .wor3a .wun4s .zi4e .zuch8 \n{."ande8re} \n{."och8} aa1c aa2gr
aal5e aa6r5a a5arti aa2s1t aat2s 6aba ab3art 1abdr 6abel aben6dr
ab5erk ab5err ab5esse 1abf 1abg \n{1abh"a} ab1ir 1abko a1bl ab1la
5ablag a6bla\3 \c{a6bla\9} ab4ler ab1lu \n{a8bl"a} \n{5a6bl"o} abma5c
1abn ab1ra ab1re 5a6brec ab1ro ab1s ab8sk abs2z 3abtei ab1ur 1abw
5abze 5abzu \n{ab1"an} \n{ab"au8} a4ce.  a5chal ach5art ach5au a1che
a8chent ach6er.  a6ch5erf a1chi ach1l ach3m ach5n a1cho ach3re a1chu
ach1w a1chy \n{ach5"af} ack1o acks6t ack5sta a1d 8ad.  a6d5ac ad3ant
ad8ar 5addi a8dein ade5o8 adi5en 1adj 1adle ad1op a2dre 3adres adt1
1adv \n{a6d"a} a1e2d ae1r a1er.  1aero 8afa a3fal af1an a5far a5fat
af1au a6fentl a2f1ex af1fr af5rau af1re 1afri af6tent af6tra aft5re
a6f5um \n{8af"a} ag5abe 5a4gent ag8er ages5e 1aggr ag5las ag1lo a1gn
ag2ne 1agog a6g5und a1ha a1he ah5ein a4h3erh a1hi ahl1a ah1le ah4m3ar
ahn1a a5ho ahra6 ahr5ab ah1re ah8rei ahren8s ahre4s3 ahr8ti ah1ru a1hu
\n{ah8"o} ai3d2s ai1e aif6 a3inse ai4re.  a5isch.  ais8e a3ismu ais6n
aiso6 a1j 1akad a4kade a1ke a1ki 1akko 5akro1 a5lal al5ans 3al8arm
al8beb al8berw alb5la 3album al1c a1le a6l5e6be a4l3ein a8lel a8lerb
a8lerh a6lert 5a6l5eth 1algi al4gli al3int al4lab al8lan al4l3ar
alle3g a1lo a4l5ob al6schm al4the altist5 al4t3re 8a1lu alu5i a6lur
alu3ta \n{a1l"a} a6mate 8ame.  5a6meise am6m5ei am6mum am2n ampf3a
am6schw am2ta a1mu \n{a1m"a} a3nac a1nad anadi5e an3ako an3alp 3analy
an3ame an3ara a1nas an5asti a1nat anat5s an8dent ande4s3 an1ec an5eis
an1e2k 4aner.  a6n5erd a8nerf a6n5erke 1anfa 5anfert \n{1anf"a} 3angab
5angebo an3gli ang6lis an2gn 3angri ang5t6 \n{5anh"a} ani5g ani4ka
an5i8on an1kl an6kno an4kro 1anl anma5c anmar4 3annah anne4s3 a1no
5a6n1o2d 5a6n3oma 5a6nord 1anr an1sa 5anschl an4soz an1st 5anstal
an1s2z 5antenn an1th \n{5anw"a} a5ny an4z3ed 5anzeig 5anzieh 3anzug
\n{an1"a} \n{5an"as} \n{a1n"o} \n{an"o8d} a1os a1pa 3apfel a2ph1t
\n{aph5"a6} a1pi 8apl apo1c apo1s a6poste a6poth 1appa ap1pr a1pr
\n{a5p"a} \n{a3p"u} a1ra a4r3af ar3all 3arbei 2arbt ar1c 2a1re ar3ein
ar2gl 2a1ri ari5es ar8kers ar6les ar4nan ar5o6ch ar1o2d a1rol ar3ony
a8ror a3ros ar5ox ar6schl 8artei ar6t5ri a1ru a1ry 1arzt arz1w
\n{ar8z"a} \n{ar"a8m} \n{ar"o6} \n{ar5"om} \n{ar1"u2} a1sa a6schec
asch5l asch3m a6schn a3s4hi as1pa asp5l a8steb as5tev 1asth a6stoc
a1str ast3re 8a1ta ata5c ata3la a6tapf ata5pl a1te a6teli aten5a
ate5ran 6atf 6atg a1th at3hal 1athl 2a1ti 5atlant 3atlas 8atmus 6atn
a1to a6t5ops ato6ra a6t5ort.  4a1tr a6t5ru at2t1h \n{at5t6h"a} 6a1tu
atz1w \n{a1t"a} \n{a1t"u} au1a au6bre auch3a au1e aue4l 5aufent
\n{3auff"u} 3aufga 1aufn auf1t 3auftr 1aufw 3auge.  au4kle aule8s 6aum
au8mar aum5p 1ausb 3ausd 1ausf 1ausg au8sin 3auss au4sta 1ausw 1ausz
aut5eng au1th 1auto au\3e8 \c{au\9e8} a1v ave5r6a aver6i a1w a6wes a1x
a2xia a6xio a1ya a1z azi5er.  8a\3 \c{8a\9} 1ba 8ba8del ba1la ba1na
ban6k5r ba5ot bardi6n ba1ro basten6 bau3sp 2b1b bb6le b2bli 2b1c 2b1d
1be be1a be8at.  be1ch 8becht 8becke.  be5el be1en bee8rei be5eta bef2
8beff be1g2 \n{beh"o8} bei1s 6b5eisen bei3tr b8el bel8o belu3t be3nac
bend6o be6ners be6nerw be4nor ben4se6 bens5el \n{be1n"a} \n{be1n"u}
be1o2 b8er.  be1ra be8rac ber8gab.  ber1r \n{be1r"u} bes8c bes5erh
bes2p be5tha bet5sc be1un be1ur 8bex be6zwec 2b1f8 bfe6st5e 2b1g2
bga2s5 bge1 2b1h bhole6 1bi bi1bl b6ie bi1el bi1la \n{bil"a5} bi1na
bi4nok bi5str bi6stu bi5tr bit4t5r b1j 2b1k2 \n{bk"u6} bl8 b6la.
6b1lad 6blag 8blam 1blat b8latt 3blau.  b6lav 3ble.  b1leb b1led
8b1leg 8b1leh 8bleid 8bleih 6b3lein blei3s ble4m3o 4blich b4lind
8bling b2lio 5blit b4litz b1loh 8b1los 1blu 5blum 2blun blut3a blut5sc
\n{3bl"a} \n{bl"as5c} \n{5bl"o} \n{3bl"u} \n{bl"u8sc} 2b1m 2b1n 1bo
bo1ch bo5d6s boe5 8boff 8bonk bo1ra b1ort 2b1p2 b1q 1br brail6 brast8
bre4a b5red 8bref 8b5riem b6riga bro1s b1rup b2ruz \n{8br"oh}
\n{br"os5c} 8bs b1sa b8sang b2s1ar b1sc bs3erl bs3erz b8sof b1s2p
bst1h b3stru \n{b5st"a} b6sun 2b1t b2t1h 1bu bu1ie bul6k b8ure bu6sin
6b1v 2b1w 1by1 by6te.  8b1z bzi1s \n{1b"a} \n{b5"a6s5} \n{1b"u}
\n{b6"u5bere} \n{b"uge6} \n{b"ugel5e} \n{b"ur6sc} 1ca cag6 ca5la ca6re
ca5y c1c 1ce celi4c celich5 ce1ro c8h 2ch.  1chae ch1ah ch3akt cha6mer
8chanz 5chara 3chari 5chato 6chb 1chef 6chei ch3eil ch3eis 6cherkl
6chf 4chh 5chiad 5chias 6chins 8chj chl6 5chlor 6ch2m 2chn6 ch8nie
5cho.  8chob choi8d 6chp ch3ren ch6res \n{ch3r"u} 2chs 2cht cht5ha
cht3hi 5chthon ch6tin 6chuh chu4la 6ch3unt chut6t 8chw 1ci ci5tr c2k
2ck.  ck1ei 4ckh ck3l ck3n ck5o8f ck1r 2cks ck5stra ck6s5u c2l 1c8o
con6ne 8corb cos6t c3q 1c6r 8c1t 1cu 1cy \n{5c"a1} \n{c"o5} 1da.
8daas 2dabg 8dabr 6dabt 6dabw 1dac da2gr 6d5alk 8d5amt dan6ce.
dani5er dan8ker 2danl danla6 6dans 8danzi 6danzu d1ap da2r1a8 2d1arb
d3arc dar6men 4d3art 8darz 1dat 8datm 2d1auf 2d1aus 2d1b 2d1c 2d1d
d5de d3d2h \n{dd"amme8} 1de 2deal de5an de3cha de1e defe6 6deff 2d1ehr
5d4eic de5isc de8lar del6s5e del6spr de4mag de8mun de8nep dene6r
8denge.  8dengen de5o6d 2deol de5ram 8derdb der5ein de1ro der1r d8ers
der5um de4s3am de4s3an de4sau de6sil de4sin de8sor de4spr de2su 8deul
de5us.  2d1f df2l 2d1g 2d1h 1di dia5c di5ara dice5 di3chr di5ena di1gn
di1la dil8s di1na 8dind 6dinf 4d3inh 2d1ins di5o6d di3p4t di8sen dis1p
di5s8per di6s5to dis5tra di8tan di8tin d1j 6dje 2dju 2d1k 2d1l 2d1m
2d1n6 dni6 dnje6 1do 6d5obe do6berf 6d5ony do3ran 6dord 2d1org dor4t3h
do6ste 6doth dott8e 2d1p d5q dr4 1drah 8drak d5rand 6dre.  4drech
d6reck 4d3reg 8d3reic d5reife 8drem 8d1ren 2drer 8dres.  6d5rh 1dria
d1ric 8drind droi6 dro5x 1dru 8drut \n{dr"os5c} \n{1dr"u} \n{dr"u5b}
\n{dr"u8sc} 2ds d1sa d6san dsat6 d1sc 5d6scha.  5dschik dse8e d8serg
8dsl d1sp d4spak ds2po \n{d8sp"a} d1st \n{d1s"u} 2dt d1ta d1te d1ti
d1to dt1s6 d1tu \n{d5t"a} 1du du5als du1b6 du1e duf4t3r 4d3uh du5ie
8duml 8dumw 2d1und du8ni 6d5unt dur2c durch3 6durl 6dursa 8durt du1s
du8schr 2d1v 2d1w dwa8l 2d1z \n{1d"a} \n{6d"ah} \n{8d"and} \n{d"a6r}
\n{d"o8bl} \n{d5"ol} \n{d"or6fl} \n{d"o8sc} \n{d5"o4st} \n{d"os3te}
\n{1d"u} ea4ben e1ac e1ah e1akt e1al.  e5alf e1alg e5a8lin e1alk e1all
e5alp e1alt e5alw e1am e1and ea6nim e1ar.  e5arf e1ark e5arm e3art
e5at.  e6ate e6a5t6l e8ats e5att e6au.  e1aus e1b e6b5am ebens5e
eb4lie eb4ser eb4s3in e1che e8cherz e1chi ech3m 8ech3n ech1r ech8send
ech4su e1chu eck5an e5cl e1d ee5a ee3e ee5g e1ei ee5isc eei4s3t
ee6lend e1ell \n{ee5l"o} e1erd ee3r4e ee8reng eere6s5 \n{ee5r"a}
ee6tat e1ex e1f e6fau e8fe8b 3effek ef3rom ege6ra eglo6si 1egy e1ha
e6h5ach eh5ans e6hap eh5auf e1he e1hi ehl3a eh1le ehl5ein eh1mu ehn5ec
e1ho ehr1a eh1re ehre6n eh1ri eh1ru ehr5um e1hu eh1w e1hy \n{e1h"a}
\n{e1h"o} \n{e3h"ut} ei1a eia6s ei6bar eich3a eich5r ei4dar ei6d5ei
ei8derf ei3d4sc ei1e 8eifen 3eifri 1eign eil1d ei6mab ei8mag ein1a4
ei8nat ei8nerh ei8ness ei6nete ein1g e8ini ein1k ei6n5od ei8nok ei4nor
\n{e3ins"a} ei1o e1irr ei5ru ei8sab ei5schn ei6s5ent ei8sol ei4t3al
eit3ar eit1h ei6thi ei8tho eit8samt ei6t5um e1j 1ekd e1ke e1ki e1k2l
e1kn ekni4 e1la e2l1al 6elan e6lanf e8lanl e6l5ans el3arb el3arm
e6l3art 5e6lasti e6lauge elbst5a e1le 6elef ele6h e6l5ehe e8leif
e6l5einh 1elek e8lel 3eleme e6lemen e6lente el5epi e4l3err e6l5ersc
elf2l elg2 e6l5ins ell8er 4e1lo e4l3ofe el8soh el8tent 5eltern e1lu
elut2 \n{e1l"a} \n{e1l"u} em8dei em8meis 4emo emo5s 1emp1f 1empt 1emto
e1mu emurk4 emurks5 \n{e1m"a} en5a6ben en5achs en5ack e1nad en5af
en5all en3alt en1am en3an.  en3ant en3anz en1a6p en1ar en1a6s 6e1nat
en3auf en3aus en2ce enda6l end5erf end5erg en8dess 4ene.  en5eck
e8neff e6n5ehr e6n5eim en3eis 6enem.  6enen e4nent 4ener.  e8nerd
e6n3erf e4nerg 5energi e6n5erla en5ers e6nerst en5erw 6enes e6n5ess
e2nex en3glo 2eni enni6s5 ennos4 enns8 e1no e6nober eno8f en5opf
e4n3ord en8sers ens8kl en1sp ens6por en5t6ag enta5go en8terbu en6tid
3entla ent5ric 5entwic 5entwu 1entz enu5i e3ny en8zan \n{en1"of}
\n{e1n"os} \n{e1n"ug} eo1c e5o6fe e5okk e1on.  e3onf e5onk e5onl e5onr
e5opf e5ops e5or.  e1ord e1org eo5r6h eo1t e1pa e8pee e6p5e6g ep5ent
e1p2f e1pi 5epid e6pidem e1pl 5epos e6pos.  ep4p3a e1pr \n{e1p"a} e1q
e1ra.  er5aal 8eraba e5rabel er5a6ben e5rabi er3abs er3ach era5e
era5k6l er3all er3amt e3rand e3rane er3ans e5ranz.  e1rap er3arc
e3rari er3a6si e1rat erat3s er3auf e3raum 3erbse er1c e1re 4e5re.
er3eck er5egg er5e2h 2erei e3rei.  e8reine er5einr 6eren.  e4r3enm
4erer.  e6r5erm er5ero er5erst e4r3erz er3ess \n{5erf"ul} er8gan.
5ergebn er2g5h \n{5erg"anz} \n{5erh"ohu} 2e1ri eri5ak e6r5iat e4r3ind
e6r5i6n5i6 er5ins e6r5int er5itio er1kl \n{3erkl"a} \n{5erl"os.}
ermen6s er6nab 3ernst 6e1ro.  e1rod er1o2f e1rog 6e3roi ero8ide e3rol
e1rom e1ron e3rop8 e2r1or e1ros e1rot er5ox ersch4 5erstat er6t5ein
er2t1h er5t6her 2e1ru eruf4s3 e4r3uhr er3ums e5rus 5erwerb e1ry er5zwa
er3zwu \n{er"a8m} \n{er5"as} \n{er"o8} \n{e3r"os.} \n{e6r1"u2b} e1sa
esa8b e8sap e6s5a6v e1sc esch4l ese1a es5ebe eserve5 e8sh es5ill
es3int es4kop e2sl eso8b e1sp espei6s5 es2po es2pu 5essenz e6stabs
e6staf e6st5ak est3ar e8stob e1str est5res es3ur e2sz \n{e1s"u} e1ta
et8ag etari5e eta8ta e1te eten6te et5hal e5thel e1ti 1etn e1to e1tr
et3rec e8tscha et8se et6tei et2th et2t1r e1tu etu1s et8zent et8zw
\n{e1t"a} \n{e1t"o} \n{e1t"u} eu1a2 eu1e eue8rei eu5fe euin5 euk2
e1um.  eu6nio e5unter eu1o6 eu5p 3europ eu1sp eu5str eu8zo e1v eval6s
eve5r6en ever4i e1w e2wig ex1or 1exp 1extr ey3er.  e1z \n{e1"a2}
\n{e5"o8} \n{e1"u} e8\3es \c{e8\9es} fa6ch5i fade8 fa6del fa5el.
fal6lo falt8e fa1na fan4gr 6fanl 6fap far6ba far4bl far6r5a 2f1art
fa1sc fau8str fa3y 2f1b2 6f1c 2f1d 1fe 2f1eck fe6dr feh6lei f6eim
8feins f5eis fel5en 8feltern 8femp fe5rant 4ferd.  ferri8 fe8stof
fe6str fe6stum fe8tag fet6ta fex1 2ff f1fa f6f5arm f5fe ffe5in ffe6la
ffe8ler ff1f f1fla ff3lei ff4lie ff8sa ff6s5ta 2f1g2 fgewen6 4f1h 1fi
fid4 fi3ds fieb4 fi1la fi8lei fil4m5a f8in.  fi1na 8finf fi8scho fi6u
6f1j 2f1k2 f8lanz fl8e 4f3lein 8flib 4fling f2lix 6f3lon 5flop 1flor
\n{5f8l"ac} \n{3fl"ot} 2f1m 2f1n 1fo foh1 f2on fo6na 2f1op fo5ra
for8mei for8str for8th for6t5r fo5ru 6f5otte 2f1p8 f1q fr6 f5ram
1f8ran f8ra\3 \c{f8ra\9} f8re.  frei1 5frei.  f3reic f3rest f1rib
8f1ric 6frig 1fris fro8na \n{fr"as5t} 2fs f1sc f2s1er f5str
\n{fs3t"at} 2ft f1tak f1te ft5e6h ftere6 ft1h f1ti f5to f1tr ft5rad
ft1sc ft2so f1tu ftwi3d4 ft1z 1fu 6f5ums 6funf fun4ka fu8\3end
\c{fu8\9end} 6f1v 2f1w 2f1z \n{1f"a} \n{f"a1c} \n{8f"arm} \n{6f"aug}
\n{f"a8\3} \n{\c{f"a8\9}} \n{f"ode3} \n{8f"of} \n{3f"or} \n{1f"u}
\n{f"un4f3u} 1ga ga6bl 6gabw 8gabz g3a4der ga8ho ga5isc 4gak ga1la
6g5amt ga1na gan5erb gan6g5a ga5nj 6ganl 8gansc 6garb 2g1arc 2g1arm
ga5ro 6g3arti ga8sa ga8sc ga6stre 2g1atm 6g5auf gau5fr g5aus 2g1b g5c
6gd g1da 1ge ge1a2 ge6an ge8at.  ge1e2 ge6es gef2 8geff ge1g2l ge1im
4g3eise geist5r gel8bra gelt8s \n{ge5l"o} ge8nin gen3k 6g5entf
\n{ge3n"a} ge1or ge1ra ge6rab ger8au \n{8gerh"o} ger8ins ge1ro 6g5erz.
\n{ge1r"a} \n{ge1r"u} ge1s ges2p ge5unt 4g3ex3 2g1f8 2g1g g1ha 6g1hei
5ghel.  g5henn 6g1hi g1ho 1ghr \n{g1h"o} 1gi gi5la gi8me.  gi1na
4g3ins gi3str g1j 2g1k 8gl.  1glad g5lag glan4z3 1glas 6glass 5glaub
g3lauf 1gle.  g5leb 3gleic g3lein 5gleis 1glem 2gler 8g3leu gli8a
g2lie 3glied 1g2lik 1g2lim g6lio 1gloa 5glom 1glon 1glop g1los g4loss
g5luf 1g2ly \n{1gl"u} 2g1m gn8 6gn.  1gna 8gnach 2gnah g1nas g8neu
g2nie g3nis 1gno 8gnot 1go goe1 8gof 2gog 5gogr 6g5oh goni5e 6gonist
go1ra 8gord 2g1p2 g1q 1gr4 g5rahm gra8m gra4s3t 6g1rec gre6ge 4g3reic
g5reit 8grenn gri4e g5riem 5grif 2grig g5ring 6groh 2grot gro6\3
\c{gro6\9} 4grut 2gs gs1ab g5sah gs1ak gs1an gs8and gs1ar gs1au g1sc
gs1ef g5seil gs5ein g2s1er gs1in g2s1o gso2r gs1pr g2s1u 2g1t g3te
g2t1h 1gu gu5as gu2e 2gue.  6gued 4g3uh 8gums 6g5unt gu1s gut3h gu2tu
4g1v 2g1w gy1n g1z \n{1g"a} \n{8g"a8m} \n{6g"arm} \n{1g"o} \n{1g"u}
\n{6g"ub} 1haa hab8r ha8del hade4n 8hae ha5el.  haf6tr 2hal.  ha1la
hal4b5a 6hale 8han.  ha1na han6dr han6ge.  2hani h5anth 6hanz 6harb
h3arbe h3arme ha5ro ha2t1h h1atm hau6san ha8\3 \c{ha8\9} h1b2 h1c h1d
he2bl he3cho h3echt he5d6s 5heft h5e6he.  hei8ds h1eif 2hein he3ism
he5ist.  heit8s3 hek6ta hel8lau 8helt he6mer 1hemm 6h1emp hen5end
hen5klo hen6tri he2nu 8heo he8q her3ab he5rak her3an 4herap her3au
h3erbi he1ro he8ro8b he4r3um her6z5er he4spe he1st heta6 het5am he5th
heu3sc he1xa hey5e h1f2 h1g hgol8 h1h h1iat hie6r5i hi5kt hil1a2
hil4fr hi5nak hin4ta hi2nu hi5ob hirn5e hir6ner hi1sp hi1th hi5tr
5hitz h1j h6jo h1k2 hlabb4 hla4ga hla6gr h5lai hl8am h1las h1la\3
\c{h1la\9} hl1c h1led h3lein h5ler.  h2lif h2lim h8linf hl5int h2lip
h2lit h4lor h3lose \n{h1l"as} hme5e h2nee h2nei hn3eig h2nel hne8n
hne4p3f hn8erz h6netz h2nip h2nit h1nol hn5sp h2nuc h2nud h2nul hoch1
1hoh hoh8lei 2hoi ho4l3ar 1holz h2on ho1ra 6horg 5horn.  ho3sl hos1p
ho4spi h1p hpi6 h1q 6hr h1rai h8rank h5raum hr1c hrcre8 h1red h3reg
h8rei.  h4r3erb h8rert hrg2 h1ric hr5ins h2rom hr6t5erl hr2t1h hr6t5ra
hr8tri h6rum hr1z hs3ach h6s5amt h1sc h6s5ec h6s5erl hs8erle h4sob
h1sp h8spa\3 \c{h8spa\9} h8spel hs6po h4spun h1str h4s3tum hs3und
\n{h1s"u} h5ta.  h5tab ht3ac ht1ak ht3ang h5tanz ht1ar ht1at h5taub
h1te h2t1ec ht3eff ht3ehe h4t3eif h8teim h4t3ein ht3eis h6temp h8tentf
hte8ren \n{h6terf"u} h8tergr h4t3erh h6t5ersc h8terst h8tese h8tess
h2t1eu h4t3ex ht1he ht5hu h1ti ht5rak hts3ah ht1sc ht6sex ht8sk ht8so
h1tu htz8 \n{h5t"um} hub5l hu6b5r huh1l h5uhr.  huld5a6 hu8lent
\n{hu8l"a} h5up.  h1v h5weib h3weis h1z \n{h"a8kl} \n{h"al8s}
\n{h"ama8tu8} \n{h"a8sche.} \n{h"at1s} \n{h"au4s3c} \n{2h"o.}
\n{2h"oe} \n{8h"oi} \n{h"o6s} \n{h"os5c} \n{h"uhne6} \n{h"ul4s3t}
\n{h"utte8re} i5adn i1af i5ak.  i1al.  i1al1a i1alb i1ald i5alei i1alf
i1alg i3alh i1alk i1all i1alp i1alr i1als i1alt i1alv i5alw i3alz
i1an.  ia5na i3and ian8e ia8ne8b i1ang i3ank i5ann i1ant i1anz i6apo
i1ar.  ia6rab i5arr i1as.  i1asm i1ass i5ast.  i1at.  i5ats i1au i5azz
i6b5eig i6b5eis ib2le i4blis i6brig i6b5unt \n{i6b"ub} i1che ich5ei
i6cherb i1chi ich5ins ich1l ich3m ich1n i1cho icht5an icht3r i1chu
ich1w ick6s5te ic5l i1d id3arm 3ideal ide8na 3ideol \n{ide5r"o} i6diot
id5rec id1t ie1a ie6b5ar iebe4s3 ie2bl ieb1r ie8bra ie4bre \n{ie8b"a}
ie2dr ie1e8 ie6f5ad ief5f ie2f1l ie4fro ief1t i1ei ie4l3ec ie8lei
ie4lek i3ell i1en.  i1end ien6e i3enf i5enn ien6ne.  i1enp i1enr
i5ensa ien8stal i5env i1enz ie5o ier3a4b ie4rap i2ere ie4rec ie6r5ein
ie6r5eis ier8er i3ern.  ie8rum ie8rund ie6s5che ie6tau ie8tert ie5the
ie6t5ri i1ett ie5un iex5 2if i1fa if5ang i6fau if1fr if5lac i5f6lie
i1fre ift5a if6t5r ig3art 2ige i8gess ig5he i5gla ig2ni i5go ig3rot
ig3s2p i1ha i8ham i8hans i1he i1hi ih1n ih1r i1hu i8hum ih1w 8i1i ii2s
ii2t i1j i1k i6kak i8kerz i6kes ik4ler i6k5unt 2il i5lac i1lag il3ans
i5las i1lau il6auf i1le ile8h i8lel il2fl il3ipp il6l5enn i1lo ilt8e
i1lu \n{i1l"a} i8mart imb2 i8mele i8mid imme6l5a i1mu \n{i1m"a}
\n{i5m"o} ina5he i1nat in1au inau8s 8ind.  in4d3an 5index ind2r 3indus
i5nec i2n1ei i8nerw 3infek 1info 5ingeni ing5s6o 5inhab ini5er.  5inj
\n{in8k"at} in8nan i1no inoi8d in3o4ku in5sau in1sp 5inspe 5instit
5instru ins4ze 5intere 5interv in3the in5t2r i5ny \n{in"a2} \n{i1n"ar}
\n{in1"as} \n{in"o8} \n{in5"od} \n{i1n"os} 2io io1a8 io1c iode4 io2di
ioi8 i1ol.  i1om.  i1on.  i5onb ion2s1 i1ont i5ops i5o8pt i1or.
i3oral io3rat i5orc i1os.  i1ot.  i1o8x 2ip i1pa i1pi i1p2l i1pr i1q
i1ra ir6bl i1re i1ri ir8me8d ir2m1o2 ir8nak i1ro ir5rho ir6schl
ir6sch5r i5rus i5ry \n{i5r"a} i1sa i8samt i6sar i2s1au i8scheh i8schei
isch5m isch3r \n{isch"a8} is8ele ise3ra i4s3erh is3err isi6de i8sind
is4kop ison5e is6por i8s5tum i5sty \n{i5s"o} i1ta it5ab.  i2t1a2m
i8tax i1te i8tersc i1thi i1tho i5thr \n{it8h"a} i1ti i8ti8d iti6kl
itmen4 i1to i8tof it3ran it3rau i1tri itri5o it1sc it2se it5spa it8tru
i1tu it6z5erg it6z1w \n{i1t"a} \n{it"a6r5e} \n{it"at2} \n{it"ats5}
\n{i1t"u} i1u iu6r 2i1v i6vad iva8tin i8vei i6v5ene i8verh i2vob i8vur
i1w iwi2 i5xa i1xe i1z ize8n i8zir i6z5w \n{i"a8m} \n{i1"a6r}
\n{i5"at.} \n{i5"av} \n{i1"o8} \n{i"u8} i6\35ers \c{i6\95ers} ja5la
je2t3r 6jm 5jo jo5as jo1ra jou6l ju5cha jugen4 jugend5 jung5s6 ju1s
\n{3j"a} 1ka 8kachs 8kakz ka1la kal5d kam5t ka1na 2kanl 8kapf ka6pl
ka5r6a 6k3arbe ka1ro kar6p5f 4k3arti 8karz \n{ka1r"a} kasi5e ka6teb
kat8ta kauf6s kau3t2 2k1b 2k1c 4k1d kehr6s kehrs5a 8keic 2k1eig 6k5ein
6k5eis ke6lar ke8leis ke8lo 8kemp k5ente.  k3entf 8k5ents 6kentz ke1ra
k5erlau 2k1f8 2k1g 2k1h ki5fl 8kik king6s5 6kinh ki5os ki5sp ki5th
\n{8ki8"o} 2k1k2 kl8 1kla 8klac k5lager kle4br k3leib 3kleid kle5isc
4k3leit k3lek 6k5ler.  5klet 2klic 8klig k2lim k2lin 5klip 5klop k3lor
\n{1kl"a} 2k1m kmani5e kn8 6kner k2ni \n{kn"a8} 1k2o ko1a2 ko6de.
ko1i koi8t ko6min ko1op ko1or ko6pht ko3ra kor6d5er ko5ru ko5t6sc k3ou
3kow 6k5ox 2k1p2 k1q 1kr8 4k3rad 2k1rec 4k3reic kre5ie 2krib 6krig
2krip 6kroba 2ks k1sa k6sab ksal8s k8samt k6san k1sc k2s1ex k5spat
k5spe k8spil ks6por k1spr kst8 k2s1uf 2k1t kta8l kt5a6re k8tein kte8re
k2t1h k8tinf kt3rec kt1s 1ku ku1ch kuck8 k3uhr ku5ie kum2s1 kunfts5
kun2s kunst3 ku8rau ku4ro kurz1 ku1st 4kusti ku1ta ku8\3 \c{ku8\9}
6k1v 2k1w ky5n 2k1z \n{1k"a} \n{k"a4m} \n{4k3"ami} \n{k"ase5} \n{1k"o}
\n{k"o1c} \n{k"o1s} \n{1k"u} \n{k"u1c} \n{k"ur6sc} \n{k"u1s} 1la.
8labf 8labh lab2r 2l1abs lach3r la8dr 5ladu 8ladv 6laff laf5t la2gn
5laken 8lamb la6mer 5lampe.  2l1amt la1na 1land lan4d3a lan4d3r lan4gr
8lanme 6lann 8lanw \n{6lan"a} 8lappa lap8pl lap6pr l8ar.  la5ra lar4af
la8rag la8ran la6r5a6s l3arbe la8rei 6larm.  la8sa la1sc la8sta lat8i
6l5atm 4lauss 4lauto 1law 2lb l8bab l8bauf l8bede l4b3ins l5blo
lbst5an lbst3e 8lc l1che l8chert l1chi lch3m l5cho lch5w 6ld l4d3ei
ld1re \n{l6d"ub} le2bl le8bre lecht6s5 led2r 6leff le4gas 1lehr lei6br
le8inf 8leinn 5leistu 4lektr le6l5ers lemo2 8lemp l8en.  8lends
6lendun le8nend len8erw 6l5ents 4l3entw 4lentz 8lenzy 8leoz 6lepi
le6pip 8lepo 1ler l6er.  8lerbs 6l5erde le8reis le8rend le4r3er 4l3erg
l8ergr 6lerkl 6l5erzie \n{8ler"o} 8lesel lesi5e le3sko le3tha let1s
5leuc 4leuro leu4s3t le5xe 6lexp l1f 2l1g lgend8 l8gh lglie3 lglied6
6l1h 1li li1ar li1as 2lick li8dr li1en lien6n li8ers li8ert 2lie\3
\c{2lie\9} 3lig li8ga8b li1g6n li1l8a 8limb li1na 4l3indu lings5
4l3inh 6linj link4s3 4linkt 2lint 8linv lion5s6t 4lipp 5lipt 4lisam
livi5e 6l1j 6l1k l8keim l8kj lk2l lko8f lkor8 lk2sa lk2se 6ll l1la
ll3a4be l8labt ll8anl ll1b ll1c ll1d6 l1le l4l3eim l6l5eise ller3a
l4leti l5lip l1lo ll3ort ll5ov ll6spr llte8 l1lu ll3urg \n{l1l"a}
\n{l5l"u} \n{l6l"ub} 2l1m l6m5o6d 6ln l1na l1no 8lobl lo6br 3loch.
l5o4fen 5loge.  5lohn 4l3ohr 1lok l2on 4l3o4per lo1ra 2l1ord 6lorg
4lort lo1ru 1los.  lo8sei 3losig lo6ve lowi5 6l1p lp2f l8pho l8pn
lp4s3te l2pt l1q 8l1r 2ls l1sa l6sarm l1sc l8sec l6s5erg l4s3ers l8sh
l5s6la l1sp ls4por ls2pu l1str l8suni \n{l1s"u} 2l1t lt5amp l4t3ein
l5ten l6t5eng l6t5erp l4t3hei lt3her l2t1ho l6t5i6b lti1l \n{l8tr"o}
lt1sc lt6ser lt4s3o lt5ums lu8br lu2dr lu1en8 8lu8fe luft3a luf8tr
lu6g5r 2luh l1uhr lu5it 5luk 2l1umf 2l1umw 1lun 6l5u6nio 4l3unte lu5ol
4lurg 6lurs l3urt lu4sto lu3str lu6st5re lu8su lu6tal lu6t5e6g lu8terg
lu3the lu6t5or lu2t1r lu6\35 \c{lu6\95} l1v lve5r6u 2l1w 1ly lya6
6lymp ly1no l8zess l8zo8f l3zwei lz5wu \n{3l"and} \n{l"a5on}
\n{l"a6sc} \n{l"at1s} \n{5l"auf} \n{2l"aug} \n{l"au6s5c} \n{l"a5v}
\n{l1"ol} \n{1l"os} \n{l"o1\36t} \n{\c{l"o1\96t}} \n{6l1"ube} 1ma
8mabg ma5chan mad2 ma5el 4magg mag8n ma1la ma8lau mal5d 8malde mali5e
malu8 ma8lut 2m1amp 3man mand2 man3ds 8mangr mani5o 8m5anst 6mappa
4m3arbe mar8kr ma1r4o mar8schm 3mas ma1sc \n{ma1t"o} 4m5auf ma5yo 2m1b
mb6r 2m1c 2m1d \n{md6s"a} 1me me1ch me5isc 5meld mel8sa 8memp me5nal
men4dr men8schl men8schw 8mentsp me1ra mer4gl me1ro 3mes me6s5ei me1th
me8\3 \c{me8\9} 2m1f6 2m1g 2m1h 1mi mi1a mi6ale mi1la 2m1imm mi1na
\n{mi5n"u} mi4s3an mit1h mi5t6ra 3mitt mitta8 mi6\35 \c{mi6\95} 6mj
2m1k8 2m1l 2m1m m6mad m6m5ak m8menth m8mentw mme6ra m2mn mm5sp mm5ums
mmut5s \n{m8m"an} m1n8 m5ni 1mo mo5ar mo4dr 8mof mo8gal mo4kla mol5d
m2on mon8do mo4n3od mont8a 6m5ony mopa6 mo1ra mor8d5a mo1sc mo1sp 5mot
moy5 2mp m1pa mpfa6 mpf3l mphe6 m1pi mpin6 m1pl mp2li m2plu mpo8ste
m1pr \n{mpr"a5} mp8th mput6 mpu5ts \n{m1p"o} 8m1q 2m1r 2ms ms5au m1sc
msch4l ms6po m3spri m1str 2m1t mt1ar m8tein m2t1h mt6se \n{mt8s"a}
mu5e 6m5uh mumi1 1mun mun6dr muse5e mu1ta 2m1v mvol2 mvoll3 2m1w 1my
2m1z \n{m"a6kl} \n{1m"an} \n{m"a1s} \n{m"a5tr} \n{m"au4s3c} \n{3m"a\3}
\n{\c{3m"a\9}} \n{m"ob2} \n{6m"ol} \n{1m"u} \n{5m"un} \n{3m"ut} 1na.
n5ab.  8nabn n1abs n1abz \n{na6b"a} na2c nach3e 3nacht 1nae na5el
n1afr 1nag 1n2ah na8ha na8ho 1nai 6nair na4kol n1akt nal1a 8naly 1nama
na4mer na1mn n1amp 8n1amt 5nanc nan6ce n1and n6and.  2n1ang 1nani
1nann n1ans 8nanw 5napf.  1n2ar.  na2ra 2n1arc n8ard 1nari n8ark
6n1arm 5n6ars 2n1art n8arv 6natm nat6s5e 1naue 4nauf n3aug 5naui n5auk
na5um 6nausb 6nauto 1nav 2nax 3naz 1na\3 \c{1na\9} n1b2 nbau5s n1c
nche5e nch5m 2n1d nda8d n2d1ak nd5ans n2d1ei nde8lac ndel6sa n8derhi
nde4se nde8stal n2dj ndnis5 n6d5or6t nd3rec nd3rot nd8samt nd6sau
ndt1h n8dumd 1ne ne5as ne2bl 6n5ebn 2nec 5neei ne5en ne1g4l 2negy
4n1ein 8neis 4n3e4lem 8nemb 2n1emp nen1a 6n5energ nen3k 8nentb
4n3en3th 8nentl 8n5entn 8n5ents ne1ra ne5r8al ne8ras 8nerbi 6n5erde.
nere5i6d nerfor6 \n{6n5erh"o} \n{8nerl"o} 2n1err n8ers.  6n5ertra
2n1erz nesi3e net1h neu4ra neu5sc 8neu\3 \c{8neu\9} n1f nf5f nf2l
nflei8 nf5lin nft8st n8g5ac ng5d ng8en nge8ram ngg2 ng1h n6glic ng3rip
ng8ru ng2se4 ng2si n2g1um n1gy \n{n8g"al} n1h nhe6r5e 1ni ni1bl
\n{ni5ch"a} ni8dee n6ie ni1en nie6s5te niet5h ni8etn 4n3i6gel n6ik
ni1la 2n1imp ni5na 2n1ind 8ninf 6n5inh ni8nit 6n5inn 2n1ins 4n1int
n6is ni3str ni1th ni1tr n1j n6ji n8kad nk5ans n1ke n8kerla n1ki nk5inh
\n{n5kl"o} n1k2n n8k5not nk3rot \n{n8kr"u} nk5spo nk6t5r n8kuh
\n{n6k"ub} n5l6 nli4mi n1m nmen4s n1na n8nerg nni5o n1no nn4t3ak nnt1h
nnu1e n1ny \n{n1n"a} \n{n1n"o} \n{n1n"u} no5a no4b3la 4n3obs 2nobt
noche8 no6die no4dis no8ia no5isc 6n5o6leu no4mal noni6er 2n1onk n1ony
4n3o4per 6nopf 6nopti no3ra no4ram nor6da 4n1org 2n1ort n6os no1st
8nost.  no8tan no8ter noty6pe 6n5ox n1p2 n1q n1r \n{nr"os3} 6ns n1sac
ns3ang n1sc n8self n8s5erf n8serg n6serk ns5erw n8sint n1s2pe n1spr
n6s5tat.  n5s6te.  n6stob n1str n1ta n4t3a4go nt5anh nt3ark nt3art
n1te nt3eis nte5n6ar nte8nei nter3a nte6rei nt1ha nt6har n3ther nt5hie
n3thus n1ti nti1c n8tinh nti1t ntlo6b ntmen8 n1to nt3o4ti n1tr ntra5f
ntra5ut nt8rea nt3rec nt8rep n4t3rin nt8rop n4t3rot \n{n4tr"u} nt1s
nts6an nt2sk n1tu nt1z \n{n1t"a} \n{n1t"o} \n{n8t"ol} \n{n1t"u} 1nu
nu1a nu5el nu5en 4n1uhr nu5ie 8numl 6n5ums 6n5umw 2n1und 6nuni 6n5unr
2n1unt 2nup 2nu6r n5uri nu3skr nu5ta n1v 8n1w 1nys n1za n6zab n2z1ar
n6zaus nzi4ga n8zof n6z5unt n1zw n6zwir \n{1n"ac} \n{5n"ae} \n{5n"ai}
\n{n8"al} \n{n"a6m} \n{n"a6re} \n{n5"arz} \n{5n"aus} \n{n1"ol}
\n{1n"ot} \n{n5"oz} \n{5n"u.} \n{6n1"u2b} \n{5n"u\3} \n{\c{5n"u\9}}
o5ab.  oa2l o8ala o1a2m o1an ob1ac obe4ra o6berh 5o4bers o4beru
obe6ser 1obj o1bl o2bli ob5sk 3obst.  ob8sta obst5re ob5sz o1che
oche8b o8chec o3chi och1l och3m ocho8f o3chro och3to o3chu och1w o1d
o2d1ag od2dr ode5i ode6n5e od1tr o5e6b o5e6der.  oe8du o1ef o1e2l
o1e2p o1er.  o5e8x o1fa of8fan 1offi of8fin of6f5la o5fla o1fr 8o1g
og2n o1ha o1he o6h5eis o1hi ohl1a oh1le oh4l3er 5ohm.  oh2ni o1ho
oh1re oh1ru o1hu oh1w o1hy \n{o1h"a} o5ia o1id.  o8idi oi8dr o5ids
o5isch.  oiset6 o1ism o3ist.  o5i6tu o1j o1k ok2l ok3lau \n{o8kl"a}
1okta o1la old5am old5r o1le ole5in ole1r ole3u ol6gl ol2kl olk4s1
ol8lak ol8lauf.  ol6lel ol8less o1lo ol1s ol6sk o1lu oly1e2 5olym
o2mab om6an o8mau ombe4 o8merz om5sp o1mu o8munt \n{o1m"a} \n{o1m"o}
o1na ona8m on1ax on8ent o6n5erb 8oni oni5er.  on1k on6n5a6b o1no ono1c
o4nokt 1ons onts8 \n{o1n"a} oo8f 1oog oo2pe oo2sa o1pa 3o4pera o3pfli
opf3lo opf3r o1pi o1pl o2pli o5p6n op8pa op6pl o1pr o3p4ter 1opti
\n{o1p"a} \n{o5p"o} o1q o1ra.  o3rad o8radd 1oram o6rang o5ras o8rauf
or5cha or4d3a4m or8dei or8deu 1ordn or4dos o1re o5re.  ore2h o8r5ein
ore5isc or6enn or8fla or8fli 1orga 5orgel.  or2gl o1ri 5o6rient or8nan
\n{or8n"a} o1ro or1r2h or6t5an or8tau or8tere o1rus o1ry \n{o1r"a}
\n{or1"u2} o1sa osa3i 6ose o8serk o1sk o6ske o6ski os2kl os2ko os2kr
osni5e o2s1o2d o3s4per o4stam o6stau o3stra ost3re osu6 o6s5ur o5s6ze
o1ta ot3auf o6taus o1te o6terw o1th othe5u o2th1r o1ti o1to oto1a
ot1re o1tri o1tro ot1sc o3tsu ot6t5erg ot2t3h ot2t5r \n{ot8t"o} o1tu
ou3e ouf1 ou5f6l o5u6gr ou5ie ou6rar ou1t6a o1v o1wa o1we o6wer.  o1wi
owid6 o1wo o5wu o1xe oy5al.  oy1e oy1i o5yo o1z oza2r 1o2zea ozo3is
\n{o"o8} o\35elt \c{o\95elt} o\31t \c{o\91t} 3paa pa6ce 5pad pag2 1pak
pa1la pa8na8t pani5el pa4nor pan1s2 1pap pap8s pa8rei par8kr paro8n
par5o6ti part8e 5partei 3partn pas6sep pa4tha 1pau 6paug pau3sc p1b
8p5c 4p1d 1pe 4peic pe5isc 2pek pen3k pen8to8 p8er pe1ra pere6 per5ea
per5eb pe4rem 2perr per8ran 3pers 4persi \n{pe3r"u} pe4sta pet2s
p2f1ec p4fei pf1f pf2l 5pflanz pf8leg pf3lei 2pft pf3ta p1g 1ph 2ph.
2p1haf 6phb 8phd 6p5heit ph5eme 6phg phi6e 8phk 6phn p5holl pht2
ph3tha 4ph3the phu6 6phz pi1en pi5err pi1la pi1na 5pinse pioni8e 1pis
pi1s2k pi1th p1k pl8 5pla p2lau 4plei p3lein 2pler 6p5les 2plig p6lik
6p5ling p2liz plo8min 6p1m p1n 1p2o 8poh 5pol po8lan poly1 po3ny po1ra
2porn por4t3h \n{po5r"o} 5poti p1pa p6p5ei ppe6la pp5f p2p1h p1pi pp1l
ppp6 pp5ren pp1s \n{p5p"o} pr6 3preis 1pres 2p3rig 5prinz 1prob 1prod
5prog pro8pt pro6t5a prote5i 8pro\3 \c{8pro\9} \n{pr"a3l} \n{1pr"as}
\n{pr"ate4} \n{1pr"uf} p5schl 2pst 1p2sy p1t p8to8d pt1s 5p6ty 1pu
pu1b2 2puc pu2dr puf8fr 6p5uh pun8s pu8rei pu5s6h pu1ta p1v p3w 5py
py5l p1z \n{p"a6der} \n{p5"a6m} \n{p"a8nu} \n{8p"ar} \n{p"at5h}
\n{p"at1s} qu6 1qui 8rabk ra6bla 3rable ra2br r1abt 6rabz ra4dan ra2dr
5rafal ra4f3er ra5gla ra2g3n 6raha ral5am 5rald 4ralg ra8lins 2rall
ral5t 8ramei r3anal r6and ran8der ran4dr 8ranf 6ranga 5rangi ran8gli
r3angr rans5pa 8ranw r8anz.  ra5or 6rapf ra5pl rap6s5er 2r1arb 1rarh
r1arm ra5ro 2r1art 6r1arz ra8tei ra6t5he 6ratl ra4t3ro r5atta raue4n
6raus.  r5austa rau8tel raut5s ray1 r1b rb5lass r6bler rb4lie rbon6n
r8brecht \n{rb6s5t"a} r8ces r1che rch1l rch3m rch3re rch3tr rch1w 8rd
r1da r8dachs r8dap rda5ro rde5ins rdio5 r8dir rd3ost r1dr r8drau 1re.
re1ak 3reakt re3als re6am.  re1as 4reben re6bl rech5a r8edi re3er
8reff 3refl 2reh 5reha r4ei.  reich6s5 8reier 6reign re5imp 4r3eina
6r3einb 6reing 6r5einn 6reinr 4r3eins r3eint reli3e 8r5elt 6rempf
2remt ren5a6b ren8gl r3enni 1reno 5rente 4r3enth 8rentl 4r3entw 8rentz
ren4zw re1on requi5 1rer rer4bl 6rerbs 4r3erd \n{8rerh"o} 8rerkl
4r3erla \n{8rerl"o} 4r3erns \n{6r5ern"a} rer5o 6r5erreg r5ertr r5erwec
\n{r5er"o} re2sa re8schm 2ress re5u8ni 6rewo 2r1ex r1f r8ferd rf4lie
8r1g r8gah rge4bl rge5na rgest4 rg6ne r2gni2 r8gob r4g3ret rg8sel r1h8
r2hy 5rhyt ri1ar ri5cha rid2g r2ie rieg4s5 ri8ei ri1el ri6ele ri1en
ri3er.  ri5ers.  ri6fan ri8fer ri8fr 1r2ig ri8kn ri5la \n{rim"a8}
ri1na r8inde rin4ga rin6gr 1rinn 6rinner rino1 r8insp 4rinst
\n{ri1n"a} ri5o6ch ri1o2d ri3o6st 2r1ir r2is ri3sko ri8spr \n{ri8st"u}
ri5sv r2it 6r5i6tal ri5tr ri6ve.  8r1j 6rk r1ke rkehrs5 r1ki r3klin
r1k2n rk3str rk4t3an rk6to r6kuh \n{rk"a4s3t} r1l r5li rline5a 6r1m
r6manl rma4p r4m3aph r8minf r8mob rm5sa 2rn r1na rna8be r5ne rn2ei
r6neif r6nex r6nh rn1k r1no r6n5oc rn1sp \n{r1n"a} \n{r1n"u} ro6bern
6robs ro1ch 3rock.  ro5de ro1e 4rofe ro8hert 1rohr ro5id ro1in ro5isc
6rolym r2on 6roog ro6phan r3ort ro1s2p ro5s6w ro4tau ro1tr ro6ts 5rout
r1p rpe8re rp2f r2ps r2pt r1q 2rr r1ra r1re rrer6 rr6hos \n{r5rh"o}
r1ri r1ro rro8f rr8or rror5a r1ru r3ry \n{r1r"a} \n{r1r"o} \n{r1r"u}
2r1s r6sab r4sanf rse6e rse5na r2sh r6ska r6ski rs2kl r8sko r2sl rs2p
r6stauf r8sterw r8stran rswi3d4 r2sz 2r1t rt3art r8taut r5tei rt5eige
r8tepe r4t3erh r8terla r4t3hei r5t6hu r4t3int rt5reif rt1sc rt6ser
rt6s5o rt6s5u rt5und r8turt rube6 ru1en 1r4uf ruf4st ru1ie 2r1umg
2r1uml 2rums run8der run4d5r 6rundz 6runf 8runs 2r1unt 2r1ur r6us
ru6sta ru3str ru6tr 1ruts r1v rven1 rvi2c r1w r1x r1za rz5ac r6z5al
r8z1ar r8zerd r6z5erf rz8erh rz4t3h r8zum \n{r"a4ste} \n{r"au8sc}
\n{r1"of} \n{5r"ohr} \n{r"o5le} \n{3r"oll} \n{5r"omis} \n{r1"or}
\n{r"o2sc} \n{3r"ump} 1sa.  1saa s3a4ben sa2bl 2s1abs 6s1abt 6sabw
3sack.  6s3a4der 1saf sa1fa 4s1aff sa5fr 1sag 1sai sa1i2k1 4s1akt 1sal
sa1la 4s3alpi 6salter salz3a 1sam s5anb san2c 1sand s5angeh 6sanl
2s1ans 6s3antr 8s1anw s1ap s6aph 8sapo sap5p6 s8ar.  2s1arb 3sarg
s1arm sa5ro 2s1art 6s1arz 1sas 1sat sat8a 2s1atl sa8tom 3s8aue s5auff
sau5i s6aur 2s1aus 5s6ause 2s1b2 2sca s4ce 8sch.  3scha.  5schade
3schaf 3schal sch5ame 8schanc 8schb 1sche 6schef 8schex 2schf 2schg
2schh 1schi 2schk 5schlag 5schlu \n{6schm"a\3} \n{\c{6schm"a\9}}
6schna\3 \c{6schna\9} 1scho 6schord 6schp 3schri 8schric 8schrig
8schrou 6schs 2scht sch3ta sch3tr 1schu 8schunt 6schv 2schz \n{5sch"o}
\n{5sch"u} 2sco scre6 6scu 2s1d 1se se5an se1ap se6ben se5ec see5i6g
se3erl 8seff se6han se8hi \n{se8h"o} 6s5eid.  2s1eig s8eil 5sein.
sei5n6e 6s5einh 3s8eit 3sel.  se4lar selb4 6s3e4lem se8lerl 2s1emp
sen3ac se5nec 6s5ents 4sentz s8er.  se8reim ser5inn \n{8serm"a}
8s5erzi \n{6ser"of} se1um 8sexa 6sexp 2s1f2 sfal8ler 2s3g2 sge5b2 s1h
s8hew 5s6hip 5s4hop 1si 2siat si1b sicht6s 6s5i6dee siege6s5 si1en
si5err si1f2 si1g2n si6g5r si8kau sik1i si4kin si2kl \n{si8k"u} si1la
sil6br si1na 2s1inf sin5gh 2s1inh sinne6s5 2s1ins si5ru si5str 4s1j
s1k2 6sk.  2skau skel6c skelch5 s6kele 1s2ki.  3s4kin.  s6kiz s8kj
6skn 2skow 3skrib 3skrip 2sku \n{8sk"u} s1l s8lal slei3t s4low 2s1m
s1n 6sna 6snot 1so so1ch 2s1odo so4dor 6s5o4fen solo3 s2on so5of 4sope
so1ra 2s1ord 4sorga sou5c so3un 4s3ox sp2 8spaa 5spal 1span 2spap
s2pec s4peis 1spek s6perg 4spers s6pes 2s1pf 8sphi \n{1s2ph"a} 1spi
spi4e 6s5pig 6spinse 2spis 2spla 2spol 5s6pom 6s5pos 6spoti 1spra
3s8prec 6spreis 5spring 6sprob 1spru s2pul 1s2pur 6spy \n{5sp"an}
\n{1sp"u} s1q 2s1r 2s1s2 sse8nu ssini6s ssoi6r 2st.  1sta 4stafe 2stag
sta3la 6stale 4stalg 8stalk 8stamt 6st5anf 4stans 6stanw 6starb sta4te
6staus 2stb 6stc 6std 1ste 4steil 3s2tel st3elb 8stemb 6steppi 8stese
8stesse 6stf 2stg 2sth st1ha st3hei s8t1hi st1ho st5hu 1sti sti4el
4stigm sti3na 6stind 4stinf sti8r 2stk 2stl 2stm 1sto 6stoll.  4st3ope
6stopf.  6stord 6stp 5stra.  4strai 3s4tral 6s5traum 3stra\3
\c{3stra\9} 3strec 6s3tref 8streib 5streif 6streno 6stres 6strev
5s6tria 6strig 5strik 8strisi 3s4troa s8troma st5rose 4struf 3strum
\n{6str"ag} 2st1s6 2stt 1stu stu5a 4stuc 2stue 8stun.  2stv 2stw s2tyl
6stz \n{1st"a} \n{8st"ag} \n{1st"o} \n{1st"u} \n{8st"uch} \n{4st"ur.}
1su su2b1 3suc su1e su2fe su8mar 6sumfa 8sumk 2s1unt sup1p2 6s5u6ran
6surte 2s1v 2s1w 1sy 8syl.  sy5la syn1 sy2na syne4 s1z s4zend 5s6zene.
8szu \n{1s"a} \n{6s5"and} \n{6s"augi} \n{6s"au\3} \n{\c{6s"au\9}}
\n{5s"om} \n{2s1"u2b} \n{1s"uc} \n{s"u8di} \n{1s"un} \n{5s"u\3}
\n{\c{5s"u\9}} taats3 4tab.  taba6k ta8ban tab2l ta6bre 4tabs t3absc
8tabz 6t3acht ta6der 6tadr tad6s tad2t 1tafe4 1tag ta6ga6 ta8gei
tage4s tag6s5t tah8 tahl3 tai6ne.  ta5ir.  tak8ta tal3au 1tale ta8leng
tal5ert 6t5a6mer 6tamp tampe6 2t1amt tan5d6a tan8dr tands5a tani5e
6tanl 2tanr t3ans 8t5antr tanu6 t5anw 8tanwa tan8zw ta8rau 6tarbe
1tari 2tark 2t1arm ta1ro 2tart t3arti 6tarz ta1sc ta6sien ta8stem
ta8sto t5aufb 4taufn 8taus.  5tause 8tausf 6tausg t5ausl 2t1b2 2t1c
t6chu 2t1d te2am tea4s te8ben 5techn 4teff te4g3re te6hau 2tehe te4hel
2t1ehr te5id.  teig5l 6teign tei8gr 1teil 4teinh t5einhe 4teis t5eisen
8teiw te8lam te4lar 4telek 8telem te6man te6n5ag ten8erw ten5k tens4p
ten8tro 4t3entw 8tentz te6pli 5teppi ter5a6b te3ral ter5au 8terbar
t5erbe.  6terben 8terbs 4t3erbt t5erde.  ter5ebe ter5ein te8rers terf4
\n{8terh"o} \n{6terkl"a} ter8nor ter6re.  t8erscha t5e6sel te8stau
t3euro te1xa tex3e 8texp tex6ta 2t1f2 2t1g2 2th.  th6a 5tha.  2thaa
6t1hab 6t5haf t5hah 8thak 3thal.  6thals 6t3hand 2t1hau 1the.  3t4hea
t1heb t5heil t3heit t3helf 1theo 5therap 5therf 6t5herz 1thes 1thet
5thi.  2t1hil t3him 8thir 3this t5hj 2th1l 2th1m th1n t5hob t5hof
4tholz 6thopti 1thr6 4ths t1hum 1thy \n{4t1h"a} \n{2t1h"o} \n{t1h"u}
ti1a2m ti1b tie6fer ti1en ti8gerz tig3l ti8kin ti5lat 1tilg t1ind
tin4k3l ti3spa ti5str 5tite ti5tr ti8vel ti8vr 2t1j 2t1k2 2t1l tl8a
2t1m8 2t1n 3tobe 8tobj to3cha 5tocht 8tock tode4 to8del to8du to1e
6t5o6fen to1in toi6r 5toll.  to8mene t2ons 2t1ony to4per 5topf.  6topt
to1ra to1s to6ska tos2l 2toti to1tr t8ou 2t1p2 6t1q tr6 tra5cha
tra8far traf5t 1trag tra6gl tra6gr t3rahm 1trai t6rans tra3sc tra6st
3traue t4re.  2trec t3rech t8reck 6t1red t8ree 4t1reg 3treib 4treif
8t3reis 8trepo tre6t5r t3rev 4t3rez 1trib t6rick tri6er 2trig t8rink
tri6o5d trizi5 tro1a 3troc trocke6 troi8d tro8man.  tro3ny 5tropf
6t5rosa t5ro\3 \c{t5ro\9} 5trub 5trup trut5 \n{1tr"ag} \n{6t1r"oh}
\n{5tr"ub} \n{tr"u3bu} \n{t1r"uc} \n{t1r"us} 2ts ts1ab t1sac tsa8d
ts1ak t6s5alt ts1an ts1ar ts3auf t3schr \n{t5sch"a} tse6e tsee5i
tsein6s ts3ent ts1er t8serf t4serk t8sh 5t6sik t4s3int ts5ort.
t5s6por t6sprei t1st t6s5tanz ts1th t6stit t4s3tor 1t2sua t2s1uf
t8sum.  t2s1u8n t2s1ur 2t1t tt5eif tte6sa tt1ha tt8ret tt1sc tt8ser
tt5s6z 1tuc tuch5a 1tu1e 6tuh t5uhr tu1i tu6it 1tumh 6t5umr 1tums
8tumt 6tund 6tunf 2t1unt tu5ra tu6rau tu6re.  tu4r3er 2t1v 2t1w 1ty1
ty6a ty8la 8tym 6ty6o 2tz tz5al tz1an tz1ar t8zec tzeh6 tzehn5 t6z5ei.
t6zor t4z3um \n{t6z"au} \n{5t"ag} \n{6t"ah} \n{t5"alt} \n{t8"an}
\n{t"are8} \n{8t"a8st} \n{6t"au\3} \n{\c{6t"au\9}} \n{t5"offen}
\n{8t"o8k} \n{1t"on} \n{4t"ub} \n{t6"u5ber.} \n{5t"uch} \n{1t"ur.}
u3al.  u5alb u5alf u3alh u5alk u3alp u3an.  ua5na u3and u5ans u5ar.
ua6th u1au ua1y u2bab ubi5er.  u6b5rit ubs2k \n{u5b"o} \n{u8b"ub} 2uc
u1che u6ch5ec u1chi uch1l uch3m uch5n uch1r uch5to ucht5re u1chu uch1w
uck1a uck5in u1d ud4a u1ei u6ela uene8 u6ep u1er uer1a ue8rerl uer5o
u8esc u2est u8ev u1fa u2f1ei u4f3ent u8ferh uf1fr uf1l uf1ra uf1re
\n{uf1r"a} \n{uf1r"u} uf1s2p uf1st uft1s u8gabt u8gad u6gap ugeb8 u8gn
ugo3s4 u1ha u1he u1hi uh1le u1ho uh1re u1hu uh1w \n{u1h"a} \n{u1h"o}
6ui ui5en u1ig u3ins uin8tes u5isch.  u1j 6uk u1ke u1ki u1kl u8klu
u1k6n u5ky u1la uld8se u1le ul8lac ul6lau ul6le6l ul6lo ulni8 u1lo
ulo6i ult6a ult8e u1lu ul2vr \n{u1l"a} \n{u1l"o} 3umfan 5umlau umo8f
um8pho u1mu umu8s \n{u5m"o} u1n1a un2al un6at unau2 6und.  5undein
un4d3um 3undzw \n{und"u8} \n{un8d"ub} une2b un1ec une2h un3eis 3unfal
\n{1unf"a} 5ungea \n{3ungl"u} ung2s1 \n{un8g"a} 1u2nif un4it un8kro
unk5s u1no unpa2 uns2p unvol4 unvoll5 u5os.  u1pa u1pi u1p2l u1pr
up4s3t up2t1a u1q u1ra ur5abs ura8d ur5ah u6rak ur3alt u6rana u6r5ans
u8rap ur5a6ri u8ratt u1re ur3eig ur8gri u1ri ur5ins 3urlau urmen6
ur8nan u1ro 3ursac ur8sau ur8sei ur4sk 3urtei u1ru uru5i6 uru6r u1ry
ur2za \n{ur6z"a} \n{ur5"a6m} \n{u5r"o} \n{u1r"u} \n{ur"uck3} u1sa
usa4gi u2s1ar u2s1au u8schec usch5wi u2s1ei use8kel u8sl u4st3a4b
us3tau u3s4ter u2s1uf u8surn ut1ac u1tal uta8m u1tan ut1ar u1tas ut1au
u1te u8teic u4tent u8terf u6terin u4t3hei ut5ho ut1hu u1ti utine5
uti6q u1to uto5c u1tr ut1sa ut1s6p ut6stro u1tu utz5w u1u u1v uve5n
\n{uve3r4"a} u1w u1xe u5ya uy5e6 u1yi u2z1eh u8zerh \n{u5"o} u\3e6n
\c{u\9e6n} u\3en5e \c{u\9en5e} 8vanb 6vang 6varb var8d va6t5a va8tei
va2t1r 2v1b 6v5c 6vd 1ve 6ve5g6 ver1 ver5b verb8l ve2re2 verg8 ve2ru8
ve1s ve2s3p ve3xe 2v1f 2v1g 6v5h vi6el vie6w5 vi1g4 vi8leh vil6le.
8vint vi1ru vi1tr 2v1k 2v1l 2v1m 4v5n 8vo8f voi6le vol8lend vol8li
v2or1 vo2re vo8rin vo2ro 2v1p 8vra v6re 2v1s 2v1t 2v1v 4v3w 2v1z
waffe8 wa6g5n 1wah wah8n wa5la wal8din wal6ta wan4dr 5ware wa8ru
war4za 1was w5c w1d 5wech we6fl 1weg we8geng weg5h weg3l we2g1r
weh6r5er 5weise weit3r wel2t welt3r we6rat 8werc 5werdu wer4fl 5werk.
wer4ka wer8ku wer4ta wer8term we2sp we8stend we6steu we8str
\n{we8st"o} wet8ta wich6s5t 1wid wi2dr wiede4 wieder5 wik6 wim6ma
win4d3r 5wirt wisch5l 1wj 6wk 2w1l 8w1n wo1c woche6 wol6f wor6t5r 6ws2
w1sk 6w5t 5wunde.  wun6gr wu1sc wu2t1 6w5w wy5a \n{w"arme5} \n{w"a1sc}
1xag x1ak x3a4men 8xamt x1an 8x1b x1c 1xe.  x3e4g 1xen xe1ro x1erz
1xes 8xf x1g 8x1h 1xi 8xid xi8so 4xiste x1k 6x1l x1m 8xn 1xo 8x5o6d
8x3p2 x1r x1s6 8x1t x6tak x8terf x2t1h 1xu xu1e x5ul 6x3w x1z 5ya.
y5an.  y5ank y1b y1c y6cha y4chia y1d yen6n y5ern y1g y5h y5in y1j
y1k2 y1lak yl1al yla8m y5lax y1le y1lo y5lu y8mn ym1p2 y3mu y1na yno2d
yn1t y1on.  y1o4p y5ou ypo1 y1pr y8ps y1r yri3e yr1r2 y1s ys5iat ys8ty
y1t y3w y1z \n{y"a8m} z5a6b zab5l 8za6d 1zah za5is 4z3ak 6z1am 5zange.
8zanl 2z1ara 6z5as z5auf 3zaun 2z1b 6z1c 6z1d 1ze ze4dik 4z3eff 8zein
zei4ta zei8ters ze6la ze8lec zel8th 4zemp 6z5engel zen8zin \n{8zerg"a}
zer8i ze1ro zers8 zerta8 zer8tab zer8tag 8zerz ze8ste zeu6gr 2z1ex
2z1f8 z1g 4z1h 1zi zi1en zi5es.  4z3imp zi1na 6z5inf 6z5inni zin6s5er
8zinsuf zist5r zi5th zi1tr 6z1j 2z1k 2z1l 2z1m 6z1n 1zo zo6gl 4z3oh
zo1on zor6na8 4z1p z5q 6z1r 2z1s8 2z1t z4t3end z4t3hei z8thi 1zu zu3al
zu1b4 zu1f2 6z5uhr zun2a 8zunem zunf8 8zungl zu1o zup8fi zu1s8 zu1z
2z1v zw8 z1wal 5zweck zwei3s z1wel z1wer z6werg 8z5wes 1zwi zwi1s
6z1wo 1zy 2z1z zz8a zzi1s \n{1z"a} \n{1z"o} \n{6z"ol.} \n{z"o1le}
\n{1z"u} \n{2z1"u2b} \n{"a1a6} \n{"ab1l} \n{"a1che} \n{"a3chi}
\n{"ach8sc} \n{"ach8sp} \n{"a5chu} \n{"ack5a} \n{"ad1a} \n{"ad5era}
\n{"a6d5ia} \n{"a1e} \n{"a5fa} \n{"af1l} \n{"aft6s} \n{"ag1h}
\n{"ag3le} \n{"a6g5nan} \n{"ag5str} \n{"a1he} \n{"a1hi} \n{"ah1le}
\n{"ah5ne} \n{1"ahnl} \n{"ah1re} \n{"ah5ri} \n{"ah1ru} \n{"a1hu}
\n{"ah1w} \n{6"ai} \n{"a1isc} \n{"a6ische} \n{"a5ism} \n{"a5j}
\n{"a1k} \n{"al1c} \n{"a1le} \n{"a8lei} \n{"al6schl} \n{"ami1e}
\n{"am8n} \n{"am8s} \n{"a5na} \n{5"anderu} \n{"ane5i8} \n{"ang3l}
\n{"ank5l} \n{"a1no} \n{"an6s5c} \n{"a1pa} \n{"ap6s5c} \n{3"aq}
\n{"ar1c} \n{"a1re} \n{"are8m} \n{5"argern} \n{"ar6gl} \n{"a1ri}
\n{3"armel} \n{"a1ro} \n{"art6s5} \n{"a1ru} \n{3"arztl} \n{"a5r"o}
\n{"a6s5chen} \n{"asen8s} \n{"as1th} \n{"ata8b} \n{"a1te} \n{"ateri4}
\n{"ater5it} \n{"a6thy} \n{"a1ti} \n{3"atk} \n{"a1to} \n{"at8schl}
\n{"ats1p} \n{"a5tu} \n{"aub1l} \n{"au1e} \n{1"aug} \n{"au8ga}
\n{"au5i} \n{"a1um.} \n{"a1us.} \n{1"au\3} \n{\c{1"au\9}} \n{"a1z}
\n{"o1b} \n{"o1che} \n{"o5chi} \n{"och8stei} \n{"och8str} \n{"ocht6}
\n{5"o6dem} \n{5"offn} \n{"o1he} \n{"oh1l8} \n{"oh1re} \n{"o1hu}
\n{"o1is} \n{"o1ke} \n{1"o2ko} \n{1"ol.} \n{"ol6k5l} \n{"ol8pl}
\n{"o1mu} \n{"o5na} \n{"onig6s3} \n{"o1no} \n{"o5o6t} \n{"opf3l}
\n{"op6s5c} \n{"o1re} \n{"or8gli} \n{"o1ri} \n{"or8tr} \n{"o1ru}
\n{5"osterr} \n{"o1te} \n{"o5th} \n{"o1ti} \n{"o1tu} \n{"o1v} \n{"o1w}
\n{"owe8} \n{"o2z} \n{"ub6e2} \n{3"u4ber1} \n{"ub1l} \n{"ub1r}
\n{5"u2bu} \n{"u1che} \n{"u1chi} \n{"u8ch3l} \n{"uch6s5c} \n{"u8ck}
\n{"uck1a} \n{"uck5ers} \n{"ud1a2} \n{"u6deu} \n{"udi8t} \n{"u2d1o4}
\n{"ud5s6} \n{"uge4l5a} \n{"ug1l} \n{"uh5a} \n{"u1he} \n{"u8heh}
\n{"u6h5erk} \n{"uh1le} \n{"uh1re} \n{"uh1ru} \n{"u1hu} \n{"uh1w}
\n{"u3k} \n{"u1le} \n{"ul4l5a} \n{"ul8lo} \n{"ul4ps} \n{"ul6s5c}
\n{"u1lu} \n{"un8da} \n{"un8fei} \n{"unk5l} \n{"un8za} \n{"un6zw}
\n{"u5pi} \n{"u1re} \n{"u8rei} \n{"ur8fl} \n{"ur8fr} \n{"ur8geng}
\n{"u1ri} \n{"u1ro} \n{"ur8sta} \n{"ur8ster} \n{"u1ru} \n{"use8n}
\n{"u8sta} \n{"u8stes} \n{"u6s5tete} \n{"u3ta} \n{"u1te} \n{"u1ti}
\n{"ut8tr} \n{"u1tu} \n{"ut8zei} \n{"u1v} \31a8 \c{\91a8} 5\3a.
\c{5\9a.} \38as \c{\98as} \31b8 \c{\91b8} \31c \c{\91c} \31d \c{\91d}
1\3e \c{1\9e} \35ec \c{\95ec} 8\3e8g \c{8\9e8g} 8\3e8h \c{8\9e8h}
2\31ei \c{2\91ei} 8\3em \c{8\9em} \31f8 \c{\91f8} \31g \c{\91g} \31h
\c{\91h} 1\3i \c{1\9i} \31k \c{\91k} \31l \c{\91l} \31m \c{\91m}
\3mana8 \c{\9mana8} \31n \c{\91n} \31o \c{\91o} \31p8 \c{\91p8} \35q
\c{\95q} \31r \c{\91r} \31s2 \c{\91s2} \3st8 \c{\9st8} \31ta \c{\91ta}
\31te \c{\91te} \3t3hei \c{\9t3hei} \31ti \c{\91ti} \35to \c{\95to}
\31tr \c{\91tr} 1\3u8 \c{1\9u8} 6\35um \c{6\95um} \31v \c{\91v} \31w
\c{\91w} \31z \c{\91z}
}%
\endgroup
\relax\endinput
%
% -----------------------------------------------------------------
%
% =============== Additional Documentation ===============
%
%
% Older Versions of German Hyphenation Patterns:
% ----------------------------------------------
%
% All older versions of `ghyphen.tex' distributed as
%
%       ghyphen.tex/germhyph.tex   as of 1986/11/01
%       ghyphen.min/ghyphen.max    as of 1988/10/10
%       ghyphen3.tex               as of 90/09/27 & 91/02/13
%
% are out of date and it is recommended to replace them
% with the new version `ghyph31.tex'.
%
% If you are using `ghyphen.min' (a minor version of `ghyphen')
% because of limited trie memory space, try this version and if
% the space is exceeded get a newer TeX implementation with
% larger or configurable trie memory sizes.
%
%
%
% Trie Memory Requirements/Space for Hyphenation Patterns:
% --------------------------------------------------------
%
% To load this set of german hyphenation patterns the parameters
% of TeX has to have at least these values:
%
% TeX 3.x:
%    IniTeX:    trie_size >= 9733    trie_op_size >= 207
%    VirTeX:    trie_size >= 8375    trie_op_size >= 207
%
% TeX 2.x:
%    IniTeX:    trie_size >= 8675    trie_op_size >= 198
%    VirTeX:    trie_size >= 7560    trie_op_size >= 198
%
% If you want to load more than one set of hyphenation patterns
% (in TeX 3.x), the parameters have to be set to a value larger
% than or equal to the sum of all required values for each set.
%
%
% Setting Trie Memory Parameters:
% -------------------------------
%
% Some implementations allow the user to change the default value
% of a set of the internal TeX parameters including the trie memory
% size parameter specifying the used memory for the hyphenation
% patterns.
% 
% emTeX (PC):
%   You can set the used memory size of the trie using the
%   `-mt<number>' option on the command line or in the
%   TEXOPTIONS environment variable.
%
% PasTeX (Amiga):
%   The values for the parameters can be set using the keywords
%   `triesize', `itriesize' and `trieopsize' in the configuration
%   file.
%
% others (binaries only):
%   See the documentation of the implementation if it is possible
%   and how to change these values without recompilation.
%
% others (with sources, e.g. PublicTeX (PC), web2c (Unix et.al.)):
%   If the trie memory is too small, you have to recompile TeX
%   using larger values for `trie_size' and `trie_op_size'.
%   Modify the change file pctex.ch/ctex.ch and recompile TeX.
%   For details see the documentation included in the sources.
%
%
%
% Necessary Settings in TeX macro files:
% --------------------------------------
%
% \lefthyphenmin, \righthyphenmin:
%   You can set both parameters to 2.
%
% \lccode <char>:
%   To get correct hyphenation points within words containing
%   umlauts or \ss, it's necessary to assign values > 0 to the
%   appropriate \lccode <char> positions.
%
% These changes are done when reading this file (\lccode for umlauts)
% or are included in the language switching mechanism of `german.sty'
% (\lccode change for \ss, \left-/\righthyphenmin settings).
%
%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%
\endinput
%% 
%% End of file `ghyph31.tex'.
