/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#undef USE_GNOME
#include "xchat.h"
#include "notify.h"
#include "style.h"
#include <fcntl.h>
#include "gtkutil.h"


extern void PrintText(struct session *sess, unsigned char *text);
extern char *get_xdir(void);
extern int waitline(int sok, char *buf, int bufsize);
extern void update_all_of(char *name);
extern GSList *serv_list;

GSList *notify_list = 0;
GtkWidget *notify_window = 0;
GtkWidget *notify_guilist;

void notify_adduser(char *name);
int notify_deluser(char *name);


void notify_save(void)
{
   int fh;
   char buf[128];
   char *dir;

   dir = get_xdir();
   sprintf(buf, "%s/notify.conf", dir);

   fh = open(buf, O_TRUNC | O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      struct notify *notify;
      GSList *list = notify_list;
      while(list)
      {
	 notify = (struct notify *)list->data;
	 write(fh, notify->name, strlen(notify->name));
	 write(fh, "\n", 1);
	 list = list->next;
      }   
      close(fh);
   }
}

void notify_load(void)
{
   int fh;
   char buf[128];
   char *dir;
   
   dir = get_xdir();
   sprintf(buf, "%s/notify.conf", dir);
   
   fh = open(buf, O_RDONLY);
   if(fh != -1)
   {
      while( waitline(fh, buf, sizeof buf) != -1)
      {
	 if(*buf != '#') notify_adduser(buf);
      }
      close(fh);
   }
}

void notify_closegui(void)
{
   if(notify_window)
   {
      gtk_widget_destroy(notify_window);
      notify_window = 0;
   }
}

void notify_gui_update(void)
{
   struct notify *notify;
   GSList *list = notify_list;
   gchar *new[1][3];
   int row;

   if(!notify_window) return;

   row = gtkutil_clist_selection(notify_guilist);

   gtk_clist_clear((GtkCList*)notify_guilist);
   while(list)
   {
      notify = (struct notify *)list->data;
      new[0][0] = notify->name;
      if(notify->ison)
	new[0][1] = "Online";
      else
	new[0][1] = "Offline";
      if(notify->servername[0])
	new[0][2] = notify->servername;
      else
	new[0][2] = "-";
      gtk_clist_append((GtkCList*)notify_guilist, new[0]);
      list = list->next;
   }
   if(row != -1)
     gtk_clist_select_row((GtkCList*)notify_guilist, row, 0);
}

void notify_remove_clicked(GtkWidget *igad)
{
   int row;
   char *name;

   row = gtkutil_clist_selection(notify_guilist);
   if(row != -1)
   {
      gtk_clist_get_text(GTK_CLIST(notify_guilist), row, 0, &name);
      notify_deluser(name);
   }
}

void notify_opengui(void)
{
   GtkWidget *vbox, *bbox, *Remove;
   static gchar *titles[] = { "User", "Status", "Server" };

   if(notify_window)
   {
      notify_closegui();
      return;
   }

   notify_window = gtkutil_window_new("X-Chat: Notify List", 400, 120,
				      notify_closegui, 0);

   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(vbox), 4);
   gtk_container_add(GTK_CONTAINER(notify_window), vbox);
   gtk_widget_show(vbox);

   notify_guilist = gtkutil_clist_new(3, titles, vbox, GTK_POLICY_ALWAYS,
				      0, 0,
				      0, 0);
   gtk_clist_set_column_width(GTK_CLIST(notify_guilist), 0, 100);
   gtk_clist_set_column_width(GTK_CLIST(notify_guilist), 1, 60);

   bbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);
   gtk_widget_show(bbox);

   /*Add = gtk_button_new_with_label("Add");
   gtk_signal_connect(GTK_OBJECT(Add), "clicked",
		      GTK_SIGNAL_FUNC(notify_add_clicked), 0);
   gtk_container_add(GTK_CONTAINER(bbox), Add);
   gtk_widget_show(Add);*/

   Remove = gtk_button_new_with_label("Remove");
   gtk_signal_connect(GTK_OBJECT(Remove), "clicked",
		      GTK_SIGNAL_FUNC(notify_remove_clicked), 0);
   gtk_container_add(GTK_CONTAINER(bbox), Remove); 
   gtk_widget_show(Remove);

   gtk_widget_show(notify_window);

   notify_gui_update();
}

void notify_markonline(struct session *sess, char *outbuf, char *word[])
{
   struct notify *notify;
   GSList *list = notify_list;
   int i, j;

   while(list)
   {
      notify = (struct notify *)list->data;
      i = 4;
      j = 0;
      while(*word[i])
      {	
	 if(!strcasecmp(notify->name, word[i]))
	 {
	    j++;
	    notify->checking = FALSE;
	    if(!notify->ison)
	    {
	       notify->ison = TRUE;
	       strcpy(notify->servername, sess->server->servername);
	       sprintf(outbuf, STARTON" Notify: %s is online.\n", notify->name);
	       PrintText(sess, outbuf);
	       update_all_of(notify->name);
	    }
	    break;
	 }
	 i++;
      }
      list = list->next;
   }
   notify_gui_update();
}

void notify_checklist(void)
{
   char *outbuf = malloc(4096);
   struct server *serv;
   struct notify *notify;
   GSList *list = notify_list;
   int i = 0;

   strcpy(outbuf, "ISON ");
   while(list)
   {
      i++;
      notify = (struct notify *)list->data;
      if(notify->checking) notify->ison = FALSE;
      notify->checking = TRUE;
      strcat(outbuf, notify->name);
      strcat(outbuf, " ");
      list = list->next;
   }
   if(i)
   {
      GSList *list = serv_list;
      strcat(outbuf, "\r\n");
      while(list)
      {
	 serv = (struct server *)list->data;
	 if(serv->connected)
	    send(serv->sok, outbuf, strlen(outbuf), 0);
	 list = list->next;
      }
   }
   free(outbuf);
}

void notify_showlist(struct session *sess)
{
   char outbuf[256];
   struct notify *notify;
   GSList *list = notify_list;
   int i = 0;
   PrintText(sess, STARTON" \00308,02 \002-- Notify List --------------- \003 \n");
   while(list)
   {
      i++;
      notify = (struct notify *)list->data;
      if(notify->ison)
      	sprintf(outbuf, STARTON"   %-20s online\n", notify->name);
      else
	sprintf(outbuf, STARTON"   %-20s offline\n", notify->name);
      PrintText(sess, outbuf);
      list = list->next;
   }
   if(i)
   {
     sprintf(outbuf, STARTON" %d users in notify list.\n", i);
     PrintText(sess, outbuf);
   } else
     PrintText(sess, STARTON" Notify list is empty.\n");
}

/*void notify_clearlist(void)
{
   struct notify *notify;
   GSList *list = notify_list;
   while(list)
   {
      notify = (struct notify *)list->data;
      notify->ison = FALSE;
      update_all_of(notify->name);
      free(notify);
      notify_list = g_slist_remove(notify_list, list);
      list = list->next;
   }
   notify_list = 0;
   notify_gui_update();
}*/

int notify_deluser(char *name)
{
   struct notify *notify;
   GSList *list = notify_list;
   while(list)
   {
      notify = (struct notify *)list->data;
      if(!strcasecmp(notify->name, name))
      {
	 notify->ison = FALSE;
         update_all_of(notify->name);
	 notify_list = g_slist_remove(notify_list, notify);
	 free(notify);
	 notify_gui_update();
	 return 1;
      }
      list = list->next;
   }
   return 0;
}

void notify_adduser(char *name)
{
   struct notify *notify = malloc(sizeof(struct notify));
   if(notify)
   {
      notify->servername[0] = 0;
      notify->ison = FALSE;
      notify->checking = FALSE;
      strcpy(notify->name, name);
      notify_list = g_slist_append(notify_list, notify);
      notify_checklist();
      update_all_of(notify->name);
      notify_gui_update();
   }
}

int notify_isnotify(struct session *sess, char *name)
{
   struct notify *notify;
   GSList *list = notify_list;

   while(list)
   {
      notify = (struct notify *)list->data;
      if(!strcasecmp(notify->name, name))
      {
	 if (notify->ison)
         {
	    return TRUE;
	 }
      }

      list = list->next;
   }

   return FALSE;
}

