/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include "menu.h"
#include <fcntl.h>
#include <sys/utsname.h>
#include "gtkutil.h"


extern struct session *current_tab;
extern struct xchatprefs prefs;

extern char *get_home_dir(void);
extern void ctcp_gui_load(GtkWidget *list);
extern void ctcp_gui_save(GtkWidget *igad);
extern void editlist_gui_open(GSList *list, char *, char *, char *help);
extern void ctcp_gui_open(void);
extern void notify_opengui(void);
extern void chanlist_opengui(struct server *serv);
extern void url_opengui(GtkWidget *, gpointer);
extern void cmd_help(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
extern void xchat_cleanup(GtkWidget *wid, gpointer sess);
extern struct server *new_server(void);
extern struct session *new_session(struct server *);
extern void PrintText(struct session *, char *);
extern void open_rawlog(struct server *);
extern void open_dcc_recv_window(GtkWidget *wid, gpointer sess);
extern void open_dcc_send_window(GtkWidget *wid, gpointer sess);
extern void open_dcc_chat_window(GtkWidget *wid, gpointer sess);
extern void open_server_list(GtkWidget *wid, gpointer sess);
extern int save_config(void);
extern void load_config(void);
extern void settings_opengui(struct session *sess);
extern void show_lastlog_window(void);
extern void search_lastlog(struct session *_sess, char *search);
extern char *find_selected_nick(struct session *sess);
extern int handle_command(char *cmd, struct session *sess, int);
extern char *get_xdir(void);
extern void zvt_clear(GtkWidget *wid);
extern int cmd_unloadall(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
extern int module_unload (char *name, struct session *sess);
extern void module_glist(struct session *sess);


struct session *menu_sess = 0;
GSList *popup_list = 0;
GSList *button_list = 0;
GSList *command_list = 0;
GSList *ctcp_list = 0;


void popup_cmd(GtkWidget *igad, char *cmd)
{
   int fin = 0, j = 0;
   char *buf;
   char *nick;

   nick = find_selected_nick(menu_sess);
   if(!nick) nick = "";

   buf = malloc(strlen(nick) + strlen(cmd) + 256);

   while(!fin)
   {
      switch(*cmd)
      {
       case 0:
	 fin = 1;
	 buf[j] = 0;
	 break;
       case '%':
	 cmd++;
	 switch(*cmd)
	 {
	  case 's':
	    buf[j] = 0;
	    strcat(buf, nick);
	    j = strlen(buf);
	    break;
	  default:
	    cmd--;
	    buf[j] = *cmd;
	    j++;
	 }
	 break;
       default:
	 buf[j] = *cmd;
	 j++;
      }
      cmd++;
   }

   /*if(*buf == '/')
   {*/
      handle_command(buf, menu_sess, FALSE);
      free(buf);
   /*   return;
   }*/
}

void menu_quick_item(char *cmd, char *label, GtkWidget *menu, int flags)
{
   GtkWidget *item;
   if(!label)
     item = gtk_menu_item_new();
   else
     item = gtk_menu_item_new_with_label(label);
   gtk_menu_append(GTK_MENU(menu), item);
   if(cmd) gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(popup_cmd), cmd);
   if(flags&(1<<0)) gtk_widget_set_sensitive(GTK_WIDGET(item), FALSE);
   gtk_widget_show(item);
}

void menu_popup(struct session *sess, GdkEventButton *event, char *nick)
{
   GtkWidget *menu;  
   GSList *list = popup_list;
   struct popup *pop;
   
   menu = gtk_menu_new();
   menu_quick_item(0, nick, menu, 1);
   menu_quick_item(0, 0, menu, 1);

   while( list )
   {
      pop = (struct popup *)list->data;
      if(pop->cmd[0])
	menu_quick_item(pop->cmd, pop->name, menu, 0);
      else
	menu_quick_item(0, 0, menu, 1);
      list = list->next;
   }

   gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
                  event->button, event->time);  
}

void menu_open_server_list(GtkWidget *wid, gpointer none)
{
   open_server_list(0, menu_sess);
}

void menu_lastlog(GtkWidget *wid, gpointer none)
{
   show_lastlog_window();
   search_lastlog(menu_sess, NULL);
}

void menu_settings(GtkWidget *wid, gpointer sess)
{
   settings_opengui(menu_sess);
}

void menu_newserver(GtkWidget *wid, gpointer sess)
{
   struct server *serv = new_server();
   if(serv) new_session(serv);
}

void menu_newchannel(GtkWidget *wid, gpointer sess)
{
   new_session(menu_sess->server);
}

void menu_rawlog(GtkWidget *wid, gpointer sess)
{
   open_rawlog(menu_sess->server);
}

void menu_autorejoin(GtkWidget *wid, gpointer sess)
{
   prefs.autorejoin = !prefs.autorejoin;
}

void menu_autoreconnect(GtkWidget *wid, gpointer sess)
{
   prefs.autoreconnect = !prefs.autoreconnect;
}

void menu_autodialog(GtkWidget *wid, gpointer sess)
{
   prefs.autodialog = !prefs.autodialog;
}

void menu_autodccchat(GtkWidget *wid, gpointer sess)
{
   prefs.autodccchat = !prefs.autodccchat;
}

void menu_autodccsend(GtkWidget *wid, gpointer sess)
{
   prefs.autodccsend = !prefs.autodccsend;
   if(prefs.autodccsend)
   {
      if(!strcasecmp(get_home_dir(), prefs.dccdir))
      {
	 gtkutil_simpledialog("*WARNING*\n"
			   "Auto accepting DCC to your home directory\n"
			   "can be dangerous and is exploitable. Eg:\n"
			   "Someone could send you a .bash_profile");
      }
   }
}

void menu_saveexit(GtkWidget *wid, gpointer sess)
{
   prefs.autosave = !prefs.autosave;
}

void menu_close(GtkWidget *wid, gpointer sess)
{
   gtk_widget_destroy(menu_sess->window);
}

void menu_flushbuffer(GtkWidget *wid, gpointer sess)
{
   if(!menu_sess->zvt)
     gtk_text_backward_delete((GtkText *)menu_sess->textgad,
			      gtk_text_get_length((GtkText *)((struct session *)menu_sess)->textgad));
   else
     zvt_clear(menu_sess->textgad);
}

GtkWidget *freq = 0;

void close_savebuffer(void)
{
   gtk_widget_destroy(freq);
   freq = 0;
}

void savebuffer_req_done(GtkWidget *wid, struct session *sess)
{
   int fh;
   char file[128];
   strcpy(file, gtk_file_selection_get_filename(GTK_FILE_SELECTION(freq)));
   close_savebuffer();

   fh = open(file, O_TRUNC | O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      char *buf = gtk_editable_get_chars((GtkEditable*)sess->textgad, 0, -1);
      write(fh, buf, strlen(buf));
      g_free(buf);
      close(fh);
   } else
     gtkutil_simpledialog("Cannot write to that file.");
}

void menu_savebuffer(GtkWidget *wid, gpointer sess)
{
   if(menu_sess->zvt)
   {
      gtkutil_simpledialog("That feature doesn't work for zvt.");
      return;
   }
   if(freq) close_savebuffer();
   freq = gtk_file_selection_new("Select an output filename");
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(freq)->cancel_button),
			     "clicked", (GtkSignalFunc) close_savebuffer, 0);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(freq)->ok_button),
		      "clicked", (GtkSignalFunc) savebuffer_req_done, menu_sess);
   gtk_widget_show(freq);
}

void menu_wallops(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   prefs.wallops = !prefs.wallops;
   if(((struct session *)menu_sess)->server->connected)
   {
      if(prefs.wallops)
        sprintf(tbuf, "MODE %s +w\r\n", ((struct session *)menu_sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -w\r\n", ((struct session *)menu_sess)->server->nick);
      send(((struct session *)menu_sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_servernotice(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   prefs.servernotice = !prefs.servernotice;
   if(((struct session *)menu_sess)->server->connected)
   {
      if(prefs.servernotice)
        sprintf(tbuf, "MODE %s +s\r\n", ((struct session *)menu_sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -s\r\n", ((struct session *)menu_sess)->server->nick);
      send(((struct session *)menu_sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_away(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   prefs.away = !prefs.away;
   if(((struct session *)menu_sess)->server->connected)
   {
      if(prefs.away)
      {
	 sprintf(tbuf, "AWAY :%s\r\n", prefs.awayreason);
	 send(((struct session *)menu_sess)->server->sok, tbuf, strlen(tbuf), 0);
      } else
	send(((struct session *)menu_sess)->server->sok, "AWAY\r\n", 6, 0);
   }
}

void menu_invisible(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   prefs.invisible = !prefs.invisible;
   if(((struct session *)menu_sess)->server->connected)
   {
      if(prefs.invisible)
        sprintf(tbuf, "MODE %s +i\r\n", ((struct session *)menu_sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -i\r\n", ((struct session *)menu_sess)->server->nick);
      send(((struct session *)menu_sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_help(GtkWidget *wid, gpointer sess)
{
   cmd_help(menu_sess, 0, 0, 0);
}

GtkWidget *about = 0;

void about_close(void)
{
   gtk_widget_destroy(about);
   about = 0;
}

void menu_savedefault(GtkWidget *wid, gpointer sess)
{
   if(save_config())
     gtkutil_simpledialog("Settings saved.");
}

void menu_chanlist(GtkWidget *wid, gpointer sess)
{
   chanlist_opengui(((struct session *)menu_sess)->server);
}

void goto_url()
{
   popen("netscape -remote 'openURL(http://xchat.linuxpower.org)'", "r"); 
}

void menu_about(GtkWidget *wid, gpointer sess)
{
   char buf[256];
   struct utsname un;

#ifdef USE_GNOME
   const gchar *author[] = { "Peter Zelezny <zed@linuxpower.org>", 0 };
   uname(&un);
   sprintf(buf,            "Started on ..\t:\t27-July-1998\n"
			   "Web Page ....\t:\thttp://xchat.linuxpower.org\n"
			   "Running on ..\t:\t%s %s\n", un.sysname, un.release);
   
   about = gnome_about_new("X-Chat",
			   VERSION,
			   "(C) 1998 Peter Zelezny",
			   author,
			   buf,
			   0);
   gtk_widget_show(about);
#else
   GtkWidget *label, *button;

   if(about) gtk_widget_destroy(about);

   uname(&un);

   about = gtk_dialog_new();
   gtk_window_position (GTK_WINDOW(about), GTK_WIN_POS_CENTER);
   gtk_window_set_title(GTK_WINDOW(about), "About X-Chat");

   sprintf(buf, "X-Chat "VERSION" by Peter Zelezny\n\n"
		"X-Chat was started on 27-Jun-1998\n\n"
	        "Author EMail: zed@linuxpower.org\n\n"
		"Currently running on %s %s",
	        un.sysname, un.release);
   label = gtk_label_new(buf);
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(about)->vbox), 10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about)->vbox), label, TRUE, TRUE, 10);
   gtk_widget_show(label);

   button = gtk_button_new_with_label("http://xchat.linuxpower.org");
   gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (goto_url), 0);
   gtk_box_pack_end(GTK_BOX(GTK_DIALOG(about)->vbox), button, TRUE, TRUE, 10);
   gtk_widget_show(button);

   button = gtk_button_new_with_label ("Ok");
   GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG(about)->action_area), button, TRUE, TRUE, 10);
   gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (about_close), 0);
   gtk_widget_grab_default (button);
   gtk_widget_show (button);

   gtk_widget_show(about);
#endif
}

#ifdef USE_PERL
void menu_loadperl_callback(struct session *sess, void *data2, char *file)
{
   if(file)
   {
      char tbuf[256];
      sprintf(tbuf, "/LOAD %s", file);
      free(file);
      handle_command(tbuf, sess, FALSE);
   }
}

void menu_loadperl(void)
{
   gtkutil_file_req("Select a script to load", menu_loadperl_callback,
		    menu_sess, 0, FALSE);
}

void menu_unloadall(void)
{
   cmd_unloadall(menu_sess, 0, 0, 0);
}
#endif

void menu_loadplugin_callback(struct session *sess, void *data2, char *file)
{
   if(file)
   {
      char tbuf[256];

      sprintf(tbuf, "/LOADDLL %s", file);
      free(file);
      handle_command(tbuf, sess, FALSE);
   }
}

#ifdef USE_PLUGIN
void menu_loadplugin(void)
{
   gtkutil_file_req("Select a Plugin to load", menu_loadplugin_callback,
		    menu_sess, 0, FALSE);
}

void menu_pluginlist(void)
{
   module_glist(menu_sess);
}

void menu_unloadallplugins(void)
{
   module_unload(0, menu_sess);
}
#endif

#define usercommands_help "User Commands - Special codes:\n\n%1  =  word 1\n%2  =  word 2\n&1  = word 1 to the end of line\n&2  =  word 2 to the end of line\n\neg:\n/cmd john hello\n\n%2 would be \042john\042\n&2 would be \042john hello\042."

void menu_usercommands(void)
{
   editlist_gui_open(command_list, "X-Chat: User Defined Commands", "commands.conf", usercommands_help);
}

void menu_ulpopup(void)
{
   editlist_gui_open(popup_list, "X-Chat: Userlist Popup menu", "popup.conf", 0);
}

void menu_ulbuttons(void)
{
   editlist_gui_open(button_list, "X-Chat: Userlist buttons", "buttons.conf", 0);
}

void menu_ctcpguiopen(void)
{
   editlist_gui_open(ctcp_list, "X-Chat: CTCP Replies", "ctcpreply.conf", 0);
}
/*
void contrib_close(GtkWidget *igad, GtkWidget *contrib)
{
   gtk_widget_destroy(contrib);
}

struct con
{
   gchar *name;
   gchar *help;
};

struct con con[] =
{
   {"Alien",             "Tabbed Nicks"},
   {"Fredrik Lindfeldt", "Configure script"},
   {"Fraser McCrossan",  "CTCP Sounds"},
   {"Manuel A. McLure",  "Perl enhancements"},
   {"Erik Scrafford",    "Colored Nicks, Perl Scripting"},
   {"Shaleh",            "Getting X-Chat to Debian :)"},
   {0, 0}
};

void menu_contrib(GtkWidget *none, gpointer sess)
{
   static gchar *titles[] = { "Name", "Helped with" };
   GtkWidget *button, *wid, *contrib;

   contrib = gtk_dialog_new();
   gtk_widget_set_usize(contrib, 350, 200);
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(contrib)->vbox), 4);
   gtk_window_position (GTK_WINDOW(contrib), GTK_WIN_POS_CENTER);
   gtk_window_set_title(GTK_WINDOW(contrib), "X-Chat Contributors");

   wid = gtkutil_clist_new(2, titles, GTK_DIALOG(contrib)->vbox, GTK_POLICY_ALWAYS,
			   0, 0, 0, 0);
   gtk_clist_set_column_width(GTK_CLIST(wid), 0, 120);

#ifdef USE_GNOME
   button = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
#else
   button = gtk_button_new_with_label ("Ok");
#endif
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_box_pack_start(GTK_BOX (GTK_DIALOG(contrib)->action_area), button, TRUE, TRUE, 10);
   gtk_signal_connect(GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (contrib_close), (gpointer)contrib);
   gtk_widget_grab_default(button);
   gtk_widget_show(button);

   {
      gchar *new[1][2];
      int i = 0;
      while(con[i].name)
      {
	 new[0][0] = con[i].name;
	 new[0][1] = con[i].help;
	 gtk_clist_append(GTK_CLIST(wid), new[0]);
	 i++;
      }
   }

   gtk_widget_show(contrib);
}
*/
#ifdef USE_GNOME

GnomeUIInfo xchatmenu[] =
{
     {
	GNOME_APP_UI_ITEM,
	N_("Server List.."), 0,
	menu_open_server_list, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_RED,
	0, 0, 0
     },
     {
	GNOME_APP_UI_ITEM,
	0, 0,
	menu_newchannel, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	0, 0, 0
     },
     {
	GNOME_APP_UI_ITEM,
	0, 0,
	menu_newserver, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	0, 0, 0
     },
     GNOMEUIINFO_SEPARATOR,
     {
	GNOME_APP_UI_ITEM,
	N_("Close"), 0,
	menu_close, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	0, 0, 0
     },
     GNOMEUIINFO_SEPARATOR,
     {
	GNOME_APP_UI_ITEM,
	N_("Quit"), 0,
	xchat_cleanup, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
	0, 0, 0
     },
     GNOMEUIINFO_END
};

GnomeUIInfo windowsmenu[] =
{
   {
      GNOME_APP_UI_ITEM,
      N_("Channel List Window.."), 0,
      menu_chanlist
   },   
   {
      GNOME_APP_UI_ITEM,
      N_("DCC Send Window.."), 0,
      open_dcc_send_window, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("DCC Receive Window.."), 0,
      open_dcc_recv_window, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("DCC Chat Window.."), 0,
      open_dcc_chat_window, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Raw Log Window.."), 0,
      menu_rawlog, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("URL Grabber Window.."), 0,
      url_opengui, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Notify List Window.."), 0,
      (menucallback)notify_opengui, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Lastlog Window.."), 0,
      menu_lastlog, 0, 0, 0, 0, 0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
   {
      GNOME_APP_UI_ITEM,
      N_("Flush Buffer"), 0,
      menu_flushbuffer, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Save Buffer.."), 0,
      menu_savebuffer, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0, 0, 0
   },
   GNOMEUIINFO_END
};

GnomeUIInfo usermodesmenu[] =
{
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Invisible"), 0,
      menu_invisible, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Receive Wallops"), 0,
      menu_wallops, 0, 0, GNOME_APP_PIXMAP_NONE, 0, 0, 0, 0
   },
      {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Receive Server Notices"), 0,
      menu_servernotice, 0, 0, 0, 0, 0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Marked Away"), 0,
      menu_away, 0, 0, GNOME_APP_PIXMAP_NONE, 0, 0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Auto Rejoin on Kick"), 0,
      menu_autorejoin, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Auto ReConnect to Server"), 0,
      menu_autoreconnect, 0, 0, GNOME_APP_PIXMAP_NONE, 0, 0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Auto Open Dialog Windows"), 0,
      menu_autodialog, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Auto Accept DCC Chat"), 0,
      menu_autodccchat, 0, 0, 0, 0, 0, 0, 0
   },
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Auto Accept DCC Send"), 0,
      menu_autodccsend, 0, 0, 0, 0, 0, 0, 0
   },
   GNOMEUIINFO_END
};

GnomeUIInfo settingsmenu[] =
{
   {
      GNOME_APP_UI_ITEM,
      N_("Setup.."), 0,
      menu_settings, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("User Commands.."), 0,
      menu_usercommands, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("CTCP Replies.."), 0,
      menu_ctcpguiopen, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Userlist Buttons.."), 0,
      menu_ulbuttons, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Userlist Popup.."), 0,
      menu_ulpopup, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
   {
      GNOME_APP_UI_ITEM,
      N_("Save Settings now"), 0,
      menu_savedefault, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      0, 0, 0
   },
   {
      GNOME_APP_UI_TOGGLEITEM,
      N_("Save Settings on exit"), 0,
      menu_saveexit, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      0, 0, 0
   },
   GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] =
{
   {
      GNOME_APP_UI_ITEM,
      N_("Help.."), 0,
      menu_help, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_HELP,
      0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,
/*   {
      GNOME_APP_UI_ITEM,
      N_("Contributors.."), 0,
      menu_contrib, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
      0, 0, 0
   },
   GNOMEUIINFO_SEPARATOR,*/
   {
      GNOME_APP_UI_ITEM,
      N_("About X-Chat.."), 0,
      menu_about, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
      0, 0, 0
   },
   GNOMEUIINFO_END  
};

GnomeUIInfo scriptsmenu[] =
{
#ifdef USE_PERL
   {
      GNOME_APP_UI_ITEM,
      N_("Load Perl Script.."), 0,
      menu_loadperl, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Unload All Scripts"), 0,
      menu_unloadall, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
      0, 0, 0
   },
#else
   {
      GNOME_APP_UI_ITEM,
      N_("Load Perl Script.."), 0,
      0, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Unload All Scripts"), 0,
      0, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
      0, 0, 0
   },
#endif
   GNOMEUIINFO_SEPARATOR,
#ifdef USE_PLUGIN
   {
      GNOME_APP_UI_ITEM,
      N_("Load Plugin (*.so).."), 0,
      menu_loadplugin, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      0, 0, 0
   },
   {
      GNOME_APP_UI_ITEM,
      N_("Unload All Plugins"), 0,
      menu_unloadallplugins, 0, 0,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
      0, 0, 0
   },
   {
   	GNOME_APP_UI_ITEM,
	N_("Plugin List"), 0,
	menu_pluginlist, 0, 0,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_GREEN,
	0, 0, 0
   },
#else
     {
	       GNOME_APP_UI_ITEM,
	       N_("Load Plugin (*.so).."), 0,
	       0, 0, 0,
	       GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
	       0, 0, 0
      },
      {
	       GNOME_APP_UI_ITEM,
	       N_("Unload All Plugins"), 0,
	       0, 0, 0,
	       GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	       0, 0, 0
      },
      {
   		GNOME_APP_UI_ITEM,
		N_("Plugin List"), 0,
		0, 0, 0,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_GREEN,
		0, 0, 0
      },
#endif
   GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] =
{
   GNOMEUIINFO_SUBTREE(N_("_X-Chat"), xchatmenu), 
   GNOMEUIINFO_SUBTREE(N_("_Windows"), windowsmenu), 
   GNOMEUIINFO_SUBTREE(N_("User _Modes"), usermodesmenu),
   GNOMEUIINFO_SUBTREE(N_("_Settings"), settingsmenu),
   GNOMEUIINFO_SUBTREE(N_("S_cripts & Plugins"), scriptsmenu),
   GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu),
   GNOMEUIINFO_END
};

void createmenus(void *app, struct session *sess)
{
   if(!menu_sess) menu_sess = sess;
   if(prefs.tabchannels)
   {
      xchatmenu[1].label = N_("New Channel Tab..");
      xchatmenu[2].label = N_("New Server Tab..");
   } else {
      xchatmenu[1].label = N_("New Channel Window..");
      xchatmenu[2].label = N_("New Server Window..");
   }
   gnome_app_create_menus(GNOME_APP(app), mainmenu);
   gtk_menu_item_right_justify(GTK_MENU_ITEM(mainmenu[5].widget));

   /* is it legal to poke in the initial values?? */
   ((GtkCheckMenuItem*)(usermodesmenu[0].widget))->active = prefs.invisible;
   ((GtkCheckMenuItem*)(usermodesmenu[1].widget))->active = prefs.wallops;
   ((GtkCheckMenuItem*)(usermodesmenu[2].widget))->active = prefs.servernotice;
   ((GtkCheckMenuItem*)(usermodesmenu[4].widget))->active = prefs.away;
   ((GtkCheckMenuItem*)(usermodesmenu[6].widget))->active = prefs.autorejoin;
   ((GtkCheckMenuItem*)(usermodesmenu[7].widget))->active = prefs.autoreconnect;
   ((GtkCheckMenuItem*)(usermodesmenu[9].widget))->active = prefs.autodialog;
   ((GtkCheckMenuItem*)(usermodesmenu[10].widget))->active = prefs.autodccchat;
   ((GtkCheckMenuItem*)(usermodesmenu[11].widget))->active = prefs.autodccsend;
   ((GtkCheckMenuItem*)(settingsmenu[7].widget))->active = prefs.autosave;

#ifndef USE_PERL
   gtk_widget_set_sensitive(scriptsmenu[0].widget, FALSE);
   gtk_widget_set_sensitive(scriptsmenu[1].widget, FALSE);
#endif
#ifndef USE_PLUGIN
   gtk_widget_set_sensitive(scriptsmenu[3].widget, FALSE);
   gtk_widget_set_sensitive(scriptsmenu[4].widget, FALSE);
   gtk_widget_set_sensitive(scriptsmenu[5].widget, FALSE);
#endif
}

#else
static struct mymenu mymenu[] =
{
     {M_NEWMENU, "X-Chat", 0,0,1},
     {M_MENU, "Server List..", menu_open_server_list, 0, 1},
     {M_MENU, 0, menu_newchannel,0,1},
     {M_MENU, 0, menu_newserver,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Close", menu_close,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Quit", xchat_cleanup,0,1}, /* 7 */
     
     {M_NEWMENU, "Windows", 0,0,1},
     {M_MENU, "Channel List Window..", menu_chanlist,0,1},
     {M_MENU, "DCC Send Window..", open_dcc_send_window,0,1},
     {M_MENU, "DCC Receive Window..", open_dcc_recv_window,0,1},
     {M_MENU, "DCC Chat Window..", open_dcc_chat_window,0,1},
     {M_MENU, "Raw Log Window..", menu_rawlog,0,1},
     {M_MENU, "URL Grabber Window..", url_opengui,0,1},
     {M_MENU, "Notify List Window..", (menucallback)notify_opengui,0,1},
     {M_MENU, "Lastlog Window..", menu_lastlog,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Flush Buffer", menu_flushbuffer,0,1},
     {M_MENU, "Save Buffer..", menu_savebuffer,0,1}, /* 19 */
     
     {M_NEWMENU, "User Modes", 0,0,1},
     {M_MENUTOG, "Invisible", menu_invisible,1,1},
     {M_MENUTOG, "Receive Wallops", menu_wallops,1,1},
     {M_MENUTOG, "Receive Server Notices", menu_servernotice,1,1},
     {M_SEP, 0, 0,0,0},
     {M_MENUTOG, "Marked Away", menu_away,0,1},
     {M_SEP, 0, 0,0},
     {M_MENUTOG, "Auto ReJoin on Kick", menu_autorejoin,0,1},
     {M_MENUTOG, "Auto ReConnect to Server", menu_autoreconnect,0,1},
     {M_SEP, 0, 0,0},
     {M_MENUTOG, "Auto Open Dialog Windows", menu_autodialog,0,1}, /* 30 */
     {M_MENUTOG, "Auto Accept DCC Chat", menu_autodccchat,0,1},
     {M_MENUTOG, "Auto Accept DCC Send", menu_autodccsend,0,1},

     {M_NEWMENU, "Settings", 0,0,1}, /* 33 */
     {M_MENU, "Setup..", menu_settings,0,1},
     {M_MENU, "User Commands..", (menucallback)menu_usercommands,0,1},
     {M_MENU, "CTCP Replies..", (menucallback)menu_ctcpguiopen,0,1},
     {M_MENU, "Userlist Buttons..", (menucallback)menu_ulbuttons,0,1},
     {M_MENU, "Userlist Popup..", (menucallback)menu_ulpopup,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Save Settings now", menu_savedefault,0,1},
     {M_MENUTOG, "Save Settings on exit", menu_saveexit,1,1}, 

     {M_NEWMENU, "Scripts & Plugins", 0,0,1},
#ifdef USE_PERL
     {M_MENU, "Load Perl Script..", (menucallback)menu_loadperl,0,1},
     {M_MENU, "Unload All Scripts", (menucallback)menu_unloadall,0,1},
#else
     {M_MENU, "Load Perl Script..", 0,0,0},
     {M_MENU, "Unload All Scripts", 0,0,0},
#endif
     {M_SEP, 0, 0,0,0},
#ifdef USE_PLUGIN
     {M_MENU, "Load Plugin (*.so)..", (menucallback)menu_loadplugin,0,1},
     {M_MENU, "Unload All Plugins", (menucallback)menu_unloadallplugins,0,1},
     {M_MENU, "Plugin List", (menucallback)menu_pluginlist, 0, 1},
#else
     {M_MENU, "Load Plugin (*.so)..", 0,0,0},
     {M_MENU, "Unload All Plugins", 0,0,0},
     {M_MENU, "Plugin List", 0, 0, 0},
#endif
     
     {M_NEWMENURIGHT, "Help", 0, 0, 1},
     {M_MENU, "Help..", menu_help, 0, 1},
     {M_SEP, 0, 0,0,0},
/*     {M_MENU, "Contributors..", menu_contrib, 0, 1},
     {M_SEP, 0, 0,0,0},*/
     {M_MENU, "About X-Chat..", menu_about, 0, 1},

     {M_END, 0, 0,0,0},
};


GtkWidget *createmenus(struct session *sess)
{
   int i = 0;
   GtkWidget *item;
   GtkWidget *menu = 0;
   GtkWidget *menu_item = 0;
   GtkWidget *menu_bar = gtk_menu_bar_new();

   if(!menu_sess) menu_sess = sess;

   if(prefs.tabchannels)
   {
      mymenu[2].text = "New Channel Tab..";
      mymenu[3].text = "New Server Tab..";
   } else {
      mymenu[2].text = "New Channel Window..";
      mymenu[3].text = "New Server Window..";
   }

   mymenu[21].state = prefs.invisible;
   mymenu[22].state = prefs.wallops;
   mymenu[23].state = prefs.servernotice;
   mymenu[27].state = prefs.autorejoin;
   mymenu[28].state = prefs.autoreconnect;
   mymenu[30].state = prefs.autodialog;
   mymenu[31].state = prefs.autodccchat;
   mymenu[32].state = prefs.autodccsend;
   mymenu[41].state = prefs.autosave;

   while(1)
   {
      switch(mymenu[i].type)
      {
       case M_NEWMENURIGHT:
       case M_NEWMENU:
	 if(menu) gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
	 menu = gtk_menu_new();
	 menu_item = gtk_menu_item_new_with_label(mymenu[i].text);
	 if(mymenu[i].type == M_NEWMENURIGHT)
	   gtk_menu_item_right_justify((GtkMenuItem*)menu_item);
	 gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
	 gtk_widget_show(menu_item);
	 break;
       case M_MENU:
	 item = gtk_menu_item_new_with_label(mymenu[i].text);
	 if(mymenu[i].callback)
	   gtk_signal_connect_object(GTK_OBJECT(item), "activate",
				     GTK_SIGNAL_FUNC(mymenu[i].callback), (gpointer)sess);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);
	 gtk_widget_set_sensitive(item, mymenu[i].activate);
	 break;
       case M_MENUTOG:
	 item = gtk_check_menu_item_new_with_label(mymenu[i].text);
	 gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(item), mymenu[i].state);
	 if(mymenu[i].callback)
	   gtk_signal_connect_object(GTK_OBJECT(item), "toggled",
				     GTK_SIGNAL_FUNC(mymenu[i].callback), (gpointer)sess);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);
	 gtk_widget_set_sensitive(item, mymenu[i].activate);
	 break;
       case M_SEP:
	 item = gtk_menu_item_new();
	 gtk_widget_set_sensitive(item, FALSE);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);	 
	 break;
       case M_END:
	 if(menu) gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
	 return(menu_bar);
      }
      i++;
   }
}
#endif
