/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <string.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "history.h"


void history_add(struct history *his, char *text)
{
   if(his->lines[his->realpos]) free(his->lines[his->realpos]);
   his->lines[his->realpos] = strdup(text);
   his->realpos++;
   if(his->realpos == HISTORY_SIZE) his->realpos = 0;
   his->pos = his->realpos;
}

void history_free(struct history *his)
{
   int i;
   for(i = 0; i < HISTORY_SIZE; i++)
   {
      if(his->lines[i]) free(his->lines[i]);
   }
}

/*void history_function_key(GtkWidget *entry, int which)
{
   gtk_entry_append_text(GTK_ENTRY(entry), "test");
}*/

int history_keypress(GtkWidget *widget, GdkEventKey *event, struct history *his)
{
   switch (event->keyval)
   {
/*    case GDK_F1: history_function_key(widget, 1); break;
    case GDK_F2: history_function_key(widget, 2); break;
    case GDK_F3: history_function_key(widget, 3); break;
    case GDK_F4: history_function_key(widget, 4); break;
    case GDK_F5: history_function_key(widget, 5); break;
    case GDK_F6: history_function_key(widget, 6); break;
    case GDK_F7: history_function_key(widget, 7); break;
    case GDK_F8: history_function_key(widget, 8); break;
    case GDK_F9: history_function_key(widget, 9); break;
    case GDK_F10: history_function_key(widget, 10); break;*/
    case GDK_Down:
      his->pos++;
      if(his->pos == HISTORY_SIZE) his->pos = 0;
      if(his->lines[his->pos])
      {
	 gtk_entry_set_text(GTK_ENTRY(widget), his->lines[his->pos]);
      } else {
	 if(his->pos != 0)
	   his->pos--;
	 else
	   his->pos = (HISTORY_SIZE-1);
      }
      break;

    case GDK_Up:
      if(his->pos == 0)
	his->pos = (HISTORY_SIZE-1);
      else
	his->pos--;
      if(his->lines[his->pos])
      {
	 gtk_entry_set_text(GTK_ENTRY(widget), his->lines[his->pos]);
      } else {
	 if(his->pos == (HISTORY_SIZE-1))
	   his->pos = 0;
	 else
	   his->pos++;
      }
      break;

      /*case GDK_Page_Up:
        break;

      case GDK_Page_Down:
	break;*/

    default:
      return 0;
   }
   gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
   return 1;
}
