/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#undef USE_GNOME
#include "xchat.h"
#include "gtkutil.h"
#include <fcntl.h>
#include <time.h>


extern void path_part(char *file, char *path);

extern char last_dir[256];


void chanlist_addentry(struct server *serv, char *chan, char *users, char *topic)
{
   gchar *new[1][3];

   if(atoi(users) < serv->chanlist_minusers) return;

   new[0][0] = chan;
   new[0][1] = users;
   new[0][2] = topic;

   gtk_clist_append(GTK_CLIST(serv->chanlist_list), new[0]);
}

void chanlist_join(GtkWidget *wid, struct server *serv)
{
   int row;
   char *chan;

   row = gtkutil_clist_selection(serv->chanlist_list);
   if(row != -1)
   {
      gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), row, 0, &chan);
      if(serv->connected)
      {
	 char tbuf[128];
	 sprintf(tbuf, "JOIN %s\r\n", chan);
	 send(serv->sok, tbuf, strlen(tbuf), 0);
      }
   }
}

void chanlist_filereq_done(struct server *serv, void *data2, char *file)
{
   time_t t = time(0);
   int i = 0;
   int fh;
   char *chan, *users, *topic;
   char buf[256];

   if(!file) return;

   fh = open(file, O_TRUNC | O_WRONLY | O_CREAT, 0600);
   free(file);

   if(fh == -1) return;

   sprintf(buf, "X-Chat Channel List: %s - %s\n", serv->servername, ctime(&t));
   write(fh, buf, strlen(buf));

   while(1)
   {
      if(!gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), i, 0, &chan)) break;
      gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), i, 1, &users);
      gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), i, 2, &topic);
      i++;
      sprintf(buf, "%-16s %-5s%s\n", chan, users, topic);
      write(fh, buf, strlen(buf));
   }

   close(fh);
}

void chanlist_save(GtkWidget *wid, struct server *serv)
{
   char *temp;

   if(!gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), 0, 0, &temp))
   {
      gtkutil_simpledialog("I can't save an empty list!");
      return;
   }
   
   gtkutil_file_req("Select an output filename", chanlist_filereq_done,
		    serv, 0, TRUE);
}

void chanlist_refresh(GtkWidget *wid, struct server *serv)
{
   gtk_clist_clear(GTK_CLIST(serv->chanlist_list));
   if(serv->connected)
      send(serv->sok, "LIST\r\n", 6, 0);
}

/*void chanlist_minusers(GtkWidget *wid, struct server *serv)
{
   serv->chanlist_minusers = gtk_spin_button_get_value_as_int(wid);
}*/

void chanlist_minusers(GtkWidget *wid, struct server *serv)
{
   serv->chanlist_minusers = atoi(gtk_entry_get_text(GTK_ENTRY(wid)));
}

void chanlist_row_selected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct server *serv)
{
   if(even && even->type == GDK_2BUTTON_PRESS)
   {
      chanlist_join(0, (struct server *)serv);
   }
}

void chanlist_closegui(GtkWidget *wid, struct server *serv)
{
   if(serv->chanlist_window)
   {
      gtk_widget_destroy(serv->chanlist_window);
      serv->chanlist_window = 0;
   }
}

void chanlist_opengui(struct server *serv)
{
   static gchar *titles[] = {"Channel", "Users", "Topic"};
   GtkWidget *vbox, *hbox, *wid;/*, *adj;*/
   char tbuf[256];

   if(serv->chanlist_window)
   {
      chanlist_closegui(0, serv);
      return;
   }

   sprintf(tbuf, "X-Chat: Channel List (%s)", serv->servername);

   serv->chanlist_window = gtkutil_window_new(tbuf, 450, 200,
					      chanlist_closegui, serv);

   vbox = gtk_vbox_new(FALSE, 2);
   gtk_container_border_width(GTK_CONTAINER(vbox), 4);
   gtk_container_add(GTK_CONTAINER(serv->chanlist_window), vbox);
   gtk_widget_show(vbox);

   hbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 4);
   gtk_widget_show(hbox);

   wid = gtk_label_new("Minimum Users:");
   gtk_widget_set_usize(wid, 120, 0);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   wid = gtk_entry_new_with_max_length(6);
   gtk_widget_set_usize(wid, 40, 0);
   gtk_entry_set_text(GTK_ENTRY(wid), "3");
   gtk_signal_connect(GTK_OBJECT(wid), "changed",
		      GTK_SIGNAL_FUNC(chanlist_minusers), serv);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);
   serv->chanlist_minusers = 3;

/*   adj = gtk_adjustment_new(3, 1, 9999, 1, 1, 1);
   wid = gtk_spin_button_new(adj, 1, 4);
   gtk_spin_button_set_value(wid, 3);
   gtk_signal_connect(GTK_OBJECT(wid), "changed",
		      GTK_SIGNAL_FUNC(chanlist_minusers), serv);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);*/

   serv->chanlist_list = gtkutil_clist_new(3, titles, vbox, GTK_POLICY_ALWAYS,
					   chanlist_row_selected, (gpointer)serv,
					   0, 0);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 0, 90);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 1, 50);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 2, 165);
   gtk_clist_set_auto_sort(GTK_CLIST(serv->chanlist_list), 1);

   hbox = gtk_hbox_new(0, 1);
   gtk_box_pack_end(GTK_BOX(vbox), hbox, 0, 0, 0);
   gtk_widget_show(hbox);

   gtkutil_button_new("Refresh the list", 0, 0, chanlist_refresh, serv, hbox);
   gtkutil_button_new("Save the list", 0, 0, chanlist_save, serv, hbox);
   gtkutil_button_new("Join Channel", 0, 0, chanlist_join, serv, hbox);

   gtk_widget_show(serv->chanlist_window);
}

