/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>
#include "gtkutil.h"


extern struct xchatprefs prefs;

extern char *get_home_dir(void);


char *get_xdir(void)
{
   static char xdir[128];
   struct passwd *pw;
   pw = getpwuid(getuid());
   sprintf(xdir, "%s/.xchat", pw->pw_dir);
   return(xdir);
}

void check_prefs_dir(void)
{
   struct stat st;
   char *xdir = get_xdir();
   if(stat(xdir, &st) < 0) mkdir(xdir, S_IRUSR | S_IWUSR | S_IXUSR);
}

char *default_file(void)
{
   static char file[142];
   struct passwd *pw;
   pw = getpwuid(getuid());
   sprintf(file, "%s/.xchat/xchat.cfg", pw->pw_dir);
   return(file);
}

void load_config(void)
{
   int fh;

   memset(&prefs, 0, sizeof(struct xchatprefs));

   check_prefs_dir();

   fh = open(default_file(), O_RDONLY);
   if(fh != -1)
   {
      read(fh, &prefs, sizeof(struct xchatprefs));
      close(fh);
      prefs.away = FALSE;
#ifndef USE_GNOME
      prefs.zvt = FALSE;
#endif
      prefs.dialogzvt = FALSE;
   } else {
      uid_t uid = getuid();
      struct passwd *pw = getpwuid(uid);
      if(uid == 0)
      {
	 GtkWidget *dialog =
	 gtkutil_simpledialog("Running IRC as root is stupid!");
	 while(GTK_IS_WIDGET(dialog))
	 {
	    gtk_main_iteration();
	 }	 
      }
      strcpy(prefs.nick1, pw->pw_name);
      strcpy(prefs.nick2, pw->pw_name); strcat(prefs.nick2, "_");
      strcpy(prefs.nick3, pw->pw_name); strcat(prefs.nick3, "__");
      strcpy(prefs.realname, pw->pw_name);
      strcpy(prefs.username, pw->pw_name);
      prefs.autosave = TRUE;
      prefs.autodialog = TRUE;
      prefs.autorejoin = TRUE;
      prefs.autoreconnect = TRUE;
      prefs.tabchannels = TRUE;
      prefs.privmsgtab = TRUE;
      prefs.bg_color = 1;
      prefs.dialog_bg_color = 1;
      prefs.nu_color = 4;
      strcpy(prefs.awayreason, "I'm busy");
      strcpy(prefs.quitreason, "xchat exiting..");
      strcpy(prefs.font_normal, "-misc-fixed-medium-r-semicondensed-*-*-100-*-*-c-*-iso8859-1");
      strcpy(prefs.font_bold, "-misc-fixed-bold-r-semicondensed-*-*-100-*-*-c-*-iso8859-1");
      strcpy(prefs.dialog_font_normal, prefs.font_normal);
      strcpy(prefs.dialog_font_bold, prefs.font_bold);
      strcpy(prefs.sounddir, get_home_dir());
      strcpy(prefs.soundcmd, "play");      
   }
   if(prefs.dccdir[0] == 0)
     strcpy(prefs.dccdir, get_home_dir());

   if(prefs.mainwindow_height == 0) prefs.mainwindow_height = 420;
   if(prefs.mainwindow_width  == 0) prefs.mainwindow_width  = 599;
   if(prefs.mainwindow_width < 116) prefs.mainwindow_width  = 116;
   if(prefs.zvt_lines < 1) prefs.zvt_lines = 200;
}

int save_config(void)
{
   int fh;

   check_prefs_dir();

   fh = open(default_file(), O_TRUNC | O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      write(fh, &prefs, sizeof(struct xchatprefs));
      close(fh);
      return TRUE;
   }
   return FALSE;
}
