/*
	Audio File Library
	Copyright (C) 1998, Michael Pruett <michael@68k.org>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the 
	Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
	Boston, MA  02111-1307  USA.
*/

/*
	swapblock.h

	This file contains interfaces to functions which efficiently
	perform byte swapping, shifting, and writing.
*/

#ifndef SWAPBLOCK_H
#define SWAPBLOCK_H

#include <stdio.h>
#include <sys/types.h>

/* _af_writeswapblock16 returns the number of byte-swapped 16-bit integers
	successfully written to the file pointer fp. */
ssize_t _af_writeswapblock16 (FILE *fp, void *data, size_t count);

/* _af_writeswapblock32 returns the number of byte-swapped 32-bit integers
	successfully written to the file pointer fp. */
ssize_t _af_writeswapblock32 (FILE *fp, void *data, size_t count);

/* swapblock16 performs an in-place byte swap on a block of 16-bit integers. */
void _af_swapblock16 (void *data, size_t count);

/* swapblock32 performs an in-place byte swap on a block of 32-bit integers. */
void _af_swapblock32 (void *data, size_t count);

ssize_t _af_writecompress4to3 (FILE *fp, void *data, size_t count, int shift);

#endif
