/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPExtendedRequest
implements JDAPProtocolOp {
    protected String m_oid;
    protected byte[] m_value;

    public JDAPExtendedRequest(String string, byte[] byArray) {
        this.m_oid = string;
        this.m_value = byArray;
    }

    public int getType() {
        return 23;
    }

    public BERElement getBERElement() {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERTag(64, new BEROctetString(this.m_oid), true));
        if (this.m_value != null) {
            bERSequence.addElement(new BERTag(65, new BEROctetString(this.m_value, 0, this.m_value.length), true));
        }
        BERTag bERTag = new BERTag(119, bERSequence, true);
        return bERTag;
    }

    public String getParamString() {
        String string = "";
        if (this.m_value != null) {
            try {
                string = new String(this.m_value, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return "{OID='" + this.m_oid + "', value='" + string + "'}";
    }

    public String toString() {
        return "JDAPExtendedRequest " + this.getParamString();
    }
}

