/*
 * File:	feature.h
 *
 * Compile-time configuration.
 *-----------------------------------------------------------------------
 * Copyright (C) 1997 1998 Oezguer Kesim <kesim@math.fu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *----------------------------------------------------------------------*/
#ifndef _FEATURE_H
#define _FEATURE_H

/*-----------------------SCREEN OPTIONS AND COLOURS---------------------*/
/*
 * Define the name of the environment variable to be used in
 * addition to the "PATH" environment and the `path' resource.
 * Usually it should point to where you keep your background pixmaps and/or
 * your menu files
 */
#define PATH_ENV	"RXVTPATH"

/*
 * Avoid enabling the colour cursor (-cr, cursorColor, cursorColor2)
 */
/* #define NO_CURSORCOLOR */
 
/*
 * Suppress use of BOLD and BLINK attributes for setting bright foreground
 * and background, respectively.  Simulate BOLD using colorBD, boldFont or
 * overstrike characters.
 */
/* #define NO_BRIGHTCOLOR */

/*
 * Disable separate colours for bold/underline
 */
/* #define NO_BOLDUNDERLINE */

/*
 * Disable using simulated bold using overstrike and avoid the dreaded pixel
 * droppings.  You can also turn off overstrike just for multi char fonts
 * Note: NO_BOLDOVERSTRIKE implies NO_BOLDOVERSTRIKE_MULTI
 */
/* #define NO_BOLDOVERSTRIKE */
/* #define NO_BOLDOVERSTRIKE_MULTI */

/*
 * Also use bold font or overstrike even if we use colour for bold
 */
#define VERYBOLD
 
/*
 * Compile without support for real bold fonts
 */
/* #define NO_BOLDFONT */
 
/*
 * Disable the secondary screen ("\E[?47h" / "\E[?47l")
 * Many programs use the secondary screen as they workplace. The advantage
 * is, that when you exit those programs, your previous screen contents (in
 * general the shell as you left it) will be shown again.
 */
/* #define NO_SECONDARY_SCREEN */
 
/*
 * Limit the number of screenfulls between screen refreshes during hard & fast
 * scrolling [default: 1]
 */
/* #define REFRESH_PERIOD	1 */

/*
 * If the screen has 24 bit mode, use that even if the default is 8 bit.
 */
#define PREFER_24BIT

/*
 * Use alternative code for screen-refreshes when compiled with xpm-support.
 * Seems to be obsolete due to the new screen-update routines.
 */
/* #define XPM_BUFFERING */

/*
 * Printer pipe which will be used for emulation of attached vt100 printer
 */
/* #define PRINTPIPE	"lpr" */

/*------------------------------RESOURCES-------------------------------*/
/*
 * Don't use Xdefaults at all
 */
/* #define NO_RESOURCES */

/*
 * Use XGetDefault() instead of the default, which is to use a substitute for
 * using XGetDefaults() that saves 60-150kB memory
 * The default is best if all you want to do is put defaults in ~/.Xdefaults
 */
/* #define USE_XGETDEFAULT */

/*
 * Define where to find installed application defaults for rxvt
 * Only if USE_XGETDEFAULT is not defined.
 */
#ifndef XAPPLOADDIR
/* #define XAPPLOADDIR	"/usr/lib/X11/app-defaults" */
#endif
 
/*
 * Add support for the Offix DND (Drag 'n' Drop) protocol
 */
/* #define OFFIX_DND */

/*---------------------------------KEYS---------------------------------*/
/*
 * Use the unadulterated X server value for the Delete key
 */
#if defined (__sun__) || defined (__svr4__)
# define NO_DELETE_KEY		/* favoured settings for these systems */
#endif
/* #define NO_DELETE_KEY */

/*
 * Force the Backspace key to generate either ^H or ^? and avoid using
 * the current stty setting of erase to guess a Backspace value of
 * either ^H or ^?.
 * 	define	FORCE_BACKSPACE for ^H ,
 * 		FORCE_DELETE    for ^?
 * 	or 	leave both undefined for using the current stty-settings
 */
#define FORCE_BACKSPACE
/* #define FORCE_DELETE */

/*
 * Choose one of these values to be the `hotkey' for changing font.
 * This has been superceded and is only for you older users
 */
/* #define HOTKEY_CTRL */
/* #define HOTKEY_META */

/*
 * To use
 *	Home = "\E[1~", End = "\E[4~"
 * instead of
 *	Home = "\E[7~", End = "\E[8~"	[default]
 */
#define LINUX_KEYS

/*
 * Enable the keysym resource which allows you to define strings associated
 * with various KeySyms (0xFF00 - 0xFFFF).
 * Only works with the default hand-rolled resources.
 */
#ifndef NO_RESOURCES
#define KEYSYM_RESOURCE
#endif

/*
 * Allow unshifted Next/Prior keys to scroll forward/back
 * (in addition to shift+Next/shift+Prior)       --pjh
 */
/* #define UNSHIFTED_SCROLLKEYS */
  
/*--------------------------------MOUSE---------------------------------*/
/*
 * Disable sending escape sequences (up, down, page up/down)
 * from the scrollbar when XTerm mouse reporting is enabled
 */
/* #define NO_SCROLLBAR_REPORT */

/*
 * Default separating chars for multiple-click selection
 * Space and tab are separate separating characters and are not settable
 */
#define CUTCHARS	"\"&'()*,;<=>?@[\\]^`{|}~"

/*
 * Add run-time support for changing the cutchars for double click selection
 */
#define CUTCHAR_RESOURCE

/*
 * Have mouse reporting include double-click info for button1
 */
/* #define MOUSE_REPORT_DOUBLECLICK */

/*
 * Set delay between multiple click events [default: 500]
 */
/* #define MULTICLICK_TIME 500 */

/*
 * Continual scrolling on scrollbar button press
 */
/* #define SCROLLBAR_BUTTON_CONTINUAL_SCROLLING */

/*
 * Set delay periods for continuous scrolling with scrollbar buttons
 */
/* #define SCROLLBAR_INITIAL_DELAY 40 */
/* #define SCROLLBAR_CONTINUOUS_DELAY 2 */

/*
 * Use old word selection (double click) style for you older users
 */
/* #define OLD_WORD_SELECTION */

/*--------------------------------BELL----------------------------------*/
/*
 * Disable automatic de-iconify when a bell is received
 */
/* #define NO_MAPALERT */

/*
 * Have mapAlert behaviour selectable with mapAlert resource
 */
#define MAPALERT_OPTION

/*-----------------------------SCROLL BAR-------------------------------*/
/*
 * Choose the scrollbar width - should be an even number [default: 10]
 * Except for XTERM_SCROLLBAR: it is *always* 15.
 */
/* #define SB_WIDTH 10 */

/* 
 * When using Rxvt scrollbar, clicking above or below the slider will move
 * 1/4 of the screen height, if possible.  Setting RXVT_SCROLL_FULL will move
 * it one screen height less one line, if possible
 */
/* #define RXVT_SCROLL_FULL 1 */

/* 
 * (Hops) draw an internal border line on inside edge of the scrollbar
 */
#define SB_BORDER

/*
 * (Hops)  Uncomment to revert to original funky behaviour of
 * of having scroll thumb align on thumb top rather than ptr
 * position in thumb (or center of thumb).
 * Default Behavior becomes alignment to where grab thumb.
 * Only for non XTERM scrollbar
 */
/* #define FUNKY_SCROLL_BEHAVIOUR */

/*------------------------------MENU BAR--------------------------------*/
/*
 * Choose how many of (experimental) menuBars you want to be able to stack at
 * one time.
 *  A value of 1 disables menuBar stacking.
 *  A value of 0 disables menuBar all together.
 *  Note that the amount of memory overhead is the same for any value >= 2.
 */
#define MENUBAR_MAX 8

/*
 * Change the default shadow style
 */
/* #define MENUBAR_SHADOW_IN */

/*
 * Change the default shadow style
 */
#define MENU_SHADOW_IN

/*---------------------------MULTILINGUAL-------------------------------*/
/*
 * Allow run-time selection of Meta (Alt) to set the 8th bit on
 */
#define META8_OPTION

/*---------------------------DISPLAY OPTIONS----------------------------*/
/*
 * Have DISPLAY environment variable & "\E[7n" transmit display with IP number
 */
/* #define DISPLAY_IS_IP */

/*
 * Have "\E[7n" transmit the display name.
 * This has been cited as a potential security hole.
 */
/* #define ENABLE_DISPLAY_ANSWER */

/* 
 * Change what ESC Z transmits instead of the default "\E[?1;2c"
 */
/* #define ESCZ_ANSWER	"\033[?1;2C" */

/*
 * Check the current value of the window-time/icon-name and avoid
 * re-setting it to the same value -- avoids unnecessary window refreshes
 */
#define SMART_WINDOW_TITLE

/*
 * Allow foreground/background colour to be changed with an
 * xterm escape sequence "\E]39;colour^G" -- still experimental
 */
#define XTERM_COLOR_CHANGE

/*
 * Width of the term border
 */
#define BORDERWIDTH	1

/*
 * Choose the depth of scrollbars and menus
 * (width of 3d-look shadows and highlights)  --pjh
 */
#define HALFSHADOW

/*
  * Default number of lines in the scrollback buffer
  */
#define SAVELINES	64

/* (Hops) Set to choose a number of lines of context between pages 
 *      (rather than a proportion (1/5) of savedlines buffer) 
 *      when paging the savedlines with SHIFT-{Prior,Next} keys.
 */
#define PAGING_CONTEXT_LINES 1 /* */

/* fonts used */
#ifdef KANJI
# define KFONT0	"k14"
# define KFONT1	"jiskan16"
# define KFONT2	"jiskan18"
# define KFONT3	"jiskan24"
# define KFONT4	"jiskan26"
/* sizes matched to kanji fonts */
# define FONT0	"7x14"
# define FONT1	"8x16"
# define FONT2	"9x18"
# define FONT3	"12x24"
# define FONT4	"13x26"
#else	/* KANJI */
#ifdef BIG5
#define CFONT0 "taipei16"
#define CFONT1 "taipeik20"
#define CFONT2 "taipeik20"
#define CFONT3 "taipeik24"
#define CFONT4 "taipeik24"
#define FONT0  "8x16"
#define FONT1  "10x20"
#define FONT2  "10x20"
#define FONT3  "12x24"
#define FONT4  "12x24"
#else   /* BIG5 */
#define FONT0	"7x14"
#define FONT1	"6x10"
#define FONT2	"6x13"
#define FONT3	"8x13"
#define FONT4	"9x15"
#endif  /* BIG5 */
#endif	/* KANJI */

/* the logical position of font0 in the list */
#define FONT0_IDX 2

#endif
