#
# Set SULOGIN to yes if you want a sulogin to be spawned from
# this script *before anything else* with a timeout, like on SCO.
#
[ "$SULOGIN" = yes ] && sulogin -t 30 $CONSOLE

#
# Activate the swap device(s) in /etc/fstab. This needs to be done
# before fsck, since fsck can be quite memory-hungry.
#
if [ -x /sbin/swapon ]
then
  [ "$VERBOSE" != no ] && echo "Activating swap..."
  swapon -a 2>/dev/null
fi

#
# Ensure that bdflush (update) is running before any major I/O is
# performed (the following fsck is a good example of such activity :).
#
[ -x /sbin/update ] && update

#
# Check the root file system.
#
if [ -f /fastboot ]
then
  echo "Fast boot, no file system check"
else
  #
  # Ensure that root is quiescent and read-only before fsck'ing.
  #
  mount -n -o remount,ro /
  if [ $? = 0 ]
  then
    if [ -f /forcefsck ]
    then
	force="-f"
    else
	force=""
    fi
    if [ "$FSCKFIX" ]
    then
	fix="-y"
    else
	fix="-a"
    fi
    echo "Checking root file system..."
    fsck $force $fix /
    #
    # If there was a failure, drop into single-user mode.
    #
    # NOTE: "failure" is defined as exiting with a return code of
    # 2 or larger.  A return code of 1 indicates that file system
    # errors were corrected but that the boot may proceed.
    #
    if [ $? -gt 1 ]
    then
      # Surprise! Re-directing from a HERE document (as in
      # "cat << EOF") won't work, because the root is read-only.
      echo
      echo "fsck failed.  Please repair manually and reboot.  Please note"
      echo "that the root file system is currently mounted read-only.  To"
      echo "remount it read-write:"
      echo
      echo "   # mount -n -o remount,rw /"
      echo
      echo "CONTROL-D will exit from this shell and REBOOT the system."
      echo
      # Start a single user shell on the console
      /sbin/sulogin $CONSOLE
      reboot -f
    fi
  else
    echo "*** ERROR!  Cannot fsck root fs because it is not mounted read-only!"
    echo
  fi
fi

#
# Remount rootfs rw (default), but do not try to change mtab because it
# is on a ro fs until the remount succeeded.  Then clean up old mtabs and
# finally write the new mtab.
#
mount -n -o remount,rw /
rm -f /etc/mtab~ /etc/nologin
: > /etc/mtab
mount -o remount,rw /
mount /proc

