/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTError;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.net.URL;
import java.util.Hashtable;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.URLImageSource;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MTinyChoicePeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;

public class MToolkit
extends Toolkit
implements Runnable {
    static ColorModel screenmodel;
    static Hashtable imgHash;

    public MToolkit() {
        this.init();
        new Thread(this, "AWT-Motif").start();
    }

    public native void init();

    public native void run();

    public ButtonPeer createButton(Button button) {
        return new MButtonPeer(button);
    }

    public TextFieldPeer createTextField(TextField textField) {
        return new MTextFieldPeer(textField);
    }

    public LabelPeer createLabel(Label label) {
        return new MLabelPeer(label);
    }

    public ListPeer createList(List list) {
        return new MListPeer(list);
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        return new MCheckboxPeer(checkbox);
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        return new MScrollbarPeer(scrollbar);
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        return new MTextAreaPeer(textArea);
    }

    public ChoicePeer createChoice(Choice choice) {
        return new MTinyChoicePeer(choice);
    }

    public FramePeer createFrame(Frame frame) {
        return new MFramePeer(frame);
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        return new MCanvasPeer(canvas);
    }

    public PanelPeer createPanel(Panel panel) {
        return new MPanelPeer(panel);
    }

    public WindowPeer createWindow(Window window) {
        if (window != null && window.getParent() != null && window.getParent().getPeer() == null) {
            window.getParent().addNotify();
        }
        return new MWindowPeer(window);
    }

    public DialogPeer createDialog(Dialog dialog) {
        if (dialog != null && dialog.getParent() != null && dialog.getParent().getPeer() == null) {
            dialog.getParent().addNotify();
        }
        return new MDialogPeer(dialog);
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        throw new AWTError("FileDialog is unimplemented.");
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        return new MMenuBarPeer(menuBar);
    }

    public MenuPeer createMenu(Menu menu) {
        return new MMenuPeer(menu);
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        return new MMenuItemPeer(menuItem);
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        return new MCheckboxMenuItemPeer(checkboxMenuItem);
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = MToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public native int getScreenResolution();

    native int getScreenWidth();

    native int getScreenHeight();

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "Helvetica", "TimesRoman", "Courier", "Symbol"};
        return stringArray;
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public native void sync();

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        System.getSecurityManager().checkURLConnect(uRL);
        Image image = (Image)imgHash.get(uRL);
        if (image == null) {
            try {
                image = toolkit.createImage(new URLImageSource(uRL));
                imgHash.put(uRL, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        System.getSecurityManager().checkRead(string);
        Image image = (Image)imgHash.get(string);
        if (image == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgHash.put(string, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public Image getImage(String string) {
        return MToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return MToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n < 0) {
            n = -1;
        }
        if (n2 < 0) {
            n2 = -1;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep(n, n2);
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        int n3;
        X11Image x11Image = (X11Image)image;
        if (n == 0 || n2 == 0) {
            n3 = 32;
        } else {
            if (n < 0) {
                n = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            n3 = x11Image.getImageRep(n, n2).check(imageObserver);
        }
        return x11Image.check(imageObserver) | n3;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    static {
        SecurityManager.enablePrivilege("UniversalLinkAccess");
        System.loadLibrary("awt");
        imgHash = new Hashtable();
    }
}

