/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MPanelPeer;

class MFramePeer
extends MPanelPeer
implements FramePeer {
    boolean mFrameIsSecure;
    boolean mFrameIsEmbedded;
    boolean mIsWindow;

    MFramePeer(Frame frame) {
        super(frame);
        Image image;
        Color color;
        Font font;
        this.mIsWindow = false;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 9);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.setResizable(frame.isResizable());
        Rectangle rectangle = frame.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    MFramePeer(Window window) {
        super(window);
        Color color;
        this.mIsWindow = true;
        Font font = window.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 9);
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        this.setResizable(false);
        Rectangle rectangle = window.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    native void create(MComponentPeer var1);

    public native void setTitle(String var1);

    public void show() {
        super.show();
        this.pShow();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.pReshape(n, n2, n3, n4);
    }

    public void setIconImage(Image image) {
    }

    public void setMenuBar(MenuBar menuBar) {
    }

    public void setResizable(boolean bl) {
    }

    public void setCursor(Image image) {
    }

    public void dispose() {
        this.pDispose();
    }

    private native void pReshape(int var1, int var2, int var3, int var4);

    private native void pDispose();

    private native void pShow();

    protected void handleFrameReshape(int n, int n2, int n3, int n4) {
        this.target.reshape(n, n2, n3, n4);
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }

    protected void handleWindowClose() {
        this.target.postEvent(new Event(this.target, 201, null));
    }

    protected void handleWindowMoved(int n, int n2) {
        this.target.postEvent(new Event(this.target, 0L, 205, n, n2, 0, 0));
    }

    public native void toFront();

    public native void toBack();

    public native void setCursor(int var1);
}

