/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import netscape.application.AWTCompatibility;
import netscape.application.FoundationApplet;
import netscape.util.Archive;
import netscape.util.ArchivingStack;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.ExternalCoder;

public class Unarchiver
implements Decoder {
    Archive archive;
    ArchivingStack stack = new ArchivingStack();
    Object[] objectForId;
    boolean[] referenceGivenOut;
    int unarchivedCount;
    Object[] unarchivedObjects;
    ExternalCoder[] unarchivedCoders;
    Object currentObject;
    ClassTable currentTable;
    int currentId;
    int currentColumnCount;
    int currentRow;
    int currentColumn;
    FoundationApplet applet;
    boolean appletInitialized;

    public Unarchiver(Archive archive) {
        this.archive = archive;
    }

    public Archive archive() {
        return this.archive;
    }

    public static Object readObject(InputStream inputStream) throws IOException, CodingException {
        Archive archive = new Archive();
        archive.read(inputStream);
        Unarchiver unarchiver = new Unarchiver(archive);
        int[] nArray = archive.rootIdentifiers();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        return unarchiver.unarchiveIdentifier(nArray[0]);
    }

    public Object unarchiveIdentifier(int n) throws CodingException {
        Object object;
        if (n == 0) {
            return null;
        }
        if (this.objectForId == null) {
            this.referenceGivenOut = new boolean[this.archive.identifierCount()];
            this.objectForId = new Object[this.referenceGivenOut.length];
            this.unarchivedObjects = new Object[this.referenceGivenOut.length];
            this.unarchivedCoders = new ExternalCoder[this.referenceGivenOut.length];
        }
        this.clearFinishList();
        try {
            object = this.objectForIdentifier(n);
            this.processFinishList();
        }
        finally {
            Object var4_3 = null;
            this.clearFinishList();
        }
        return object;
    }

    protected Class classForName(String string) throws CodingException {
        Class clazz = null;
        if (!this.appletInitialized) {
            this.applet = (FoundationApplet)AWTCompatibility.awtApplet();
            this.appletInitialized = true;
        }
        try {
            clazz = this.applet != null ? this.applet.classForName(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.creationException(classNotFoundException.toString(), string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.creationException(noSuchMethodError.toString(), string);
        }
        return clazz;
    }

    protected Object newInstance(String string) throws CodingException {
        Object object = null;
        Class clazz = this.classForName(string);
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.creationException(instantiationException.toString(), string);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.creationException(illegalAccessException.toString(), string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.creationException(noSuchMethodError.toString(), string);
        }
        return object;
    }

    private void creationException(String string, String string2) throws CodingException {
        throw new CodingException(String.valueOf(string) + ".  Class " + string2 + " must be public and define a constructor taking no arguments.");
    }

    private Object objectForIdentifier(int n) throws CodingException {
        Object object = this.objectForId[n];
        if (object != null) {
            this.referenceGivenOut[n] = true;
            return object;
        }
        if (n == 0) {
            return null;
        }
        ClassTable classTable = this.archive.classTableForIdentifier(n);
        String string = classTable.className();
        ExternalCoder externalCoder = this.archive.externalCoderForName(string);
        object = externalCoder != null ? externalCoder.newInstance(string) : this.newInstance(string);
        if (!classTable.hasUniqueStrings()) {
            ClassInfo classInfo = new ClassInfo(string);
            if (externalCoder != null) {
                externalCoder.describeClassInfo(object, classInfo);
            } else {
                ((Codable)object).describeClassInfo(classInfo);
            }
            classTable.uniqueStrings(classInfo);
        }
        this.addToFinishList(externalCoder, object);
        this.objectForId[n] = object;
        this.pushUnarchivingState(object, n);
        if (externalCoder != null) {
            externalCoder.decode(object, this);
        } else {
            ((Codable)object).decode(this);
        }
        this.popUnarchivingState();
        return this.objectForId[n];
    }

    private void pushUnarchivingState(Object object, int n) {
        this.stack.pushUnarchiver(this);
        this.currentObject = object;
        this.currentTable = this.archive.classTableForIdentifier(n);
        this.currentId = n;
        this.currentRow = this.archive.rowForIdentifier(n);
        this.currentColumn = -1;
        this.currentColumnCount = this.currentTable.fieldCount;
    }

    private void popUnarchivingState() {
        this.stack.popUnarchiver(this);
    }

    private void addToFinishList(ExternalCoder externalCoder, Object object) {
        this.unarchivedCoders[this.unarchivedCount] = externalCoder;
        this.unarchivedObjects[this.unarchivedCount] = object;
        ++this.unarchivedCount;
    }

    private void processFinishList() throws CodingException {
        int n = this.unarchivedCount;
        int n2 = 0;
        while (n2 < n) {
            ExternalCoder externalCoder = this.unarchivedCoders[n2];
            Object object = this.unarchivedObjects[n2];
            if (externalCoder != null) {
                externalCoder.finishDecoding(object);
            } else {
                ((Codable)object).finishDecoding();
            }
            this.unarchivedCoders[n2] = null;
            this.unarchivedObjects[n2] = null;
            ++n2;
        }
        this.unarchivedCount = 0;
    }

    private void clearFinishList() {
        int n = this.unarchivedCount;
        int n2 = 0;
        while (n2 < n) {
            this.unarchivedCoders[n2] = null;
            this.unarchivedObjects[n2] = null;
            ++n2;
        }
        this.unarchivedCount = 0;
    }

    private void prepareToUnarchiveField(String string) throws CodingException {
        int n = this.currentColumnCount;
        String[] stringArray = this.currentTable.fieldNames;
        int n2 = this.currentColumn + 1;
        while (n2 < n) {
            if (string == stringArray[n2]) {
                this.currentColumn = n2;
                return;
            }
            ++n2;
        }
        this.currentColumn = this.currentTable.columnForField(string);
        if (this.currentColumn < 0) {
            throw new CodingException("Unknown field name: " + string);
        }
    }

    public int versionForClassName(String string) throws CodingException {
        return this.currentTable.versionForClassName(string);
    }

    public boolean decodeBoolean(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.booleanAt(this.currentRow, this.currentColumn);
    }

    public boolean[] decodeBooleanArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.booleanArrayAt(this.currentRow, this.currentColumn);
    }

    public char decodeChar(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.charAt(this.currentRow, this.currentColumn);
    }

    public char[] decodeCharArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.charArrayAt(this.currentRow, this.currentColumn);
    }

    public byte decodeByte(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.byteAt(this.currentRow, this.currentColumn);
    }

    public byte[] decodeByteArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.byteArrayAt(this.currentRow, this.currentColumn);
    }

    public short decodeShort(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.shortAt(this.currentRow, this.currentColumn);
    }

    public short[] decodeShortArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.shortArrayAt(this.currentRow, this.currentColumn);
    }

    public int decodeInt(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.intAt(this.currentRow, this.currentColumn);
    }

    public int[] decodeIntArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.intArrayAt(this.currentRow, this.currentColumn);
    }

    public long decodeLong(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.longAt(this.currentRow, this.currentColumn);
    }

    public long[] decodeLongArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.longArrayAt(this.currentRow, this.currentColumn);
    }

    public float decodeFloat(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.floatAt(this.currentRow, this.currentColumn);
    }

    public float[] decodeFloatArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.floatArrayAt(this.currentRow, this.currentColumn);
    }

    public double decodeDouble(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.doubleAt(this.currentRow, this.currentColumn);
    }

    public double[] decodeDoubleArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.doubleArrayAt(this.currentRow, this.currentColumn);
    }

    public String decodeString(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.stringAt(this.currentRow, this.currentColumn);
    }

    public String[] decodeStringArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.currentTable.stringArrayAt(this.currentRow, this.currentColumn);
    }

    public Object decodeObject(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        return this.objectForIdentifier(this.currentTable.identifierAt(this.currentRow, this.currentColumn));
    }

    public Object[] decodeObjectArray(String string) throws CodingException {
        this.prepareToUnarchiveField(string);
        int[] nArray = this.currentTable.identifierArrayAt(this.currentRow, this.currentColumn);
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.objectForIdentifier(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public void replaceObject(Object object) throws CodingException {
        if (this.referenceGivenOut[this.currentId]) {
            throw new CodingException("Circular replacement exception");
        }
        this.objectForId[this.currentId] = object;
    }
}

