/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;

public abstract class SecurityManager {
    protected boolean inCheck;
    private boolean initialized = false;
    private static SecurityManager security;

    public synchronized boolean getInCheck() {
        return this.inCheck;
    }

    protected SecurityManager() {
        if (security != null) {
            security.checkCreateSecurityManagerAccess(1);
        }
        this.initialized = true;
    }

    protected native Class[] getClassContext();

    protected ClassLoader currentClassLoader() {
        this.checkInitialized();
        return this.currentClassLoader0();
    }

    private native ClassLoader currentClassLoader0();

    protected Class currentLoadedClass() {
        this.checkInitialized();
        return this.currentLoadedClass0();
    }

    protected int classDepth(String string) {
        this.checkInitialized();
        return this.classDepth0(string);
    }

    private native int classDepth0(String var1);

    protected int classLoaderDepth() {
        this.checkInitialized();
        return this.classLoaderDepth0();
    }

    private native int classLoaderDepth0();

    protected boolean inClass(String string) {
        this.checkInitialized();
        return this.classDepth(string) >= 0;
    }

    protected boolean inClassLoader() {
        this.checkInitialized();
        return this.currentClassLoader() != null;
    }

    public Object getSecurityContext() {
        return null;
    }

    public void checkCreateClassLoader() {
        this.checkCreateClassLoader(2);
    }

    protected void checkCreateClassLoader(int n) {
        throw new SecurityException();
    }

    public void checkAccess(Thread thread) {
        this.checkAccess(thread, 2);
    }

    protected void checkAccess(Thread thread, int n) {
        throw new SecurityException();
    }

    public void checkAccess(ThreadGroup threadGroup) {
        this.checkAccess(threadGroup, 2);
    }

    protected void checkAccess(ThreadGroup threadGroup, int n) {
        throw new SecurityException();
    }

    public void checkExit(int n) {
        this.checkExit(n, 2);
    }

    protected void checkExit(int n, int n2) {
        throw new SecurityException();
    }

    public void checkExec(String string) {
        this.checkExec(string, 2);
    }

    protected void checkExec(String string, int n) {
        throw new SecurityException();
    }

    public void checkLink(String string) {
        this.checkLink(string, 2);
    }

    protected void checkLink(String string, int n) {
        throw new SecurityException();
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        this.checkRead(fileDescriptor, 2);
    }

    protected void checkRead(FileDescriptor fileDescriptor, int n) {
        throw new SecurityException();
    }

    public void checkRead(String string) {
        this.checkRead(string, 2);
    }

    protected void checkRead(String string, int n) {
        throw new SecurityException();
    }

    public void checkRead(String string, Object object) {
        this.checkRead(string, object, 2);
    }

    protected void checkRead(String string, Object object, int n) {
        throw new SecurityException();
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        this.checkWrite(fileDescriptor, 2);
    }

    protected void checkWrite(FileDescriptor fileDescriptor, int n) {
        throw new SecurityException();
    }

    public void checkWrite(String string) {
        this.checkWrite(string, 2);
    }

    protected void checkWrite(String string, int n) {
        throw new SecurityException();
    }

    public void checkDelete(String string) {
        this.checkDelete(string, 2);
    }

    protected void checkDelete(String string, int n) {
        throw new SecurityException();
    }

    public void checkConnect(String string, int n) {
        this.checkConnect(string, n, 2);
    }

    protected void checkConnect(String string, int n, int n2) {
        throw new SecurityException();
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n, object, 2);
    }

    protected void checkConnect(String string, String string2, int n) {
        throw new SecurityException();
    }

    protected void checkConnect(String string, int n, Object object, int n2) {
        throw new SecurityException();
    }

    public void checkListen(int n) {
        this.checkListen(n, 2);
    }

    protected void checkListen(int n, int n2) {
        throw new SecurityException();
    }

    public void checkAccept(String string, int n) {
        this.checkAccept(string, n, 2);
    }

    protected void checkAccept(String string, int n, int n2) {
        throw new SecurityException();
    }

    public void checkMulticast(InetAddress inetAddress) {
        this.checkMulticast(inetAddress, 2);
    }

    protected void checkMulticast(InetAddress inetAddress, int n) {
        throw new SecurityException();
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        this.checkMulticast(inetAddress, by, 2);
    }

    protected void checkMulticast(InetAddress inetAddress, byte by, int n) {
        throw new SecurityException();
    }

    public void checkPropertiesAccess() {
        this.checkPropertiesAccess(2);
    }

    protected void checkPropertiesAccess(int n) {
        throw new SecurityException();
    }

    public void checkPropertyAccess(String string) {
        this.checkPropertyAccess(string, 2);
    }

    protected void checkPropertyAccess(String string, int n) {
        throw new SecurityException();
    }

    public boolean checkTopLevelWindow(Object object) {
        return false;
    }

    public void checkPrintJobAccess() {
        this.checkPrintJobAccess(2);
    }

    protected void checkPrintJobAccess(int n) {
        throw new SecurityException();
    }

    public void checkSystemClipboardAccess() {
        this.checkSystemClipboardAccess(2);
    }

    protected void checkSystemClipboardAccess(int n) {
        throw new SecurityException();
    }

    public void checkAwtEventQueueAccess() {
        this.checkAwtEventQueueAccess(2);
    }

    protected void checkAwtEventQueueAccess(int n) {
        throw new SecurityException();
    }

    public void checkPackageAccess(String string) {
        this.checkPackageAccess(string, 2);
    }

    protected void checkPackageAccess(String string, int n) {
        throw new SecurityException();
    }

    public void checkPackageDefinition(String string) {
        this.checkPackageDefinition(string, 2);
    }

    protected void checkPackageDefinition(String string, int n) {
        throw new SecurityException();
    }

    public void checkSetFactory() {
        this.checkSetFactory(2);
    }

    protected void checkSetFactory(int n) {
        throw new SecurityException();
    }

    public void checkMemberAccess(Class clazz, int n) {
        this.checkMemberAccess(clazz, n, 2);
    }

    protected void checkMemberAccess(Class clazz, int n, int n2) {
        throw new SecurityException();
    }

    public void checkSecurityAccess(String string) {
        this.checkSecurityAccess(string, 2);
    }

    protected void checkSecurityAccess(String string, int n) {
        throw new SecurityException();
    }

    protected void checkCreateSecurityManagerAccess(int n) {
        throw new SecurityException();
    }

    public void checkCreateSecurityManagerAccess() {
        this.checkCreateSecurityManagerAccess(2);
    }

    private native Class currentLoadedClass0();

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    protected boolean checkClassLoader(int n) {
        this.checkInitialized();
        return this.checkClassLoader0(n + 1);
    }

    private native boolean checkClassLoader0(int var1);

    public void checkURLConnect(URL uRL) {
        this.checkURLConnect(uRL, 2);
    }

    protected void checkURLConnect(URL uRL, int n) {
        throw new SecurityException();
    }

    public void checkURLConnect(URL uRL, URL uRL2) {
        this.checkURLConnect(uRL, uRL2, 2);
    }

    protected void checkURLConnect(URL uRL, URL uRL2, int n) {
        throw new SecurityException();
    }

    protected void checkAccess(Thread thread, Throwable throwable, int n) {
        throw new SecurityException();
    }

    public void checkAccess(Thread thread, Throwable throwable) {
        this.checkAccess(thread, throwable, 2);
    }

    public void checkResourceAccess(String string) {
        this.checkResourceAccess(string, 2);
    }

    protected void checkResourceAccess(String string, int n) {
        throw new SecurityException();
    }

    public boolean checkMatchPrincipalAlways(int n) {
        throw new SecurityException();
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("Attempted us of uninitialized security manager");
        }
    }

    public static void setSecurityManager() {
        if (security != null) {
            throw new SecurityException("SecurityManager already set");
        }
        security = System.getSecurityManager();
    }

    public static boolean checksMatchPrincipalAlways(int n) {
        if (security != null && !(security instanceof NullSecurityManager)) {
            return security.checkMatchPrincipalAlways(n + 1);
        }
        return true;
    }

    protected boolean securityCheckScopePermission(int n) {
        throw new SecurityException();
    }

    public static boolean checkScopePermission(int n) {
        if (security != null && !(security instanceof NullSecurityManager)) {
            return security.securityCheckScopePermission(n + 1);
        }
        return true;
    }

    public static void enablePrivilege(String string) {
        SecurityManager.enablePrivilege(string, 1);
    }

    private static void enablePrivilege(String string, int n) {
        if (security != null && !(security instanceof NullSecurityManager)) {
            Object object = security.securitySetScopePermission(n + 1, string);
            SecurityManager.setScopePermissionInternal(object, n + 1);
        }
    }

    public static boolean isPrivilegeEnabled(String string) {
        if (security != null && !(security instanceof NullSecurityManager)) {
            return security.isPrivilegeEnabled(string, 1);
        }
        return true;
    }

    protected boolean isPrivilegeEnabled(String string, int n) {
        throw new SecurityException();
    }

    public static void revertPrivilege() {
        if (security != null && !(security instanceof NullSecurityManager)) {
            SecurityManager.setScopePermissionInternal(null, 1);
        }
    }

    protected Object securitySetScopePermission(int n) {
        throw new SecurityException();
    }

    protected Object securitySetScopePermission(int n, String string) {
        throw new SecurityException();
    }

    private static native void setScopePermissionInternal(Object var0, int var1);

    public static void setScopePermission() {
        SecurityManager.enablePrivilege("30Capabilities", 1);
    }

    public static void resetScopePermission() {
        if (security != null && !(security instanceof NullSecurityManager)) {
            SecurityManager.setScopePermissionInternal(null, 1);
        }
    }
}

