/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

class ProcessInputStream
extends PipedInputStream
implements Runnable {
    InputStream ins;
    OutputStream outs;
    UNIXProcess p;
    byte[] writeBuf;
    boolean chaining;
    int inPos;
    Vector chain;

    ProcessInputStream(UNIXProcess uNIXProcess, PipedOutputStream pipedOutputStream, InputStream inputStream) throws IOException {
        super(pipedOutputStream);
        this.p = uNIXProcess;
        this.outs = pipedOutputStream;
        this.ins = inputStream;
        this.writeBuf = null;
        this.chaining = false;
        this.inPos = 0;
        this.chain = new Vector();
    }

    protected synchronized void receive(int n) throws IOException {
        if (this.chaining) {
            if (this.inPos == 1024) {
                this.writeBuf = new byte[1024];
                this.chain.addElement(this.writeBuf);
                this.inPos = 0;
            }
            this.writeBuf[this.inPos++] = (byte)n;
            return;
        }
        super.receive(n);
        if (this.in == this.out) {
            this.inPos = 0;
            this.chaining = true;
            this.writeBuf = new byte[1024];
            this.chain.addElement(this.writeBuf);
        }
    }

    public synchronized int read() throws IOException {
        if (!this.chaining) {
            return super.read();
        }
        if (this.in == -1 && this.chain.size() != 0) {
            this.buffer = (byte[])this.chain.elementAt(0);
            this.chain.removeElementAt(0);
            this.out = 0;
            this.in = 0;
            if (this.chain.size() == 0) {
                this.in = this.inPos == 0 ? -1 : (this.inPos == 1024 ? 0 : this.inPos);
                this.chaining = false;
            }
        }
        return super.read();
    }

    public int available() throws IOException {
        return super.available() + 1024 * this.chain.size();
    }

    public void run() {
        byte[] byArray = new byte[512];
        try {
            int n;
            while ((n = this.ins.read(byArray)) >= 0) {
                this.outs.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {}
        try {
            this.outs.close();
        }
        catch (IOException iOException) {}
        this.p.decrNumReaders();
    }
}

