/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.peer.WindowPeer;
import java.io.Serializable;

public class Window
extends Container
implements Serializable {
    String warningString;

    Window() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning", "Warning: Applet Window");
        }
    }

    public Window(Frame frame) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning", "Warning: Applet Window");
        }
        this.parent = frame;
        this.visible = false;
        this.setLayout(new BorderLayout());
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public synchronized void pack() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.resize(this.preferredSize());
        this.validate();
    }

    public synchronized void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.visible) {
            this.toFront();
            return;
        }
        super.show();
    }

    public synchronized void dispose() {
        this.hide();
        this.removeNotify();
    }

    public void toFront() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toFront();
        }
    }

    public void toBack() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toBack();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }
}

