/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.io.Serializable;

public class Rectangle
implements Shape,
Serializable {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(int n, int n2) {
        this(0, 0, n, n2);
    }

    public Rectangle(Point point, Dimension dimension) {
        this(point.x, point.y, dimension.width, dimension.height);
    }

    public Rectangle(Point point) {
        this(point.x, point.y, 0, 0);
    }

    public Rectangle(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        return n >= this.x && n - this.x < this.width && n2 >= this.y && n2 - this.y < this.height;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.x + rectangle.width > this.x && rectangle.y + rectangle.height > this.y && rectangle.x < this.x + this.width && rectangle.y < this.y + this.height;
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n = Math.max(this.x, rectangle.x);
        int n2 = Math.min(this.x + this.width, rectangle.x + rectangle.width);
        int n3 = Math.max(this.y, rectangle.y);
        int n4 = Math.min(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public Rectangle union(Rectangle rectangle) {
        int n = Math.min(this.x, rectangle.x);
        int n2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public void add(int n, int n2) {
        int n3 = Math.min(this.x, n);
        int n4 = Math.max(this.x + this.width, n);
        int n5 = Math.min(this.y, n2);
        int n6 = Math.max(this.y + this.height, n2);
        this.x = n3;
        this.y = n5;
        this.width = n4 - n3;
        this.height = n6 - n5;
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(Rectangle rectangle) {
        int n = Math.min(this.x, rectangle.x);
        int n2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
    }

    public void grow(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += n * 2;
        this.height += n2 * 2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int hashCode() {
        return this.x ^ this.y * 37 ^ this.width * 43 ^ this.height * 47;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

