/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDIF {
    public static final String SEPARATOR = ":";
    public static final String COMMENT = "#";
    private int m_version = 1;
    private boolean m_done = false;
    private BufferedReader m_reader;
    private String m_source;

    public LDIF() throws IOException {
        BufferedReader bufferedReader;
        DataInputStream dataInputStream = new DataInputStream(System.in);
        this.m_reader = bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        this.m_source = "System.in";
    }

    public LDIF(String string) throws IOException {
        BufferedReader bufferedReader;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        this.m_reader = bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        this.m_source = string;
    }

    public LDIF(DataInputStream dataInputStream) throws IOException {
        BufferedReader bufferedReader;
        this.m_reader = bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        this.m_source = dataInputStream.toString();
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = null;
        do {
            if ((string = bufferedReader.readLine()) == null) continue;
            string.trim();
        } while (string != null && string.startsWith(COMMENT));
        if (string == null) {
            this.m_done = true;
        }
        return string;
    }

    public LDIFRecord nextRecord() throws IOException {
        if (this.m_done) {
            return null;
        }
        return this.parse_ldif_record(this.m_reader);
    }

    private LDIFRecord parse_ldif_record(BufferedReader bufferedReader) throws IOException {
        String string = null;
        String string2 = null;
        new Vector();
        LDIFRecord lDIFRecord = null;
        string = this.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (!string.startsWith("dn:")) {
            throw new IOException("no dn found");
        }
        string2 = string.substring(3).trim();
        LDIFContent lDIFContent = this.parse_ldif_content(bufferedReader);
        lDIFRecord = new LDIFRecord(string2, lDIFContent);
        return lDIFRecord;
    }

    private LDIFContent parse_ldif_content(BufferedReader bufferedReader) throws IOException {
        Object object;
        String string = null;
        string = this.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (string.startsWith("changetype:")) {
            String string2 = string.substring(11).trim();
            if (string2.equals("modify")) {
                LDIFModifyContent lDIFModifyContent = this.parse_mod_spec(bufferedReader);
                return lDIFModifyContent;
            }
            if (string2.equals("add")) {
                LDIFAddContent lDIFAddContent = this.parse_add_spec(bufferedReader);
                return lDIFAddContent;
            }
            if (string2.equals("delete")) {
                LDIFDeleteContent lDIFDeleteContent = this.parse_delete_spec(bufferedReader);
                return lDIFDeleteContent;
            }
            throw new IOException("change type not supported");
        }
        LDIFAttributeContent lDIFAttributeContent = new LDIFAttributeContent();
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        do {
            int n;
            if ((n = string.indexOf(58)) == -1) {
                throw new IOException("no ':' found in entry");
            }
            String string4 = string.substring(0, n);
            if (string3 == null || string4.equals(string3)) {
                vector.addElement(string.substring(n + 1).trim());
            } else {
                object = new String[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    object[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
                LDAPAttribute lDAPAttribute = new LDAPAttribute(string3, (String[])object);
                vector.removeAllElements();
                lDIFAttributeContent.addElement(lDAPAttribute);
                vector.addElement(string.substring(n + 1).trim());
            }
            string3 = string4;
        } while ((string = this.readLine(bufferedReader)) != null && !string.equals("") && !string.equals("-"));
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            object = new LDAPAttribute(string3, stringArray);
            lDIFAttributeContent.addElement((LDAPAttribute)object);
        }
        return lDIFAttributeContent;
    }

    private LDIFAddContent parse_add_spec(BufferedReader bufferedReader) throws IOException {
        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(bufferedReader);
        LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
        LDIFAddContent lDIFAddContent = new LDIFAddContent(lDAPAttributeArray);
        return lDIFAddContent;
    }

    private LDIFDeleteContent parse_delete_spec(BufferedReader bufferedReader) throws IOException {
        String string = this.readLine(bufferedReader);
        if (string == null || string.equals("")) {
            LDIFDeleteContent lDIFDeleteContent = new LDIFDeleteContent();
            return lDIFDeleteContent;
        }
        throw new IOException("invalid SEP");
    }

    private LDIFModifyContent parse_mod_spec(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = this.readLine(bufferedReader);
        LDIFModifyContent lDIFModifyContent = new LDIFModifyContent();
        do {
            int n = -1;
            if (string.startsWith("add:")) {
                n = 0;
            } else if (string.startsWith("delete:")) {
                n = 1;
            } else if (string.startsWith("replace:")) {
                n = 2;
            } else {
                throw new IOException("unknown modify type");
            }
            LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(bufferedReader);
            LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
            int n2 = 0;
            while (n2 < lDAPAttributeArray.length) {
                lDIFModifyContent.addElement(new LDAPModification(n, lDAPAttributeArray[n2]));
                ++n2;
            }
        } while ((string = this.readLine(bufferedReader)) != null && !string.equals(""));
        return lDIFModifyContent;
    }

    public int getVersion() {
        return this.m_version;
    }

    public String toString() {
        return "LDIF {}";
    }
}

