/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import java.applet.Applet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.PrivilegeManager;

public class OrbProperties
extends Properties {
    public static final int DEFAULT_ORB = 0;
    public static final int DEFAULT_ORB_SINGLETON = 1;
    public static final int OSAGENT_ADDR = 2;
    public static final int OSAGENT_PORT = 3;
    public static final int OBJECT_ADAPTER_PORT = 4;
    private static String[] default_keys;
    private static String[] default_values;
    private static Properties global_defaults;

    private static final String getRestrictedProperty(String string) {
        return OrbProperties.getRestrictedProperty(string, null);
    }

    private static final String getRestrictedProperty(String string, String string2) {
        String string3;
        try {
            string3 = System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            string3 = string2;
        }
        return string3;
    }

    public static final String getDefault(int n) {
        try {
            return global_defaults.getProperty(default_keys[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static final String getDefaultKey(int n) {
        try {
            return default_keys[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "invalid.default_index";
        }
    }

    public OrbProperties() {
        super(global_defaults);
        this.initWebBrowserDefaults();
    }

    public OrbProperties(Properties properties) {
        this.initWebBrowserDefaults();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)this).put(string, properties.getProperty(string));
        }
        if (this.getBoolean("USE_ORB_LOCATOR") && this.getBoolean("DISABLE_ORB_LOCATOR")) {
            ((Hashtable)this).remove("DISABLE_ORB_LOCATOR");
        }
    }

    public OrbProperties(Applet applet) {
        String string;
        this.initWebBrowserDefaults();
        int n = 0;
        while (n < default_keys.length) {
            string = applet.getParameter(default_keys[n]);
            if (string != null) {
                ((Hashtable)global_defaults).put(default_keys[n], string);
            }
            ++n;
        }
        string = applet.getParameter("USE_ORB_LOCATOR");
        if (string != null) {
            ((Hashtable)this).remove("DISABLE_ORB_LOCATOR");
            if (!this.getBoolean("GATEKEEPER_ADDR")) {
                ((Hashtable)this).put("GATEKEEPER_ADDR", applet.getCodeBase().getHost());
            }
            if (!this.getBoolean("GATEKEEPER_ADDR")) {
                ((Hashtable)this).put("GATEKEEPER_PORT", "15000");
            }
        }
    }

    private void initWebBrowserDefaults() {
        String string = System.getProperty("browser.vendor");
        if (string != null && string.indexOf("Netscape") != -1) {
            ((Hashtable)this).put("DISABLE_ORB_LOCATOR", "true");
        }
    }

    public String getProperty(int n) {
        return this.getProperty(OrbProperties.getDefaultKey(n));
    }

    public boolean getBoolean(String string) {
        return this.getProperty(string) != null;
    }

    public boolean getBoolean(int n) {
        return this.getBoolean(OrbProperties.getDefaultKey(n));
    }

    public String getString(String string) {
        return this.getProperty(string);
    }

    public String getString(int n) {
        return this.getString(OrbProperties.getDefaultKey(n));
    }

    public int getInt(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getInt(int n) {
        return this.getInt(OrbProperties.getDefaultKey(n));
    }

    static {
        String string;
        default_keys = null;
        default_values = null;
        default_keys = new String[5];
        default_values = new String[5];
        OrbProperties.default_keys[0] = "org.omg.CORBA.ORBClass";
        OrbProperties.default_values[0] = "com.visigenic.vbroker.CORBA.ORB";
        OrbProperties.default_keys[1] = "org.omg.CORBA.ORBSingletonClass";
        OrbProperties.default_values[1] = default_values[0];
        OrbProperties.default_keys[2] = "OSAGENT_ADDR";
        OrbProperties.default_values[2] = "localhost";
        OrbProperties.default_keys[3] = "OSAGENT_PORT";
        OrbProperties.default_values[3] = "14000";
        OrbProperties.default_keys[4] = "OAport";
        OrbProperties.default_values[4] = "0";
        global_defaults = new Properties();
        String string2 = System.getProperty("browser.vendor");
        if (string2 != null && string2.indexOf("Netscape") != -1) {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        int n = 0;
        while (n < default_keys.length) {
            string = OrbProperties.getRestrictedProperty(default_keys[n], default_values[n]);
            if (string != null) {
                ((Hashtable)global_defaults).put(default_keys[n], string);
            }
            ++n;
        }
        string = OrbProperties.getRestrictedProperty("DISABLE_ORB_LOCATOR");
        if (string != null) {
            ((Hashtable)global_defaults).put("DISABLE_ORB_LOCATOR", "true");
        }
        if ((string = OrbProperties.getRestrictedProperty("OAipaddr")) != null) {
            ((Hashtable)global_defaults).put("OBJECT_ADAPTER_ADDRESS", string);
        }
        if (string2 != null && string2.indexOf("Netscape") != -1) {
            PrivilegeManager.revertPrivilege((String)"UniversalPropertyRead");
        }
    }
}

