/*
 * @(#)context.h	1.10 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/*
 * Generic include for Green contexts
 */

#ifndef _GREEN_CONTEXT_H_
#define _GREEN_CONTEXT_H_

#include "context_md.h"

#define CONTEXT(tid)    (&((tid)->mdcontext))

typedef struct  {
        stackp_t        base;
        uint_t          size;
} gstack_t;

void initContext(sys_thread_t *tid, unsigned long pc,
		 void (*death_func)(), unsigned long arg);
int allocateContextAndStack(sys_thread_t **tid, long stacksize);
void deleteContextAndStack(sys_thread_t *tid);
void cleanupPendingAlarm(sys_thread_t *tid);

#endif /* !_GREEN_CONTEXT_H_ */
