/* @(#)src/bindlib.h	1.4 7/11/92 11:47:58 */

/*
 *    Copyright (C) 1992  Ronald S. Karr
 *
 * BIND support common to the "bind" router and the "tcpsmtp" transport.
 * Created by Simon Leinen (simon@liasun6) on 9 July 1991.
 *
 * Converted to library form usable by tcpsmtp by Chip Salzenberg.
 */

#ifndef BINDLIB_H
#define BINDLIB_H

/* configuration items shared by bind router and tcpip transport */

/* flag attributes */
#define BIND_LOCAL_MX_OKAY   0x01000000	/* MX RR can point to local host */
#define BIND_DEFER_NO_CONN   0x02000000	/* defer if cannot connect to server */
#define BIND_DEFNAMES        0x04000000	/* append default domain name */
#define BIND_DOMAIN_REQUIRED 0x08000000	/* require two hostname parts */
#define BIND_MX_ONLY         0x10000000	/* require MX records */
#define BIND_UK_TRY_INVERT   0x20000000 /* try inverting UK address */
#define BIND_UK_GREY_WORLD   0x40000000 /* UK GreyBook addrs in world order */

struct bindlib_private {
    char *ignore_domains;		/* domains to ignore */
    char *widen_domains;		/* domains to try widening with */
    char *gateways;			/* known gateways and their domains */
    char *uk_ignore_gateways;		/* UK: gateways to ignore */
    char *uk_greybook_transport;	/* UK: null string => SMTP only */
    int  uk_max_precedence;		/* UK: max MX precedence to accept */
};

/* configuration description */
#define BIND_ATTRIBUTES(STRUCT,BL_PRIV_MEM) \
    { "local_mx_okay", t_boolean, NULL, NULL, BIND_LOCAL_MX_OKAY },	\
    { "defer_no_connect", t_boolean, NULL, NULL, BIND_DEFER_NO_CONN },	\
    { "defnames", t_boolean, NULL, NULL, BIND_DEFNAMES },		\
    { "domain_required", t_boolean, NULL, NULL, BIND_DOMAIN_REQUIRED },	\
    { "mx_only", t_boolean, NULL, NULL, BIND_MX_ONLY },			\
    { "uk_try_inverting", t_boolean, NULL, NULL, BIND_UK_TRY_INVERT },	\
    { "uk_greybook_worldorder", t_boolean, NULL, NULL, BIND_UK_GREY_WORLD }, \
    { "ignore_domains", t_string, NULL, NULL,				\
	  OFFSET(STRUCT, BL_PRIV_MEM.ignore_domains) },			\
    { "widen_domains", t_string, NULL, NULL,				\
          OFFSET(STRUCT, BL_PRIV_MEM.widen_domains) },			\
    { "gateways", t_string, NULL, NULL,					\
          OFFSET(STRUCT, BL_PRIV_MEM.gateways) },			\
    { "uk_ignore_gateways", t_string, NULL, NULL,			\
          OFFSET(STRUCT, BL_PRIV_MEM.uk_ignore_gateways) },		\
    { "uk_greybook_transport", t_string, NULL, NULL, 			\
          OFFSET(STRUCT, BL_PRIV_MEM.uk_greybook_transport) },		\
    { "uk_max_precedence", t_int, NULL, NULL,				\
	  OFFSET(STRUCT, BL_PRIV_MEM.uk_max_precedence) }

#define BIND_TEMPLATE_FLAGS 0

#define BIND_TEMPLATE_ATTRIBUTES \
   { NULL, NULL, NULL, NULL, NULL, 0 }

#endif /* not BINDLIB_H */
