#ifndef lint
static const char sccsid[] = "@(#)trig.c     3.11 96/09/20 xlockmore";

#endif

/*-
 * trig.c - trigonometric patterns for xlock
 *
 * Written by Dan Stromberg, Wed Feb 12, 1997
 *
 * See xlock.c for copying information.
 *
 */

#include <math.h>

#include "xlock.h"

ModeSpecOpt trig_opts =
{0, NULL, 0, NULL, NULL};

typedef struct {
	double      theta;
	int         mult1, mult2;
	double      offset;
	int         color;
	int         density;
} trigstruct;

static trigstruct *trigs = NULL;

#define pi 3.14159265359

void
init_trig(ModeInfo * mi)
{
	trigstruct *trigp;

	if (trigs == NULL) {
		if ((trigs = (trigstruct *) calloc(MI_NUM_SCREENS(mi),
					       sizeof (trigstruct))) == NULL)
			return;
	}
	trigp = &trigs[MI_SCREEN(mi)];

	trigp->theta = 0;
	if (NRAND(2) == 0) {
		trigp->mult1 = NRAND(2) + 1;
		trigp->mult2 = NRAND(8) + 1;
	} else {
		trigp->mult1 = NRAND(8) + 1;
		trigp->mult2 = NRAND(2) + 1;
	}
	/* trigp->mult1 = 1; */
	/* trigp->mult2 = 1; */
	trigp->offset = (NRAND(89) + 1) * (pi / (90 * 8));
	trigp->color = 1;
	trigp->density = 1 << (NRAND(4) + 4);
	XClearWindow(MI_DISPLAY(mi), MI_WINDOW(mi));
}

void
draw_trig(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);
	trigstruct *trigp = &trigs[MI_SCREEN(mi)];
	int         x1, y1, x2, y2;
	static int  count = 0;

	if (trigp->theta >= 2 * pi) {
		count = count + 1;
		if (count > 200) {
			count = 0;
			init_trig(mi);
		}
		return;
	}
	if (MI_NPIXELS(mi) == 2) {
		trigp->color = MI_WIN_WHITE_PIXEL(mi);
		XSetForeground(display, gc, trigp->color);
	} else {
		trigp->color++;
		if (trigp->color >= MI_NPIXELS(mi))
			trigp->color = 1;
		XSetForeground(display, gc, MI_PIXEL(mi, trigp->color));
	}

	x1 = sin(trigp->theta * trigp->mult1) * MI_WIN_WIDTH(mi) / 2 +
		MI_WIN_WIDTH(mi) / 2;
	y1 = cos(trigp->theta * trigp->mult1) * MI_WIN_HEIGHT(mi) / 2 +
		MI_WIN_HEIGHT(mi) / 2;
	x2 = sin(trigp->theta * trigp->mult2 + trigp->offset) * MI_WIN_WIDTH(mi) / 2 +
		MI_WIN_WIDTH(mi) / 2;
	y2 = cos(trigp->theta * trigp->mult2 + trigp->offset) * MI_WIN_HEIGHT(mi) / 2 +
		MI_WIN_HEIGHT(mi) / 2;
	XDrawLine(display, MI_WINDOW(mi), gc, x1, y1, x2, y2);
	trigp->theta += pi / (trigp->density * trigp->mult1 * trigp->mult2);
}

void
release_trig(ModeInfo * mi)
{
	if (trigs != NULL) {
		(void) free((void *) trigs);
		trigs = NULL;
	}
}
