#ifndef lint
static char sccsid[] = "@(#)star.c	3.11h 96/09/30 xlockmore";
 
#endif
 
/*-
 * star.c - star for xlock, the X Window System lockscreen.
 *
 * Copyright (c) 1995 by Heath Rice <rice@asl.dl.nec.com>.
 *
 * See xlock.c for copying information.
 *
 */

/*-
 * Looks a lot like the rock mode
 * The big difference is that every once-in-awhile,
 * the Enterprise flys by from a few different views.
 * I also have one view of a Romulan ship.  I suppose
 * the ships could be put into the rock mode if anyone
 * is interested.
 */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include "xlock.h"
#include "bitmaps/ent1.xbm"
#include "bitmaps/ent2.xbm"
#include "bitmaps/rom1.xbm"

#define START_SPEED 1.0
#define GROW_SPEED  0.05
#define MAX_SIZE    10.0

ModeSpecOpt star_opts =
{0, NULL, 0, NULL, NULL};

static int  excount = 1;

struct starstruct {
	double      x;
	double      y;
	double      dx;
	double      dy;
	int         speed;	/* not used */
	int         color;	/* not used */
	int         starnum;
	double      size;
	struct starstruct *next;
};

struct scrstruct {
	struct starstruct *stars;
	int         width, height;
	double      centerx, centery;
	int         maxsize;
	XArc       *stararcs;
};

static struct scrstruct si[MAXSCREENS];

static int  EntVis = 0;
static int  ent_x, ent_y;
static int  ent_dx, ent_dy;
static int  ent_width, ent_height;
static int  odds;

static Pixmap *ent_pixmap;
static Pixmap ent1_pixmap;
static Pixmap ent2_pixmap;
static Pixmap rom1_pixmap;

static void
makestar(struct scrstruct *sp, struct starstruct *star)
{
	double      mag = 0.0;

	while (mag == 0.0) {	/* make sure random position is not exact center */
		star->x = (double) NRAND(sp->width);
		star->y = (double) NRAND(sp->height);
		star->size = 1;
		star->color = NRAND(256);
		mag = (star->y - sp->centery) * (star->y - sp->centery)
			+ (star->x - sp->centerx) * (star->x - sp->centerx);
		mag = sqrt(mag);
	}
	star->dx = (star->x - sp->centerx) / mag * START_SPEED;
	star->dy = (star->y - sp->centery) / mag * START_SPEED;
	star->speed = (int) START_SPEED;
	sp->stararcs[star->starnum].x = (short) star->x;
	sp->stararcs[star->starnum].y = (short) star->y;
	sp->stararcs[star->starnum].width = (int) star->size;
	sp->stararcs[star->starnum].height = (int) star->size;
	sp->stararcs[star->starnum].angle1 = 0;
	sp->stararcs[star->starnum].angle2 = 64 * 360;
}

static void
checkBounds(struct scrstruct *sp, struct starstruct *astar)
{
	if ((astar->x <= 0) || (astar->x > sp->width) ||
	    (astar->y <= 0) || (astar->y > sp->height))
		makestar(sp, astar);
}

void
init_star(ModeInfo * mi)
{
	struct scrstruct *sp = &si[MI_SCREEN(mi)];
	struct starstruct *astar;
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	int         dp = DisplayPlanes(display, MI_SCREEN(mi));
	int         i;

	odds = excount;

	/* Get window info */
	sp->width = MI_WIN_WIDTH(mi);
	sp->height = MI_WIN_HEIGHT(mi);
	sp->centerx = (double) sp->width / 2;
	sp->centery = (double) sp->height / 2;
	sp->maxsize = (int) MAX_SIZE;
	if (sp->width < 100) {	/* icon window */
		sp->maxsize = (int) MAX_SIZE;
	}
	/* Make link list of stars */
	if (sp->stars == NULL) {
		ent1_pixmap = XCreatePixmapFromBitmapData(display, window,
				 (char *) ent1_bits, ent1_width, ent1_height,
			 MI_WIN_WHITE_PIXEL(mi), MI_WIN_BLACK_PIXEL(mi), dp);

		ent2_pixmap = XCreatePixmapFromBitmapData(display, window,
				 (char *) ent2_bits, ent2_width, ent2_height,
			 MI_WIN_WHITE_PIXEL(mi), MI_WIN_BLACK_PIXEL(mi), dp);

		rom1_pixmap = XCreatePixmapFromBitmapData(display, window,
				 (char *) rom1_bits, rom1_width, rom1_height,
			 MI_WIN_WHITE_PIXEL(mi), MI_WIN_BLACK_PIXEL(mi), dp);

		sp->stararcs = (XArc *) malloc(MI_BATCHCOUNT(mi) * sizeof (XArc));
		sp->stars = (struct starstruct *) malloc(sizeof (struct starstruct));

		sp->stars->next = NULL;
		sp->stars->starnum = 0;
		for (i = 0; i < MI_BATCHCOUNT(mi) - 1; i++) {
			astar = (struct starstruct *) malloc(sizeof (struct starstruct));

			astar->next = sp->stars;
			astar->starnum = i + 1;
			sp->stars = astar;
		}
	}
	/* Fill in star list with values */
	astar = sp->stars;
	while (astar != NULL) {
		makestar(sp, astar);
		astar = astar->next;
	}

	/* Clear the screen */
	XClearWindow(MI_DISPLAY(mi), MI_WINDOW(mi));
}

void
draw_star(ModeInfo * mi)
{
	struct scrstruct *sp = &si[MI_SCREEN(mi)];
	struct starstruct *astar;
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	GC          gc = MI_GC(mi);

	/* Erase old star positions */
	XSetForeground(display, gc, MI_WIN_BLACK_PIXEL(mi));
	if (!EntVis)
		XFillArcs(display, window, gc, sp->stararcs, MI_BATCHCOUNT(mi));
	else
		XFillArcs(display, window, gc, sp->stararcs,
			  (MI_BATCHCOUNT(mi) > 30) ? 30 : MI_BATCHCOUNT(mi));

	if ((!EntVis) && (sp->width > 100)) {
		if (odds != 0) {
			if (NRAND(odds) == 0) {
				EntVis = NRAND(5);
				switch (EntVis) {
					case 1:
						ent_pixmap = &ent1_pixmap;
						ent_x = NRAND(sp->width);
						ent_y = -ent1_height;
						ent_dx = NRAND(3) + 1;
						ent_dy = NRAND(3) + 1;
						ent_width = ent1_width;
						ent_height = ent1_height;
						break;

					case 2:
						ent_pixmap = &ent2_pixmap;
						ent_x = sp->width;
						ent_y = NRAND(sp->height);
						ent_dx = -1 * (NRAND(3) + 1);
						ent_dy = NRAND(9) - 5;
						ent_width = ent2_width;
						ent_height = ent2_height;
						break;

					case 3:
						ent_pixmap = &rom1_pixmap;
						ent_x = sp->width;
						ent_y = NRAND(sp->height);
						ent_dx = -1 * (NRAND(3) + 1);
						ent_dy = NRAND(9) - 5;
						ent_width = rom1_width;
						ent_height = rom1_height;
						break;

					default:
						EntVis = 0;
						break;
				}
			}
		}
	}
	if (EntVis) {
		ent_x += ent_dx;
		ent_y += ent_dy;

		if ((ent_x < -ent_width + 4) || (ent_y < -ent_height - 4) ||
		 (ent_y > sp->height) || (ent_x > sp->width + ent_width + 8))
			EntVis = 0;

		XCopyArea(display, *ent_pixmap, window, gc, 0, 0,
			  ent_width + 8, ent_height + 8, ent_x, ent_y);
	}
	/* Update star positions */
	astar = sp->stars;
	while (astar != NULL) {
		checkBounds(sp, astar);
		if (astar->size < sp->maxsize) {
			astar->size += 3 * GROW_SPEED;
			astar->dx += GROW_SPEED * astar->dx;
			astar->dy += GROW_SPEED * astar->dy;
		}
		astar->x += astar->dx;
		astar->y += astar->dy;

		sp->stararcs[astar->starnum].x = (short) astar->x;
		sp->stararcs[astar->starnum].y = (short) astar->y;
		sp->stararcs[astar->starnum].width = (short unsigned) astar->size;
		sp->stararcs[astar->starnum].height = (short unsigned) astar->size;

		astar = astar->next;
	}

	/* Draw new star positions */
	XSetForeground(display, gc, MI_WIN_WHITE_PIXEL(mi));
	if (!EntVis)
		XFillArcs(display, window, gc, sp->stararcs, MI_BATCHCOUNT(mi));
	else
		XFillArcs(display, window, gc, sp->stararcs,
			  (MI_BATCHCOUNT(mi) > 30) ? 30 : MI_BATCHCOUNT(mi));
}

void
release_star(ModeInfo * mi)
{
}

