.TH NFSD 8 "13 October 1993"
.SH NAME
nfsd \- NFS service daemon
.SH SYNOPSIS
.B /usr/sbin/rpc.nfsd
.B "[\ \-f\ exports-file\ ]"
.B "[\ \-d\ facility\ ]"
.B "[\ \-P\ port\ ]"
.B "[\ \-Fhnprstv\ ]"
.B "[\ \-\-debug\ facility\ ]"
.B "[\ \-\-exports\-file=file\ ]"
.B "[\ \-\-foreground\ ]"
.B "[\ \-\-help\ ]"
.B "[\ \-\-allow\-non\-root\ ]"
.B "[\ \-\-re\-export\ ]"
.\".B "[\ \-\-synchronous\-writes\ ]"
.\".B "[\ \-\-no\-spoof\-trace\ ]"
.B "[\ \-\-port\ port\ ]"
.B "[\ \-\-version\ ]"
.B "[ numservers ]"
.SH DESCRIPTION
The
.I nfsd
program is an NFS service daemon that handles client filesystem requests.
Unlike on some other systems,
.I nfsd
operates as a normal user-level process.
The server also differs from other NFS server implementations
in that it mounts an entire file hierarchy
not limited by the boundaries of physical file-systems.
The implementation allows the clients read-only or
read-write access to the file hierarchy of the server machine.
.LP
The
.I mountd
program starts an ancillary user-level mount daemon.
.LP
.SS Running from inetd
Usually,
.I nfsd
will be started at system boot time. However, you may also invoke it from
.I inetd
by adding the following two lines to
.IR /etc/inetd.conf :
.PP
.nf
.ta +3i
nfs/2 dgram  rpc/udp wait root /usr/sbin/rpc.nfsd rpc.nfsd
nfs/2 stream rpc/tcp wait root /usr/sbin/rpc.nfsd rpc.nfsd
.fi
.PP
When run from
.IR inetd ,
.i nfsd
will terminate after a certain period of inactivity.
.SH OPTIONS
.TP
.BR \-f " or " \-\-exports\-file
This option specifies the exports file, listing the clients that this server
is prepared to serve and parameters to apply to each such mount (see
exports(5)).
By default exports are read from
.IR /etc/exports .
.TP
.BR "\-d facility" " or " "\-\-debug facility"
Log operations verbosely. Legal values for
.I facility
are currently
.I call
for the logging of RPC calls and arguments, 
.I fhcache
for the file handle cache operation,
.I auth
for the authentication routines, and
.I ugid
for the uid mapping code, if used. Debug messages will be logged to
.IR syslog (8)
unless the daemon runs in the foreground.
.TP
.BR \-F " or " \-\-foreground
Unlike in normal operation,
.I nfsd
will not detach from the terminal when given this option. When debugging
is requested, it will be sent to standard error.
.TP
.BR \-h " or " \-\-help
Provide a short help summary.
.TP
.BR \-n " or " \-\-allow\-non\-root
Allow incoming NFS requests to be honored even if they do not
originate from reserved IP ports.  Some older NFS client implementations
require this.  Some newer NFS client implementations don't believe
in reserved port checking. This check can be turned off for individual hosts
by specifying the
.I insecure
export option in
.IR /etc/exports .
.TP
.BR "\-P portnum" " or " "\-\-port portnum"
Makes 
.I nfsd 
listen on port
.B portnum
instead of the default port 2049. By default,
.I nfsd
will listen on the nfs/udp port specified in
.IR /etc/services ,
or, if that is undefined, on port 2049.
.TP
.BR \-p " or " \-\-promiscuous
Put the server into promiscuous mode where it will serve any host
on the network.
.TP
.BR \-r " or " \-\-re\-export
Allow remotely mounted file-systems to be exported.  This can be used to
turn a machine into a multiplier for NFS or Novell servers. Caution
should be used when re-exporting loopback NFS mounts because re-entering
the mount point will result in deadlock between the NFS client and the
NFS server.
.IP
I should be noted that (on Linux)
.I nfsd
looks at the major device number of the file system to find out whether
it is a remote volume; if the major number is not 0, it assumes the file
system is local. However, not only remote file systems use major number 0,
also procfs does. If you choose to re-export NFS file systems, beware
that this potentially includes
.IR /proc
if you have the file system root exported. This poses a security problem,
and you should avoid this situation if possible.
.\".TP
.\".BR \-s " or " \-\-synchronous\-writes
.\"The NFS protocol specification requires all write operations to the server
.\".\"to be complete before the call returns. By default, 
.\".I nfsd
.\"does not do this. This option turns on synchronous writes.
.\"--- why would anyone want to turn this off?
.\".TP
.\".BR \-t " or " \-\-no\-spoof\-trace
.\"By default, 
.\".I nfsd 
.\"logs every access by unauthorized clients. This option turns off logging
.\"of such spoof attempts for all hosts listed explicitly in the
.\".I exports
.\"file.
.TP
.BR \-v " or " \-\-version
Report the current version number of the program.
.TP
.BR numcopies
This is an experimental feature that lets you run several instances of
.I nfsd
in parallel. When given a value of 
.B numcopies
greater than one, 
.I nfsd
will fork as many times as specified by this value.
However, the servers do not share a common file handle
cache, which makes certain file operations impossible. 
.IP
For this reason,
.I nfsd
will disallow all write operations when invoked with this option. Although
this is very limiting, this feature may still prove useful for exporting
public FTP areas or Usenet News spools.
.SH SIGNALS
.I nfsd
recognizes the following signals:
.TP
.I SIGHUP
causes 
.I nfsd
to re-read the export file and flush the file handle cache.
.TP
.I SIGUSR1
When 
.I nfsd
was invoked with debugging options, sending this signal toggles
generation of debug information.
.TP
.I SIGIOT
When compiled with with the -DCALL_PROFILING option, sending a SIGIOT to
.I nfsd
will cause dump the average execution times per NFS operation into
.IR /tmp/nfsd.profile .
.SH "SEE ALSO"
exports(5), mountd(8), ugidd(8C)
.SH AUTHORS
Mark Shand wrote the orignal unfsd.
Don Becker extended unfsd to support authentication
and allow read-write access and called it hnfs.
Rick Sladkey added host matching, showmount -e support,
mountd authentication, inetd support, and all of the
portability and configuration code.
Olaf Kirch fixed one or two security holes and other bugs, added
the uid mapping and a couple of other things.
