.\" Copyright (c) 1980, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	@(#)appen.B	8.1 (Berkeley) 6/8/93
.\"
.ie t .oh '\*(Ln Appendix B''PS1:19-%'
.eh 'PS1:19-%''\*(Ln Appendix B'
.el .he ''\fIAppendix B\fR''
.bp
.(x
.ti 0
.b "Appendix B"
.)x
.nr $1 0
.sh 1 "The WINDOW structure"
.pp
The WINDOW structure is defined as follows:
.(l I
.so win_st.gr
.)l
.pp
.Vn \*_cury \\*
.(f
\**
All variables not normally accessed directly by the user
are named with an initial
.Bq \*_
to avoid conflicts with the user's variables.
.)f
and
.Vn \*_curx
are the current \*y for the window.
New characters added to the screen
are added at this point.
.Vn \*_maxy
and
.Vn \*_maxx
are the maximum values allowed for
.Vn \*_cury\*,\*_curx ). (
.Vn \*_begy
and
.Vn \*_begx
are the starting \*y on the terminal for the window,
.i i.e. ,
the window's home.
.Vn \*_cury ,
.Vn \*_curx ,
.Vn \*_maxy ,
and
.Vn \*_maxx
are measured relative to
.Vn \*_begy\*,\*_begx ), (
not the terminal's home.
.pp
.Vn \*_clear
tells if a clear-screen sequence is to be generated
on the next
.Fn refresh
call.
This is only meaningful for screens.
The initial clear-screen for the first
.Fn refresh
call is generated by initially setting clear to be TRUE for
.Vn curscr ,
which always generates a clear-screen if set,
irrelevant of the dimensions of the window involved.
.Vn \*_leave
is TRUE if the current \*y and the cursor
are to be left after the last character changed on the terminal,
or not moved if there is no change.
.Vn \*_scroll
is TRUE
if scrolling is allowed.
.pp
.Vn \*_y
is a pointer to an array of lines which describe the terminal.
Thus:
.(l
\*_y[i]
.)l
.lp
is a pointer to the
.Vn i th
line, and
.(l
\*_y[i][j]
.)l
.lp
is the
.Vn j th
character on the
.Vn i th
line.
.Vn \*_flags
can have one or more values
or'd into it.
.pp
For windows that are not subwindows,
.Vn \*_orig
is
NULL .
For subwindows,
it points to the main window
to which the window is subsidiary.
.Vn \*_nextp
is a pointer in a circularly linked list
of all the windows which are subwindows of the same main window,
plus the main window itself.
.pp
.Vn \*_firstch
and
.Vn \*_lastch
are
.Fn malloc ed
arrays which contain the index of the
first and last changed characters
on the line.
.Vn \*_ch\*_off
is the x offset for the window
in the
.Vn \*_firstch
and
.Vn \*_lastch
arrays for this window.
For main windows,
this is always 0;
for subwindows
it is the difference between the starting point of the main window
and that of the subindow,
so that change markers can be set relative to the main window.
This makes these markers global in scope.
.pp
All subwindows share the appropriate portions of
.Vn _y ,
.Vn _firstch ,
.Vn _lastch ,
and
.Vn _insdel
with their main window.
.pp
.b \*_ENDLINE
says that the end of the line for this window
is also the end of a screen.
.b \*_FULLWIN
says that this window is a screen.
.b \*_SCROLLWIN
indicates that the last character of this screen
is at the lower right-hand corner of the terminal;
.i i.e. ,
if a character was put there,
the terminal would scroll.
.b \*_FULLLINE
says that the width of a line is the same as the width of the terminal.
If
.b \*_FLUSH
is set,
it says that
.Fn fflush "" "" stdout
should be called at the end of each
.Fn refresh
.b \*_STANDOUT
says that all characters added to the screen
are in standout mode.
.b \*_INSDEL
is reserved for future use,
and is set by
.Fn idlok .
.Vn \*_firstch
is set to
.b \*_NOCHANGE
for lines on which there has been no change
since the last
.Fn refresh .
