/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#include <stdlib.h>
#include <sysdeps.h>

#undef rand
#undef srand

#ifdef NO_UNDERSCORE
#define next _next
#endif

static unsigned long next = 1;

int rand (void)
    {
/*
 *  This is the assembly expansion of the statement to avoid compiler
 *  problems with the Linux compiler.
 */
#if 1
    int result;
#ifdef __PIC__
    __asm__ ("imull\t$1103515245,%%eax\n\t"
	     "addl\t$12345,%%eax\n\t"
	     "mov\t%%eax,_next@GOTOFF(%%ebx)\n\t"
	     "andl\t$2147483647,%%eax"
	     : "=a" (result) : "0" (next));
#else
    __asm__ ("imull\t$1103515245,%%eax\n\t"
	     "addl\t$12345,%%eax\n\t"
	     "mov\t%%eax,_next\n\t"
	     "andl\t$2147483647,%%eax"
	     : "=a" (result) : "0" (next));
#endif
    /* Try and improve the randomness by swapping two bytes */
    result = (result & 0xff00ff00) | ((result & 0xff) << 16) |
      ((result & 0xff0000) >> 16);

    return (result);
#else
    return ((int) ((next = next * 1103515245 + 12345) % (RAND_MAX + 1)));
#endif
    }

void srand (unsigned int seed)
    {
    next = seed;
    }
