/*  LAST EDIT: Thu Oct  5 15:52:33 1995 by Thorsten Kukuk (jkuku1)  */
/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Modified for use with ypserv by Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

#include "system.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include "yp.h"
#include <rpcsvc/ypclnt.h>
#include <memory.h>
#ifdef HAVE_RPC_CLNT_SOC_H
#include <rpc/clnt_soc.h>
#endif

 
#if 0
#define SOCKSERVER 0x7f000001
#endif

static struct sockaddr_in ServerAddress;
static CLIENT *UdpClient=NULL, *TcpClient=NULL;
 
#ifdef YPBROADCAST
static bool_t
eachresult( caddr_t resultsp, struct sockaddr_in *raddr)
{
   bcopy(raddr, &ServerAddress, sizeof(ServerAddress));
   return((bool_t) TRUE);
}
#endif
 
static struct sockaddr_in *
__do_ypbind(domainname d)
{
   static struct sockaddr_in resp;
   int rc;
   ypbind_resp r;
   CLIENT *localBindClient;
   struct sockaddr_in localAddr;
   int s;
   struct timeval t={5,0}, tott={25,0};

   s=RPC_ANYSOCK;
   memset(&localAddr, '\0', sizeof localAddr);
   localAddr.sin_family = AF_INET;
   localAddr.sin_addr.s_addr=htonl(INADDR_LOOPBACK);
   localBindClient=clntudp_create(&localAddr, YPBINDPROG, YPBINDVERS, tott, &s);
   if (!localBindClient) {
      clnt_pcreateerror("");
      return NULL;
   }
   
   rc=clnt_call(localBindClient, YPBINDPROC_DOMAIN, 
      xdr_domainname, (char *)&d, xdr_ypbind_resp, (char *)&r, t);
   if (rc) {
      clnt_perrno(rc);
      return NULL;
   }

   switch (r.ypbind_status) {
   case YPBIND_FAIL_VAL:
      switch(r.ypbind_resp_u.ypbind_error) {
      case YPBIND_ERR_ERR:
         fprintf(stderr, "YPBINDPROC_DOMAIN: Internal error\n");
         break;
      case YPBIND_ERR_NOSERV:
         fprintf(stderr, "YPBINDPROC_DOMAIN: No bound server for passed domain\n");
         break;
      case YPBIND_ERR_RESC:
         fprintf(stderr, "YPBINDPROC_DOMAIN: System resource allocation failure\n");
         break;
      default:
         fprintf(stderr, "YPBINDPROC_DOMAIN: Unknown error\n");
         break;
      }
      return NULL;
   case YPBIND_SUCC_VAL:
      {
         struct ypbind_binding *y=&r.ypbind_resp_u.ypbind_bindinfo;
         memset(&resp, '\0', sizeof resp);
         resp.sin_family=AF_INET;
         resp.sin_addr=*(struct in_addr *)(y->ypbind_binding_addr);
         return &resp;
      }
   }
   return NULL;
}

void
__yp_unbind(char *DomainName)
{
   if (UdpClient) clnt_destroy(UdpClient);
   UdpClient=NULL;
   if (TcpClient) clnt_destroy(TcpClient);
   TcpClient=NULL;
}
 
int
_yp_bind(struct sockaddr_in *ServerAddress, char *DomainName)
{
   struct sockaddr_in UdpServerAddress, TcpServerAddress;
   int UdpSockp, TcpSockp;
   static struct timeval Wait = { 5, 0 };
 
   if (UdpClient || TcpClient) __yp_unbind(DomainName);
 
   memcpy(&UdpServerAddress, ServerAddress, sizeof(*ServerAddress));
   UdpServerAddress.sin_port=0;
   UdpSockp=(RPC_ANYSOCK);
   memcpy(&TcpServerAddress, ServerAddress, sizeof(*ServerAddress));
   TcpServerAddress.sin_port=0;
   TcpSockp=(RPC_ANYSOCK);
   if ((UdpClient=clntudp_create(&UdpServerAddress, YPPROG, YPVERS,
      Wait, &UdpSockp))==NULL) {
      clnt_pcreateerror("UdpClient");
      return(YPERR_RPC);
   }
   if ((TcpClient=clnttcp_create(&TcpServerAddress, YPPROG, YPVERS,
      &TcpSockp, 0, 0))==NULL) {
      clnt_pcreateerror("TcpClient");
      return(YPERR_RPC);
   }
   return(0);
 
}
 
int
__yp_bind(char *DomainName)
{
#  ifdef YPBROADCAST
   enum clnt_stat clnt_stat;
   static bool_t res;
#  endif
   static domainname domain;
 
   domain=DomainName;
#  ifndef SOCKSERVER
#  ifdef YPBROADCAST
   bzero(&ServerAddress, sizeof ServerAddress);
   if ((clnt_stat=clnt_broadcast(YPPROG, YPVERS,
      YPPROC_DOMAIN_NONACK, xdr_domainname, (char *)&domain, xdr_bool,
      (char *)&res, eachresult))!=RPC_SUCCESS) {
      clnt_perrno(clnt_stat);
      return(YPERR_DOMAIN);
   }
#  else
   {
      struct sockaddr_in *s=__do_ypbind(DomainName);
      if (!s) return(YPERR_DOMAIN);
      ServerAddress=*s;
   }
#  endif
#  else
   bzero(&ServerAddress, sizeof ServerAddress);
   ServerAddress.sin_family=AF_INET;
   ServerAddress.sin_addr.s_addr=htonl(SOCKSERVER);
#  endif /* SOCKSERVER */
   return (_yp_bind(&ServerAddress, DomainName));
}
 
int
__yp_all( char *DomainName, char *MapName, struct ypall_callback *CallBack)
{
   static ypreq_nokey req;
   ypresp_all *resp;
   extern struct ypall_callback *xdr_ypall_callback;
   int Status;
 
   do {
      if (TcpClient==NULL)
         if ((Status=__yp_bind(DomainName))) return(Status);
 
      req.domain=DomainName;
      req.map=MapName;
      xdr_ypall_callback=CallBack;
      if ((resp=ypproc_all_2(&req, TcpClient))==NULL) {
         clnt_perror(TcpClient, "ypall");
         __yp_unbind(DomainName);
      }
   } while(resp==NULL);
   switch (resp->ypresp_all_u.val.stat) {
   case YP_TRUE:
   case YP_NOMORE:
      Status=0;
      break;
   default:
      Status=ypprot_err(resp->ypresp_all_u.val.stat);
   }
   clnt_freeres(TcpClient, xdr_ypresp_all, (void *) resp);
   return(Status);
}
 

#if !defined(__FreeBSD__)
int __yp_master( char *DomainName, char *MapName, char **OutMaster)
{
   static ypreq_nokey req;
   ypresp_master *resp;
   int Status;
 
   do {
      if (UdpClient==NULL)
         if ((Status=__yp_bind(DomainName))) return(Status);
 
      req.domain=DomainName;
      req.map=MapName;
      if ((resp=ypproc_master_2(&req, UdpClient))==NULL) {
         clnt_perror(UdpClient, "ypmaster");
         __yp_unbind(DomainName);
      }
   } while(resp==NULL);
   if (resp->stat!=YP_TRUE) {
      Status=ypprot_err(resp->stat);
   } else {
      if (((*OutMaster)=malloc(strlen(resp->peer)+1))!=NULL) {
         strcpy(*OutMaster, resp->peer);
         Status=0;
      } else {
         Status=YPERR_RESRC;
      }
   }
   clnt_freeres(UdpClient, xdr_ypresp_master, (void *) resp);
   return(Status);
}
#endif

 
char *yperr_string(incode)
   int incode;
{
   switch(incode) {
      case YPERR_BADARGS: return("Args to function are bad");
      case YPERR_RPC: return("RPC failure");
      case YPERR_DOMAIN: return("Can't bind to a server which serves this domain.");
      case YPERR_MAP: return("No such map in server's domain");
      case YPERR_KEY: return("No such key in map");
      case YPERR_YPERR: return("Internal yp server or client interface error");
      case YPERR_RESRC: return("Local resource allocation failure");
      case YPERR_NOMORE: return("No more records in map database");
      case YPERR_PMAP: return("Can't communicate with portmapper");
      case YPERR_YPBIND: return("Can't communicate with ypbind");
      case YPERR_YPSERV: return("Can't communicate with ypserv");
      case YPERR_NODOM: return("Local domain name not set");
      case YPERR_BADDB: return(" yp data base is bad");
      case YPERR_VERS: return("YP version mismatch");
      default: return("Args to function are bad");
   }
}
 
#if defined(__FreeBSD__)
int ypprot_err( unsigned int incode)
#else
int ypprot_err( long int incode)
#endif
{
   switch(incode) {
      case YP_TRUE: return(0);
      case YP_NOMORE: return(YPERR_NOMORE);
      case YP_FALSE: return(YPERR_BADARGS);
      case YP_NOMAP: return(YPERR_MAP);
      case YP_NODOM: return(YPERR_NODOM);
      case YP_NOKEY: return(YPERR_KEY);
      case YP_BADOP: return(YPERR_BADARGS);
      case YP_BADDB: return(YPERR_BADDB);
      case YP_YPERR: return(YPERR_YPERR);
      case YP_BADARGS: return(YPERR_BADARGS);
      case YP_VERS: return(YPERR_VERS);
      default: return(YPERR_BADARGS);
   }
}

int
_yp_clear(char *DomainName)
{
   void *resp;
   int Status;

   do {
      if (UdpClient==NULL)
         if ((Status=__yp_bind(DomainName))) return(Status);
      if ((resp=ypproc_clear_2(NULL, UdpClient))==NULL) {
         clnt_perror(UdpClient, "_yp_clear");
         __yp_unbind(DomainName);
      }
   } while(resp==NULL);
   return 0;
}

int
_yp_maplist(char *DomainName, ypmaplist **OutMaplist)
{
   ypresp_maplist *resp;
   ypmaplist *m;
   ypmaplist *r=NULL;
   int Status;

   do {
      if (UdpClient==NULL)
         if ((Status=__yp_bind(DomainName))) return(Status);
      if ((resp=ypproc_maplist_2(&DomainName, TcpClient))==NULL) {
         clnt_perror(UdpClient, "_yp_maplist");
         __yp_unbind(DomainName);
      }
   } while(resp==NULL);
   if (resp->stat!=YP_TRUE) {
      Status=ypprot_err(resp->stat);
   } else {
      Status=0;
      for (m=resp->maps; m; m=m->next) {
         struct ypmaplist *rr=r;
         r=malloc(sizeof (struct ypmaplist));
         if (!r) {
            Status=YPERR_RESRC;
            break;
         }
         r->map=malloc(strlen(m->map)+1);
         if (!r->map) {
            Status=YPERR_RESRC;
            break;
         }
         strcpy(r->map, m->map);
         r->next=rr;
      }
      (*OutMaplist)=NULL;
      if (!Status) while (r) {
         struct ypmaplist *rr=r->next;
         r->next=*OutMaplist;
         (*OutMaplist)=r;
         r=rr;
      }
   }
   clnt_freeres(UdpClient, xdr_ypresp_maplist, (void *) resp);

   return(Status);
}
