/*  LAST EDIT: Thu Oct  5 13:14:17 1995 by Thorsten Kukuk (jkuku1)  */
/*
** This file is part of the NYS YP Server.
**
** The NYS YP Server is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS YP Server is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public
** License along with the NYS YP Server; see the file COPYING.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Autor: Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <netdb.h>
#include <sys/param.h>
#include <sys/time.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#elif !defined(HAVE_GETOPT) || defined(sun)
#include <compat/getopt.h>
#endif
#include <gdbm.h>

static GDBM_FILE dbm;
static int lower = 0;

#ifndef HAVE_GETOPT
#include <compat/getopt.c>
#endif

static inline void write_data(datum key, datum data)
{
  if (gdbm_store(dbm, key, data, GDBM_REPLACE) < 0)
    {
      perror("makedbm: dbm_store");
      gdbm_close(dbm);
      exit(1);
    }
}


static void create_file(char *fileName, char *dbmName, char *masterName,
			char *domainName, char *inputName, char *outputName)
{
  datum  kdat, vdat;
  char   key[8192];
  char   filename[1024];
  char   *data;
  FILE   *input;
  char   orderNum[12];
  struct timeval tv;
  struct timezone tz;
   
  input=strcmp(fileName, "-")?fopen(fileName, "r"):stdin;
  if (input==NULL) 
    {
      fprintf(stderr, "makedbm: Cannot open %s\n", fileName);
      exit(1);
    }

  sprintf(filename, "%s~", dbmName);
  if ((dbm=gdbm_open(filename,0,GDBM_NEWDB,0600,NULL))==NULL) 
    {
      fprintf(stderr, "makedbm: Cannot open %s\n", filename);
      exit(1);
    }

  if (masterName && *masterName) 
    {
      kdat.dptr="YP_MASTER_NAME"; kdat.dsize=strlen(kdat.dptr);
      vdat.dptr=masterName; vdat.dsize=strlen(vdat.dptr);
      write_data(kdat,vdat);
    }
  
  if (domainName && *domainName) 
    {
      kdat.dptr="YP_DOMAIN_NAME"; kdat.dsize=strlen(kdat.dptr);
      vdat.dptr=domainName; vdat.dsize=strlen(vdat.dptr);
      write_data(kdat,vdat);
    }
  
  if (inputName && *inputName) 
    {
      kdat.dptr="YP_INPUT_NAME"; kdat.dsize=strlen(kdat.dptr);
      vdat.dptr=inputName; vdat.dsize=strlen(vdat.dptr);
      write_data(kdat, vdat);
    }

  if (outputName && *outputName) 
    {
      kdat.dptr="YP_OUTPUT_NAME"; kdat.dsize=strlen(kdat.dptr);
      vdat.dptr=outputName; vdat.dsize=strlen(vdat.dptr);
      write_data(kdat,vdat);
    }
 
  gettimeofday(&tv, &tz);
#if defined(linux)
  sprintf(orderNum, "%d", tv.tv_sec);
#else
  sprintf(orderNum, "%ld",tv.tv_sec);
#endif
  kdat.dptr="YP_LAST_MODIFIED"; kdat.dsize=strlen(kdat.dptr);
  vdat.dptr=orderNum; vdat.dsize=strlen(vdat.dptr);
  write_data(kdat, vdat);

  while ((data = fgets(key, sizeof(key)-1, input)) != NULL)
    {
      int len = strlen(data);
      
      if (len > 1 && data[len-1] == '\n')
	data[len-1] = '\0';
      
      while (*data && *data != '\t' && *data != ' ')
	++data;
      
      if (!*data)
	fprintf(stderr, "makedbm: warning: malformed input data (ignored)\n");
      else
	{
	  int i;
	  
	  *data++ = '\0';
	  
	  kdat.dsize = strlen(key);
	  kdat.dptr = key;
	  
	  vdat.dsize = strlen(data);
	  vdat.dptr = data;
	  
	  if(lower)
	    for(i = 0; i < kdat.dsize; i++)
	      kdat.dptr[i] = tolower(kdat.dptr[i]);
	  
	  write_data(kdat, vdat);
	}
    }
  
  gdbm_close(dbm);
  unlink(dbmName);
  rename(filename, dbmName);
  
}

static void dump_file(char *dbmName)
{
  datum key, data;
  if ((dbm=gdbm_open(dbmName,0,GDBM_READER, 0600, NULL))==NULL) 
    {
      fprintf(stderr, "makedbm: Cannot open %s\n", dbmName);
      exit(1);
    }
  for (key=gdbm_firstkey(dbm); 
       key.dptr; key=gdbm_nextkey(dbm,key)) 
    {
      data=gdbm_fetch(dbm,key);
      if (!data.dptr) 
	{
	  fprintf(stderr, "Error:\n");
	  perror(dbmName);
	  exit (1);
	}
      printf("%.*s %.*s\n",
	     key.dsize, key.dptr,
	     data.dsize, data.dptr);
    }
  gdbm_close(dbm);
}

static void Usage( void)
{
  fprintf(stderr, "usage: makedbm -u dbname\n");
  fprintf(stderr, "       makedbm [-l] [-i inputfile] [-o outputfile]\n");
  fprintf(stderr, "              [-m mastername] inputfile dbname\n");
  exit(1);
}

int main(int argc, char *argv[])
{
  char *masterName=NULL;
  char *domainName=NULL;
  char *inputName=NULL;
  char *outputName=NULL;
  char thisHost[MAXHOSTNAMELEN+1];
  int UFlag=0;

  while(1) 
    {
      int c=getopt(argc, argv, "uli:o:m:d:");
      if (c==EOF) break;
      switch (c) 
	{
	case 'l':
	  lower++;
	  break;
	case 'u': 
	  UFlag++;
	  break;
	case 'd':
	  domainName=optarg;
	  break;
	case 'i':
	  inputName=optarg;
	  break;
	case 'o':
	  outputName=optarg;
	  break;
	case 'm':
	  masterName=optarg;
	  break;
	case '?':
	  Usage();
	  break;
	}
    }

  argc-=optind;
  argv+=optind;

  if (!masterName) 
    {
      if (gethostname(thisHost, sizeof thisHost)<0) 
	{
	  perror("gethostname");
	} 
      else 
	{
	  struct hostent *h;
	  h=gethostbyname(thisHost);
	  if (h) strncpy(thisHost, h->h_name, sizeof thisHost);
	  masterName=thisHost;
	}
    }
  
  if (UFlag)
    {
      if(argc<1)
	Usage();
      else
	dump_file(argv[0]);
    }
  else
    {
      if (argc<2) 
	Usage();
      else
	create_file(argv[0], argv[1], masterName, domainName, 
		    inputName, outputName);
    }

  return 0;
}
