/*
 * $Log: ypbind.h,v $
 * Revision 1.1  1995/07/25 14:28:02  swen
 * ypbind version 2.0.
 *
 * Revision 2.4  1995/01/24  12:24:32  swen
 * Added RCS keywords.
 *
 */

#ifndef BINDINGDIR
#define BINDINGDIR "/var/yp/binding"
#endif
#define USE_BINDINGDIR 1
#ifndef _PATH_YPCONF
#define _PATH_YPCONF "/etc/yp.conf"
#endif
#define _PATH_YPPIDFILE _PATH_VARRUN"ypbind.pid"
#define _MAXDOMAIN  8
#define REBIND_INTERVAL 300 /* rebind every 5 minutes */
#define PING_INTERVAL     5 /* check binding every 5 seconds */
#define YPSET_NO	0
#define YPSET_LOCAL	1
#define YPSET_ALL	2

#define MMAP_SHARED_OK 0          /* does shared mapping of files work? */
                                  /* (it does in 1.3.12                 */
#define MMAP_SHARED_ANON_OK 0     /* can we share anonymous regions?    */

struct binding
{
  struct hostent *host;
  struct in_addr server_addr;
  long int version;
  unsigned short int server_port;
  char domain[YPMAXDOMAIN];
  int lockfd;
  CLIENT *client_handle;
  bool_t is_bound;
  bool_t is_alive;
  bool_t use_broadcast;
  time_t next_check;
};

typedef char *domainname;

extern void *ypbindproc_null_2_svc(struct svc_req *);
extern struct ypbind_resp *ypbindproc_domain_2_svc(domainname, struct svc_req *);
extern void *ypbindproc_setdom_2_svc(struct ypbind_setdom, struct svc_req *);
extern struct ypservers *ypconf_read(const char *);

extern bool_t xdr_domainname(XDR *, char *);

bool_t eachresult(bool_t *, struct sockaddr_in *);
void parse_config_file(const char *);
void check_config_entry(char *, const char *);
void broadcast(struct binding *);
void add_server(char *, struct sockaddr_in *, CLIENT *, struct hostent *, bool_t);
void sighandler(int);
void toggle_debug(int);
void handle_hangup(int);
void terminate(void);
int get_entry(char *, struct binding *);
void update_entry(struct binding *);
int open_lockfile(void);
struct binding *find_entry(char *dom);
pid_t start_slave (void);
void bindto_server (char *, struct hostent *);
void ping_server(struct binding *);
void write_lock_binding(void);
void read_lock_binding(void);
void un_lock_binding(void);
void inststr(char **, int, const char *);
void init_binding(void);
void check_binding(void);
void create_pidfile(void);
