\. /* Copyright 1993-95 by Carl Harris, Jr.
\.  * All rights reserved
\.  *
\.  * Distribute freely, except: don't remove my name from the source or
\.  * documentation (don't take credit for my work), mark your changes (don't
\.  * get me blamed for your possible bugs), don't alter or remove this
\.  * notice.  May be sold if buildable source is provided to buyer.  No
\.  * warrantee of any kind, express or implied, is included with this
\.  * software; use at your own risk, responsibility for damages (if any) to
\.  * anyone resulting from the use of this software rests entirely with the
\.  * user.
\.  *
\.  * Send bug reports, bug fixes, enhancements, requests, flames, etc., and
\.  * I'll try to keep a version up to date.  I can be reached as follows:
\.  * Carl Harris <ceharris@vt.edu>
\.  */
\.
\. $Log: popclient.man,v $
\. Revision 1.4  1995/09/07 22:53:49  ceharris
\. One last bit of crap before the 3.0b4 release
\.
\. Revision 1.3  1995/08/14 18:36:46  ceharris
\. Patches to support POP3's LAST command.
\. Final revisions for beta3 release.
\.
\. Revision 1.2  1995/08/08 01:01:29  ceharris
\. Added GNU-style long options processing.
\. Fixed password in 'ps' output problem.
\. Fixed various RCS tag blunders.
\. Integrated .poprc parser, lexer, etc into Makefile processing.
\.
\.
.TH popclient LOCAL
.SH NAME
popclient \- retrieve mail from a mailserver using Post Office Protocol.
.SH SYNOPSIS
.B popclient
[\fI options \fR] \fI server-host [server-host...]\fR
.SH DESCRIPTION
.I popclient
is a Post Office Protocol compliant mail retrieval client which supports 
both POP2 (as specified in RFC 937) and POP3 (RFC 1725).
.PP
Typically,
.I popclient
will be used to download mail in batch from the remote mailserver specified by
.I host
to a mail folder on the local disk.  The retrieved mail will then be 
manipulated using a local mail reader, such as
.I mail
or 
.I elm.
.PP
To facilitate the use of
.I popclient
in scripts, pipelines, etc, it returns an appropriate exit code upon 
termination -- see EXIT CODES below.
.SH OPTIONS
.TP
.B \-2
Use Post Office Protocol version 2 (POP2).  See also the 
.B \--protocol
option, below.
.TP
.B \-3
Use Post Office Protocol version 3 (POP3).  See also the
.B \--protocol
option, below.
.TP
.B \-a, --all
POP3 only.  Retrieve both old (previously retrieved) and new messages from 
the mailserver.
.TP
.B \-c, --stdout
Causes retrieved messages to be written to stdout instead of a mail folder.
See OUTPUT OPTIONS below for a complete description.  You may not specify
both the
.B \-c
and 
.B \-o
options on the same command line.
.TP
.B \-F, --flush
POP3 only.  Delete old (previously retrieved) messages from the mailserver
before retrieving new messages.
.TP
.B \-f pathname, --poprc pathname
Specify an alternate name for the .poprc file.
.TP
.B \-k, --keep
Keep retrieved messages in folder on remote mailserver.  Normally, messages 
are deleted from the folder on the mailserver after they have been retrieved
(unless 
.I popclient
was compiled with the KEEP_IS_DEFAULT option).  Specifying the 
.B keep 
option causes retrieved messages to remain in your folder on the mailserver.
.TP
.B \-K, --kill
Delete retrieved messages from the remote mailserver.  If 
.I popclient
is compiled with the KEEP_IS_DEFAULT option, the
.B kill
option forces retrieved mail to be deleted.
.TP
.B \-l lines, --limit lines
POP3 only.  Retrieve no more than the specified number of lines of each
message body (plus message headers).  The
.B keep
option is implied by the
.B limit
option -- i.e. messages downloaded with the 
.B limit
option remain on the remote mailserver.
.TP
.B \-p string, --password string
Specifies the password 
.I string 
to be used when logging-in to the mailserver.  The 
appropriate password is both server and user dependent.  If the 
.B password 
option is not used to specify a password, you will be prompted 
for a password before the connection to the mailserver is established.  
See USER AUTHENTICATION below for a complete description.
.TP
.B \--protocol proto
Specify the protocol to used when communicating with the remote 
mailserver.  
.I proto 
may be one of the following:
.RS
.IP POP2 
Post Office Protocol 2
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with MD5 authentication.
.IP RPOP
Use POP3 with trusted-host-based authentication (like rlogin/rsh). 
.I popclient
must be installed as a setuid root program to use RPOP.
.B \--proto.
.RE
.TP
.B \-o folder, --local folder
Causes retrieved messages to be appended to file named by the folder 
argument.  When neither 
.B \-o
nor
.B \-c
is specified, retrieved messages are appended to the system default mail 
folder. See OUTPUT OPTIONS below for a complete description.
.TP
.B \-r folder, --remote folder
Causes an alternate mail folder on the mailserver to be retrieved.  The
syntax of the folder name is server dependent, as is the default behavior
when no folder is specified.  Fortunately, most POP servers have a reasonable
default behavior, so use of this option should be limited to fairly specialized
applications.  POP3 does not provide a folder specification in the protocol.
If the
.B remote
option is used in conjunction with the POP3 protocol, the remote folder 
specification is ignored.
.TP
.B \-s, --silent
Silent mode.  Suppresses all progress/status messages that are normally
echoed to stderr during a POP connection.  If both the 
.B silent
and
.B verbose
options are specified, the 
.B verbose
option takes precedence.
.TP
.B \-u name, --username name
Specifies the user idenfication to be used when logging-in to the mailserver.
The appropriate user identification is both server and user dependent.  
The default is your login name on the machine that is running 
.I popclient.
See USER AUTHENTICATION below for a complete description.
.TP
.B \-v, --verbose
Verbose mode.  All control messages passed between 
.I popclient
and the mailserver are echoed to stderr.  Specifying
.B verbose
causes normal progress/status messages which would be redundant or meaningless
to be modified or omitted.
.TP
.B \-V, --version
Displays the version information for your copy of 
.I popclient.
If you specify the 
.B \version
option, all other options are ignored and no POP connection is made.
.TP
.PP
.SH PROTOCOL SELECTION
The selection of the correct Post Office Protocol (POP2 or POP3) depends upon
the configuration of the mailserver from which you retrieve your mail.  The
system adminstrator who installed 
.I popclient
on your system should have chosen an appropriate default protocol for your 
mailserver.  If you get the message 'Connection refused' when using the 
default protocol, try specifying
.B \-2
or
.B \-3
to select a different protocol.  If the 'Connection refused' message persists 
regardless of the protocol selected, it is likely that your mailserver is not 
running a POP compliant mail service.
.PP
.SH USER AUTHENTICATION
User authentication in 
.I popclient
is very much like the authentication mechanism of 
.I ftp(1).
The correct user-id and password depend upon the underlying security
system at the mailserver.  
.PP
If the mailserver is a Unix machine on which you have an ordinary user 
account, your regular login name and password are used with 
.I popclient.
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the 
.B \-u
option \-\- 
the default behavior will use your login name on the client machine as the 
user-id on the server machine.  If you use a different login name
on the server machine, specify that login name with the
.B \-u
option.  e.g. if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start 
.I popclient 
as follows:
.IP
popclient -u jsmith mailgrunt
.PP
The default behavior of 
.I popclient
is to prompt you for your mailserver password before the POP connection is
established.  This is the safest way to use 
.I popclient
and ensures that your password will not be compromised.  You may also specify
your password using the  
.B \-p
option.  This is convenient when using 
.I popclient
with automated scripts, but it may result in your password being exposed to
prying eyes \-\- be careful!  Regardless of how your password is specified
it is never stored in shared memory segments, or left unencrypted in the core 
image when
.I popclient
terminates.  Continuing the preceding example, suppose your password on
\'mailgrunt' is 'Gr8PassWd'.  The syntax would be:
.IP
popclient -u jsmith -p Gr8PassWd mailgrunt
.PP
On mailservers that do not provide ordinary user accounts, your user-id and 
password are usually assigned by the server administrator when you apply for 
a mailbox on the server.  Contact your server administrator if you don't know 
the correct user-id and password for your mailbox account.
.PP
.SH OUTPUT OPTIONS
.I popclient
always writes the retrieved messages using Unix mail folder format.  This
allows 
.I popclient
to be used in conjunction with common mail readers like
.I mail
and
.I elm.
The retrieved messages are normally appended to your default system mailbox
on the local disk, using the local Mail Delivery Agent (MDA), usually 
/bin/mail(1), so that when you invoke your mail reader it can manipulate the 
retrieved messages like any other mail you receive on the client machine.  
.PP
Using the 
.B \-o
option, you can specify a different mail folder to which the retrieved
messages will be appended.  If you prefer, for example, to have your POP
mail from a machine called 'mailgrunt' stored in the 
.I mbox
file in your home directory, you would start 
.I popclient
as follows:
.IP 
popclient \-o $HOME/mbox mailgrunt
.PP
Note that the folder specified with
.B \-o
is not locked or otherwise protected from other processes writing to it 
while popclient is writing to it.  
.PP
.I popclient
can be used in a shell pipeline by using the 
.B \-c
option.  In this mode, 
.I popclient
writes the retrieved messages to stdout, instead of a mail folder.  This would
allow you, for instance, to pass the incoming mail through a filter that
discards mail marked as 'Precedence: junk'.  Suppose you've written an AWK
script called 'dumpjunk.awk' to implement a junk mail filter.  The appropriate
syntax to retrieve your mail from 'mailgrunt', pass it through the filter,
and write it to a folder called 'realmail' in your home directory would be:
.IP
popclient -c mailgrunt | awk -f dumpjunk.awk > $HOME/realmail
.PP
The progress/status messages written to stderr when the 
.B \-s
option has not been specified, do not interfere with the message stream, which 
is written to stdout.  You may even use 
.B \-v
and 
.B \-c
together without corrupting the message stream.  It is a good idea to use the
.B \-k
option when using 
.B \-c
to insure that your messages will not be lost if part of the shell pipeline 
does not function incorrectly.  The safest bet would be something like:
.IP
popclient -k -c mailgrunt | myfilter > $HOME/filtered.mail
.PP
followed by
.IP
popclient -c mailgrunt > /dev/null
.PP
when you're sure the messages were correctly processed by 'myfilter'.
.PP
.SH EXIT CODES
To facilitate the use of 
.I popclient
in shell scripts and the like, an exit code is returned to give an indication
of what occured during a given POP connection.  The exit code can be tested
by the script and appropriate action taken.
.PP
A simple example follows.  This Bourne shell script executes 
.I popclient
and, if some messages were successfully retrieved from a mailserver retrieved
from the command line, it starts the 
.I mail
utility to read those messages.  Otherwise, it prints a brief message, and
exits.
.EX 0
#!/bin/sh

if popclient $1
then
  mail
else
  echo "No mail to read."
fi
.EE
.PP
The exit codes returned by 
.I popclient
are as follows:
.IP 0
One or more messages were successfully retrieved.
.IP 1
There was no mail awaiting retrieval.
.IP 2
An error was encountered when attempting to open a socket for the POP 
connection.  If you don't know what a socket is, don't worry about it --
just treat this as an 'unrecoverable error'.
.IP 3
The user authentication step failed.  This usually means that a bad 
user-id or password was specified.
.IP 4
Some sort of protocol error was detected.  POP is not especially forgiving
when it comes to unexpected responses, commands, etc -- the protocol invariably
calls for terminating the connection under such error conditions.
.IP 5
There was a syntax error in the arguments to 
.I popclient.
.IP 6
Some kind of I/O woes occurred when writing to the local folder.
.IP 7
There was an error condition reported by the server (POP3 only).
.IP 9
Something totally undefined occured.  This is usually caused by a bug within
.I popclient.
Do let me know if this happens.
.PP
.SH AUTHOR
.I popclient
was written by Carl Harris at Virginia Polytechnic Institute and State   
University (a.k.a. Virginia Tech).
.PP
.SH BUGS
There are none!  Well, maybe one or two.  Send comments, bug reports, gripes, 
and the like to ceharris@mal.com.
.SH SEE ALSO
mail(1), binmail(1), sendmail(8), popd(8), RFC 937, RFC 1225.
