/****************************************************************************/
/*                                                                          */
/*                        GNAT COMPILER COMPONENTS                          */
/*                                                                          */
/*                             A - U R E A L P                              */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                            $Revision: 1.6 $                              */
/*                                                                          */
/*    Copyright (C) 1992, 1993, 1994, 1995 Free Software Foundation, Inc.   */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, */
/* MA 02111-1307, USA.                                                      */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). */
/*                                                                          */
/****************************************************************************/

/* This file corresponds to the Ada package body Urealp. It was created
   manually from the files urealp.ads and urealp.adb. */

#include "config.h"
#include "tree.h"
#include "a-ada.h"
#include "a-types.h"
#include "a-atree.h"
#include "a-nlists.h"
#include "a-elists.h"
#include "a-sinfo.h"
#include "a-einfo.h"
#include "a-namet.h"
#include "a-string.h"
#include "a-uintp.h"
#include "a-urealp.h"

/* Universal reals are represented by the Ureal type which is an index into
   the Ureals_Ptr table containing Ureal_Entry values.  A Ureal_Entry contains
   a numerator value, a denominator value and a Bas value.  */

#define UI_Ge uintp__ui_ge
extern Boolean UI_Ge  PROTO ((Uint, Uint));

#define UI_Gt uintp__ui_gt
extern Boolean UI_Gt  PROTO ((Uint, Uint));

#define UI_Mul uintp__ui_mul
extern Uint UI_Product  PROTO ((Uint, Uint));

#define UI_Expon uintp__ui_expon
extern Uint UI_Exponentiate  PROTO ((Uint, Uint));

#define UI_From_Int uintp__ui_from_int
extern Uint UI_From_Int  PROTO ((Int));

#define UI_Negate uintp__ui_negate
extern Uint UI_Negate  PROTO ((Uint));

/* We are not preserving negative zeroes properly here ??? */

Uint
Numerator (Real)
     Ureal Real;
{
  Nat Bas = Ureals_Ptr[Real].Bas;
  Uint Num = Ureals_Ptr[Real].Num;

  if (Ureals_Ptr[Real].Negative)
     Num = UI_Negate (Num);

  if (Bas == 0)
    return Num;
  else
    {
      Uint Den = Ureals_Ptr[Real].Den;

      if (UI_Ge (Den, Uint_0))
	return Num;
      else
	return UI_Mul (UI_Expon (UI_From_Int (Bas),
		       UI_Negate (Den)), Num);
    }
}

Uint
Denominator (Real)
     Ureal Real;
{
  Nat Bas = Ureals_Ptr[Real].Bas;
  Uint Den  = Ureals_Ptr[Real].Den;

  if (Bas == 0)
    return Den;
  else
    {
      if (UI_Gt (Den, Uint_0))
	return UI_Expon (UI_From_Int (Bas), Den);
      else
	return Uint_1;
     }
}
