#ifndef _FTAPE_READ_H
#define _FTAPE_READ_H

/*
 * Copyright (C) 1994-1995 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 /home/cvs/zftape/ftape-read.h,v
 root
 *
 1.1.1.1
 1995/11/15 16:55:47
 Exp
 *
 *      This file contains the definitions for the read functions
 *      for the QIC-117 floppy-tape driver for Linux.
 *
 */

/*      ftape-read.c defined global vars.
 */
extern int just_before_eof;

/*      ftape-read.c defined global functions.
 */
extern int _ftape_read( char* buff, int req_len);
extern int  read_header_segment( byte* address );
extern int  read_segment_fraction( unsigned segment, byte* address,
                        int read_ahead,int start, int size);
extern void ftape_zap_read_buffers( void);

#define read_segment(segment,address,read_ahead) \
             read_segment_fraction( segment, address, read_ahead, 0, (SECTORS_PER_SEGMENT-3)*SECTOR_SIZE)

extern int ftape_simple_read ( int *read_cnt, 
                               int *to_do, 
                               char *buff, 
                               int buf_pos_read, 
                               int buf_len_read, 
                               char *deblock_buffer,
                               unsigned short block_size );


#endif /* _FTAPE_READ_H */
