/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <sysdep.h>

#if defined(COFF_LIBRARY)
	.text;
	.globl	__exit;		/* Main entry label			*/
	.align	4;		/* Do a 486 alignment.			*/
/*
 *  Terminate through the normal syscall function.
 */
__exit:	movl	$1,%eax;	/* This is the termination request	*/
	lcall	$7,$0;		/* Issue the syscall for exit op.	*/
/*
 *  If the function returns then it means that the emulator is not loaded
 *  in the Linux kernel. Afterall, the emulator doesn't know the terminate
 *  request from any other -- it just ignores all requests.
 */
	popl	%ebx;		/* Fetch the completion code		*/
1:	mov	$1,%eax;	/* Load linux's normal terminate op.	*/
	int	$0x80;		/* Terminate through Linux's syscall	*/
	jmp	1b;		/* Loop on the request			*/
#else

/*
 *  I do not know about the ELF stuff. It should work without regard to
 *  the emulator being present.
 */

PSEUDO (_exit, exit, 1)
#endif

#ifdef ELF_LIBRARY
.type _exit,@function
#endif
