/*
 * X11-Bitmaps for systems that don't support the xpm-library
 */
/*
 * Default filetypes
 */
static char file_ctar[] = {
   0x80, 0x03, 0x80, 0x03, 0xc0, 0x07, 0x80, 0x03, 0xff, 0x03, 0x01, 0x05,
   0xf9, 0x1f, 0x09, 0x28, 0x09, 0x48, 0x09, 0x78, 0x0f, 0x40, 0xf8, 0x7f,
   0x80, 0x03, 0xc0, 0x07, 0x80, 0x03, 0x80, 0x03};

static char file_tar[] = {
   0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x51, 0x00, 0xf9, 0x01, 0x89, 0x02,
   0x89, 0x04, 0x89, 0x0f, 0x09, 0x08, 0x09, 0x08, 0x09, 0x08, 0x0f, 0x08,
   0x08, 0x08, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00};

static char file_root[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x38, 0x00, 0x7c, 0x00,
   0xfe, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x11, 0xb8, 0x3b,
   0x38, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char file_exec[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xac, 0x2a, 0x54, 0x35,
   0xfc, 0x3f, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char file_plain[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x08, 0x06, 0x08, 0x0a,
   0x08, 0x1e, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10,
   0x08, 0x10, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0x00};

static char dir_closed[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x04, 0x3f,
   0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char dir_open[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x04, 0x3f,
   0x04, 0x20, 0xf4, 0xff, 0x14, 0x80, 0x0c, 0x40, 0x0c, 0x40, 0x04, 0x20,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char dir_link[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x04, 0x3f,
   0x04, 0x20, 0x04, 0x24, 0xf4, 0x2f, 0xf4, 0x2f, 0x04, 0x24, 0x04, 0x20,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char dir_lock[] = {
   0x00, 0x00, 0x06, 0x60, 0x0e, 0x70, 0x7c, 0x38, 0xb8, 0x1c, 0x74, 0x3f,
   0xe4, 0x27, 0xc4, 0x23, 0xc4, 0x23, 0xe4, 0x27, 0x74, 0x2e, 0x3c, 0x3c,
   0xfc, 0x3f, 0x0e, 0x70, 0x06, 0x60, 0x00, 0x00};

static char file_link[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xa4, 0x00,
   0xe4, 0x01, 0x04, 0x11, 0xe4, 0x3f, 0xe4, 0x3f, 0x04, 0x11, 0x04, 0x01,
   0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char file_lock[] = {
   0x00, 0x00, 0x00, 0x60, 0xc0, 0x77, 0xe0, 0x3f, 0x30, 0x1c, 0x18, 0x3e,
   0x18, 0x37, 0x98, 0x33, 0xd8, 0x31, 0xf8, 0x30, 0x70, 0x18, 0xf8, 0x0f,
   0xdc, 0x07, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00};

/*
 * Icons
 */
static char icon_move[] = {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0x02, 0x05, 0x00, 0x00,
   0x02, 0x09, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00,
   0xf2, 0x11, 0x00, 0x00, 0x32, 0x10, 0x00, 0x00, 0xf2, 0x10, 0x00, 0x00,
   0x32, 0x10, 0x00, 0x00, 0x32, 0x10, 0x00, 0x00, 0x02, 0x38, 0x00, 0x00,
   0xfe, 0x7f, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x11, 0x00,
   0x00, 0xe0, 0x1b, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0x80, 0x1f, 0x00,
   0x00, 0x00, 0x1f, 0x00, 0x00, 0x80, 0xff, 0x0f, 0x00, 0xc0, 0x1f, 0x14,
   0x00, 0x00, 0x08, 0x24, 0x00, 0x00, 0x08, 0x7c, 0x00, 0x00, 0x08, 0x40,
   0x00, 0x00, 0xc8, 0x4f, 0x00, 0x00, 0x08, 0x43, 0x00, 0x00, 0x08, 0x43,
   0x00, 0x00, 0x08, 0x43, 0x00, 0x00, 0x08, 0x43, 0x00, 0x00, 0x08, 0x40,
   0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00};

static char icon_copy[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0x08, 0x14,
   0x00, 0x00, 0x08, 0x24, 0x00, 0x00, 0x08, 0x7c, 0x00, 0x00, 0x08, 0x40,
   0x00, 0x00, 0x08, 0x43, 0x00, 0x00, 0x88, 0x43, 0x00, 0xe0, 0x0b, 0x43,
   0x00, 0xc0, 0x0b, 0x43, 0xfe, 0xc3, 0x8b, 0x47, 0x02, 0xe5, 0x0b, 0x40,
   0x02, 0x79, 0xfa, 0x7f, 0x02, 0x3f, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00,
   0x02, 0x10, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00,
   0x02, 0x38, 0x00, 0x00, 0x02, 0x78, 0xfa, 0x0f, 0x02, 0xf0, 0x0b, 0x14,
   0xfe, 0xdf, 0x0b, 0x24, 0x00, 0xc0, 0x0b, 0x7c, 0x00, 0xe0, 0x8b, 0x43,
   0x00, 0x00, 0xc8, 0x46, 0x00, 0x00, 0x08, 0x46, 0x00, 0x00, 0x08, 0x43,
   0x00, 0x00, 0x88, 0x41, 0x00, 0x00, 0xc8, 0x47, 0x00, 0x00, 0x08, 0x40,
   0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00};

static char icon_delete[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0x02, 0x05, 0x00,
   0x00, 0x02, 0x09, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x00, 0x02, 0x10, 0x00,
   0x00, 0x02, 0x10, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00, 0x02, 0x10, 0x00,
   0x00, 0xe2, 0x10, 0x00, 0x00, 0xe2, 0x10, 0x00, 0x00, 0xe2, 0x10, 0x00,
   0x00, 0xfe, 0x1f, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00,
   0x00, 0xf0, 0x01, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x01,
   0x60, 0xf6, 0xec, 0x01, 0xe0, 0x66, 0x4e, 0x01, 0xc0, 0x6d, 0x6e, 0x01,
   0xc0, 0x6d, 0xe6, 0x01, 0xc0, 0x4d, 0xf6, 0x00, 0x80, 0x4d, 0xb7, 0x00,
   0x80, 0x5f, 0xb3, 0x00, 0x80, 0xdb, 0xbb, 0x00, 0x00, 0xdb, 0x59, 0x00,
   0x00, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_info[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x07, 0x00, 0xf8, 0x7f, 0x0d, 0x00, 0x08, 0xd0, 0x0a, 0x00,
   0x08, 0x50, 0x0d, 0x00, 0xc8, 0x93, 0x07, 0x00, 0x08, 0xf0, 0x01, 0x00,
   0x68, 0x0f, 0x01, 0x00, 0x08, 0xc0, 0x0f, 0x00, 0xe8, 0xfa, 0x0a, 0x00,
   0x08, 0x40, 0x0d, 0x00, 0xe8, 0xc3, 0x0a, 0x00, 0x08, 0x40, 0x0d, 0x00,
   0xe8, 0xcf, 0x0a, 0x00, 0x08, 0x40, 0x0d, 0x00, 0x08, 0xc0, 0x0a, 0x00,
   0xf8, 0x7f, 0x0d, 0x00, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x40, 0x0d, 0x00,
   0x00, 0xc0, 0x0a, 0x00, 0x00, 0x40, 0x0d, 0x00, 0x00, 0xc0, 0x0a, 0x00,
   0x00, 0x60, 0x0d, 0x00, 0x00, 0xa0, 0x1a, 0x00, 0x00, 0x58, 0x35, 0x00,
   0x00, 0xac, 0x2a, 0x00, 0x00, 0x54, 0x35, 0x00, 0x00, 0xfc, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_warning[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00,
   0x00, 0x50, 0x15, 0x00, 0x00, 0xb0, 0x1a, 0x00, 0x00, 0x58, 0x35, 0x00,
   0x00, 0xa8, 0x2a, 0x00, 0x00, 0x58, 0x35, 0x00, 0x00, 0xa8, 0x2a, 0x00,
   0x00, 0x50, 0x15, 0x00, 0x00, 0xb0, 0x1a, 0x00, 0x00, 0x50, 0x15, 0x00,
   0x00, 0xb0, 0x1a, 0x00, 0x00, 0x60, 0x0d, 0x00, 0x00, 0xa0, 0x0a, 0x00,
   0x00, 0x60, 0x0d, 0x00, 0x00, 0xa0, 0x0a, 0x00, 0x00, 0x40, 0x05, 0x00,
   0x00, 0xc0, 0x06, 0x00, 0x00, 0x40, 0x05, 0x00, 0x00, 0xc0, 0x06, 0x00,
   0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x06, 0x00, 0x00, 0x40, 0x05, 0x00,
   0x00, 0xc0, 0x06, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_newdir[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x84, 0x0a,
   0x00, 0x00, 0x44, 0x75, 0x00, 0x00, 0xc4, 0x6a, 0x00, 0x00, 0x5c, 0x55,
   0x00, 0x00, 0xc4, 0x6a, 0x38, 0x00, 0x44, 0x55, 0x54, 0x00, 0xc4, 0x7f,
   0xaa, 0x03, 0x04, 0x00, 0x56, 0x43, 0x04, 0x00, 0xaa, 0xfa, 0x04, 0x00,
   0x56, 0xfb, 0x05, 0x00, 0xaa, 0xfa, 0x04, 0x00, 0xfe, 0x43, 0x04, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x84, 0x0a,
   0x00, 0x00, 0x44, 0x75, 0x00, 0x00, 0xc4, 0x6a, 0x00, 0x00, 0x5c, 0x55,
   0x00, 0x00, 0xc0, 0x6a, 0x00, 0x00, 0x40, 0x55, 0x00, 0x00, 0xc0, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_wse[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x0f,
   0x10, 0x00, 0x00, 0x08, 0xd0, 0x3f, 0x00, 0x08, 0x50, 0x20, 0xf7, 0x08,
   0x50, 0x2f, 0x00, 0x08, 0x50, 0x2f, 0xd7, 0x09, 0x50, 0x2f, 0x00, 0x08,
   0x50, 0x2f, 0x00, 0x08, 0x50, 0x20, 0xed, 0x09, 0xd0, 0x3f, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x55, 0x3f, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0xb7, 0x3d, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0xf7, 0x0f, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_filter[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf0, 0x01, 0x02,
   0x60, 0x10, 0x06, 0x03, 0xc0, 0x08, 0xb8, 0x01, 0xc0, 0x09, 0xe0, 0x01,
   0x80, 0x07, 0xc0, 0x00, 0x80, 0x07, 0xc0, 0x00, 0x00, 0x0f, 0x41, 0x00,
   0x00, 0x1f, 0x41, 0x00, 0x00, 0xbd, 0x41, 0x00, 0x80, 0xf8, 0x81, 0x00,
   0x40, 0xe0, 0x81, 0x00, 0x40, 0xe0, 0x83, 0x00, 0x20, 0x70, 0x03, 0x01,
   0x20, 0x38, 0x02, 0x01, 0x10, 0x3c, 0x06, 0x02, 0x10, 0x36, 0x06, 0x06,
   0x78, 0x2b, 0x0a, 0x03, 0x80, 0x15, 0x8c, 0x00, 0x00, 0x13, 0x54, 0x00,
   0x00, 0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_wsd[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x78, 0x00, 0xf0, 0xff, 0xff, 0x00,
   0x10, 0x00, 0xf8, 0x00, 0xd0, 0x1f, 0xe0, 0x00, 0x50, 0x10, 0xe0, 0x04,
   0x50, 0x17, 0xe0, 0x06, 0x50, 0x57, 0xf3, 0x06, 0x50, 0x17, 0xf0, 0x04,
   0x50, 0x10, 0xf0, 0x00, 0xd0, 0x1f, 0xfb, 0x08, 0x10, 0x00, 0xf0, 0x0d,
   0x10, 0x00, 0x70, 0x05, 0x10, 0xfc, 0xe1, 0x01, 0x10, 0x00, 0xe0, 0x05,
   0xd0, 0xef, 0x73, 0x04, 0x10, 0x00, 0xf0, 0x04, 0x10, 0xb4, 0x61, 0x0a,
   0x10, 0x00, 0x60, 0x0d, 0x10, 0x00, 0x10, 0x0b, 0xf0, 0xff, 0x9f, 0x12,
   0x00, 0x00, 0x80, 0x13, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0xc0, 0x0f,
   0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x80, 0x07, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_help[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x3f, 0x00, 0x80, 0xab, 0xea, 0x00,
   0x40, 0x55, 0x55, 0x01, 0xc0, 0xaa, 0xaa, 0x01, 0x60, 0xfd, 0x5f, 0x03,
   0xa0, 0x06, 0xb0, 0x02, 0x7c, 0x3f, 0x60, 0x03, 0xa4, 0x52, 0xa0, 0x02,
   0x64, 0x93, 0x60, 0x03, 0xd4, 0xf5, 0xa0, 0x02, 0x04, 0x80, 0x50, 0x03,
   0xe4, 0x9d, 0xac, 0x02, 0x04, 0x80, 0x57, 0x01, 0xb4, 0x9f, 0xaa, 0x01,
   0x04, 0x40, 0xd5, 0x00, 0xb4, 0xc2, 0x3a, 0x00, 0x04, 0x60, 0x05, 0x00,
   0xfc, 0xbf, 0x06, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0xa0, 0x02, 0x00,
   0x00, 0x60, 0x03, 0x00, 0x00, 0xa0, 0x02, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xa0, 0x02, 0x00,
   0x00, 0x60, 0x03, 0x00, 0x00, 0xa0, 0x02, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_exec[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0x02, 0x0a, 0x00,
   0x00, 0x02, 0x12, 0x00, 0x00, 0x02, 0x3e, 0x00, 0x00, 0x02, 0x20, 0x00,
   0x00, 0x02, 0x20, 0x00, 0x00, 0xc2, 0x21, 0x00, 0x00, 0xc2, 0x21, 0x00,
   0x00, 0xc2, 0x21, 0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0xf0, 0x07, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0xc0, 0x01, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0xf8, 0xcf, 0x00,
   0x00, 0xdc, 0x7f, 0x00, 0x00, 0xcc, 0x17, 0x00, 0x00, 0xcc, 0x07, 0x00,
   0x00, 0xc0, 0x07, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xf8, 0x1e, 0x00,
   0x00, 0x7f, 0x38, 0x00, 0x00, 0x0f, 0x30, 0x00, 0x00, 0x01, 0x30, 0x00,
   0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_hide[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x44, 0x00,
   0x00, 0x80, 0x24, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00,
   0x00, 0x80, 0x24, 0x00, 0x00, 0x40, 0x44, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00,
   0x20, 0x00, 0x01, 0x00, 0x10, 0x00, 0x02, 0x00, 0x10, 0x00, 0x02, 0x00,
   0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, 0x02, 0x04, 0x00,
   0x48, 0x06, 0x04, 0x00, 0xc8, 0x03, 0x04, 0x00, 0x68, 0x0c, 0x04, 0x00,
   0x90, 0x0e, 0x02, 0x00, 0xd0, 0x11, 0x02, 0x00, 0x20, 0x06, 0x01, 0x00,
   0xc0, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_link[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00,
   0x00, 0x80, 0x80, 0x01, 0x00, 0x80, 0x80, 0x02, 0x00, 0x80, 0x80, 0x04,
   0x00, 0x80, 0x80, 0x07, 0x00, 0xfe, 0x03, 0x04, 0x80, 0xff, 0x03, 0x04,
   0xc0, 0xff, 0x03, 0x04, 0xe0, 0x87, 0x00, 0x04, 0xe0, 0x81, 0x00, 0x04,
   0xf0, 0x80, 0x00, 0x04, 0xf0, 0x80, 0xff, 0x07, 0x70, 0x00, 0x00, 0x00,
   0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
   0xf0, 0x80, 0xff, 0x00, 0xf0, 0x80, 0x80, 0x01, 0xe0, 0x81, 0x84, 0x02,
   0xe0, 0x87, 0x8c, 0x04, 0xc0, 0xff, 0x9f, 0x07, 0x80, 0xff, 0x3f, 0x04,
   0x00, 0xfe, 0x1f, 0x04, 0x00, 0x80, 0x0c, 0x04, 0x00, 0x80, 0x04, 0x04,
   0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0xff, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char icon_goto[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x56, 0x00, 0x00, 0x00, 0xab, 0x00, 0x00, 0x80, 0x55, 0xff, 0x01,
   0x80, 0xfe, 0xaf, 0x01, 0x80, 0x03, 0x54, 0x01, 0x80, 0x02, 0xac, 0x01,
   0x80, 0xff, 0xff, 0x0f, 0x80, 0x06, 0x00, 0x08, 0x80, 0x03, 0x00, 0x04,
   0x80, 0x02, 0x00, 0x04, 0x80, 0x01, 0x00, 0x02, 0x80, 0x01, 0x00, 0x02,
   0x80, 0x00, 0x00, 0x01, 0x80, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static char *icon_pack = icon_goto;
static char *icon_unpack = icon_goto;
static char *icon_root = icon_goto;
