'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/foreach.n,v 1.1 93/05/03 17:09:42 ouster Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS foreach tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
foreach \- Iterate over all elements in a list
.SH SYNOPSIS
\fBforeach \fIvarname list body\fR
.BE

.SH DESCRIPTION
.PP
In this command \fIvarname\fR is the name of a variable, \fIlist\fR
is a list of values to assign to \fIvarname\fR, and \fIbody\fR is a
Tcl script.
For each element of \fIlist\fR (in order
from left to right), \fBforeach\fR assigns the contents of the
field to \fIvarname\fR as if the \fBlindex\fR command had been used
to extract the field, then calls the Tcl interpreter to execute
\fIbody\fR.  The \fBbreak\fR and \fBcontinue\fR statements may be
invoked inside \fIbody\fR, with the same effect as in the \fBfor\fR
command.  \fBForeach\fR returns an empty string.

.SH KEYWORDS
foreach, iteration, list, looping
