/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MBASE_H
#include <mbase.h>
#endif


/*
 * RELATION FORMAT ------------------------------------------------------------
 *
 */

#define POS_OLDFIELDPTR  2L   /* For 4.0 compatibility         */
#define POS_OLDNUMREC   14L   /* For 4.0 compatibility         */
#define POS_OLDINDICES  26L   /* For 4.0 compatibility         */

#define POS_SIGNATURE    0L   /* This information is described */
#define POS_WORKFLAG     1L   /* in more detail in the file    */
#define POS_NUMQUE       2L   /*    ../tech/chapter.1          */
#define POS_FIELDPTR     6L
#define POS_INDEXPTR    10L
#define POS_RECZERO     14L
#define POS_NUMREC      18L
#define POS_NEXTSER     22L
#define POS_NUMFIELD    26L
#define POS_NUMINDEX    28L
#define POS_INDICES     30L

#define lckPOS_USERS     0L
#define lckPOS_ELOCK     2L
#define lckPOS_HLOCK     4L
#define lckPOS_QUEUE    10L
#define lckPOS_STROBE   70L


/*
 * INTERNAL STRUCTURE DEFINITIONS AND UTILITIES -------------------------------
 *
 */

EXTERN relation *aRel[MAX_REL];
EXTERN bool      fStarted        ASSIGN( = FALSE );

typedef struct
   {
   long    num;
   long    left, right, parent;
   char    parbal;
   int     changed;
   } cache;

#define _change_cache(p,f,v)   { p->changed = 1; _changeqcache(p,f,v); }
#define _changeqcache(p,f,v)     p->f = v
#define _cache_field(p,d) (d==1?p->right: (d==-1?p->left : p->parent))


/*
 * POSITIONING MACROS ---------------------------------------------------------
 *
 */

#define GO_BASE(rel,rcd,idx,off)                                          \
                lseek (rel->fhRel,                                        \
                       rel->posRecZ                                       \
                       + (rcd-1)*(rel->cbRecord+ (long)cbINDEX*rel->nIdx) \
                       + (long)cbINDEX*idx                                \
                       + off, 0)

#define GO_TOP(rel,idx)                                             \
                lseek (rel->fhRel,                                  \
                       POS_INDICES + (long)4*idx,                   \
                       0)

#define GO_NEXTS(rel)                                               \
                lseek (rel->fhRel,                                  \
                       POS_NEXTSER,                                 \
                       0)

#define GO_INDEX(rel,rcd,idx)    GO_BASE (rel, rcd,       idx,  0L)
#define GO_START(rel,rcd)        GO_BASE (rel, rcd,         0,  0L)
#define GO_RECID(rel,rcd)        GO_BASE (rel, rcd, rel->nIdx,  0L)
#define GO_BAL(rel,rcd,idx)      GO_BASE (rel, rcd,       idx, 12L)

#define GO_POINT(rel,rcd,idx,d) \
                GO_BASE (rel, rcd, idx, (((d)==-1)?0L:((d)==1?4L:8L)) )


/*
 * DEFINITIONS ----------------------------------------------------------------
 *
 */

#define cbINDEX 13        /* 4,4,4,1 == Thirteen bytes make up an index */

#define PARDIR (int)0x80
#define BAL    (int)0x7F

#define BAL_LT (BAL_EV - MAX_FRAG)   /* Balance == Left (first off-balance)  */
#define BAL_EV '='                   /* Balance == Even (perfectly balanced) */
#define BAL_RT (BAL_EV + MAX_FRAG)   /* Balance == Right (first off-balance) */

#define VAL_BAL(b)  ((int)(b-BAL_EV))
#define NUM_BAL(b)  ( (b < BAL_EV) ? -1 : (bal > BAL_EV) ? 1 : 0 )
#define BALANCED(b) ( (b > BAL_LT) && (b < BAL_RT) )


#define round2(x) (x%2==0?x:(x+2-(x%2)))
#define round4(x) (x%4==0?x:(x+4-(x%4)))
#define round8(x) (x%8==0?x:(x+8-(x%8)))

#if 0
#ifndef __LINE__
#define __LINE__ 0
#endif
#ifndef __FILE__
#define __FILE__ "unknown"
#endif
#endif

#define Error(e)      { SetError(e); goto lblERROR;   }
#define Error_2(e)    { SetError(e); goto lblERROR_2; }
#define Error_3(e)    { SetError(e); goto lblERROR_3; }

#define Assert_Rel(e)  if (!(e)) { _Corrupt (rel, FALSE); Error (MB_CORRUPT);  }
#define Assert_Dat(e)  if (!(e)) { _Corrupt (rel, TRUE);  Error (MB_BAD_DATA); }
#define Assert(e)      if (!(e)) \
                        { _Assert (#e, __FILE__, __LINE__); Error(MB_ASSERT); }


/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

/* MB_MULTI.C -------------------------------------------------------------- */

   mb_err     _fieldFill     XARGS( (relation *, dataptr, int) );
   mb_err     _recMove       XARGS( (relation *, dataptr, dataptr) );
   mb_err     _recWrite      XARGS( (relation *, dataptr, long) );
   mb_err     _recFill       XARGS( (relation *, dataptr) );
   mb_err     _remove_m      XARGS( (relation *, long) );


/* MB_COMP.C --------------------------------------------------------------- */

   long       _fhDecompress  XARGS( (file, file) );
   long       _fhCompress    XARGS( (file, file) );
   long       _fhCopy        XARGS( (file, file, long) );


/* MB_RMV.C ---------------------------------------------------------------- */

   void       _Assert        XARGS( (char *, char *, long) );
   void       _Corrupt       XARGS( (relation *, bool) );


/* MB_CACHE.C -------------------------------------------------------------- */

   cache     *_read_cache    XARGS( (relation *, long, int) );
   void       _flush_cache   XARGS( (relation *, int) );
   void       _free_cache    XARGS( (void) );


/* MB_UTIL.C --------------------------------------------------------------- */

   int        _identify      XARGS( (relation *) );
   int        _compare       XARGS( (relation *, dataptr, dataptr, int) );
   dataptr    _memrec        XARGS( (relation *, dataptr, long) );
   mb_err     _drop          XARGS( (relation *, long, int, long) );
   mb_err     _check         XARGS( (relation *, long, long, int) );
   void       _dislink       XARGS( (relation *, long, int, long) );
   void       _replace       XARGS( (relation *, long, long, int) );
   long       _find_seq      XARGS( (relation *, long, long, int, int) );
   void       _crypt         XARGS( (relation *, dataptr) );
   void       _cryptf        XARGS( (charptr, int, int) );
   void       _serHash       XARGS( (charptr) );

#define _encrypt   _crypt     /* These defines are used for clarity; */
#define _decrypt   _crypt     /* encryption/decryption routines are  */
#define _encryptf  _cryptf    /* all reversable, through the same    */
#define _decryptf  _cryptf    /* algorithms.                         */


/* MB_LOCK.C --------------------------------------------------------------- */

   mb_err     _chk_elck      XARGS( (relation *, bool) );
   mb_err     _set_lck       XARGS( (relation *) );
   void       _clr_lck       XARGS( (relation *) );
   void       _strobe        XARGS( (relation *, int) );

#endif /* INTERNAL_H */

