/***************************************************************************
 * This program is Copyright (C) 1986, 1987, 1988 by Jonathan Payne.  JOVE *
 * is provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is    *
 * included in all the files.                                              *
 ***************************************************************************/

/* Various tty state structures.
 * Each is an array, subscripted by one of "NO" or "YES".
 * YES is set suitably for JOVE.
 * NO is reset back to initial state.
 */

#ifdef	UNIX

#if defined(SGTTY) || defined(BRLUNIX)
# include <sgtty.h>
# ifdef	BRLUNIX
extern struct sg_brl	sg[2];
# else
extern struct sgttyb	sg[2];
# endif /* BRLUNIX */
#endif

#ifdef TERMIO
# include <termio.h>
extern struct termio	sg[2];
#endif

#ifdef TERMIOS
# include <termios.h>
extern struct termios	sg[2];
# ifndef VDSUSP
#  define VDSUSP	VSUSP	/* non-Posixism in Irix3.3, may exist in others */
# endif
#endif

#ifdef	SYSVR4
#undef	TIOCSLTC	/* don't let BSD emulation mislead us */
#endif

# ifdef	TIOCSLTC
extern struct ltchars	ls[2];
# endif	/* TIOCSLTC */

#ifdef	SYSV
#undef	TIOCGETC	/* not appropriate for System V */
#endif

# ifdef	TIOCGETC
extern struct tchars	tc[2];
# endif

#endif	/* UNIX */
