/* chsh.c - change ones shell */
/* poe@daimi.aau.dk */
/* minor bugfixes: flebbe@tat.physik.uni-tuebingen.de */

#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include <string.h>

char *getpass();

#define MAX_SHELLS 20
#define until(b) while(!(b))

char buffer[8000];

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct passwd *pe;
	char *pwdstr, *newsh, *bufptr;
	FILE *fp;
	char *shells[MAX_SHELLS];
	int n,nr;
	char *user;
	uid_t gotuid = getuid();

	umask(022);

	if(argc > 2) {
		puts("Too many arguments");
		exit(1);
	} else if(argc == 2) {
		if(gotuid) {
			puts("Only root can change the shell for others");
			exit(1);
		}
		user = argv[1];
	} else {
		user = getlogin();
	}
	
	if(!(pe = getpwnam(user))) {
		puts("Can't find you in password file?!");
		exit(1);
	}

	if(gotuid && gotuid != pe->pw_uid) {
	    puts("UID and username does not match, imposter!");
	    exit(1);
	}

	if(gotuid && pe->pw_passwd && pe->pw_passwd[0]) {
		pwdstr = getpass("Enter password: ");
		if(strncmp(pe->pw_passwd, crypt(pwdstr, pe->pw_passwd), 14)) {
			puts("Illegal password, imposter.");
			exit(1);
		}
	}

	printf("The current shell is: %s\n", pe->pw_shell);

redo_it:
	if(fp = fopen("/etc/shells", "r")) {
		puts("You can choose one of the following:");
		nr = 1;
		bufptr = buffer;
		while(fgets(bufptr, 79, fp) && nr < MAX_SHELLS 
		      && bufptr < buffer + 7999) {
			printf("%d: %s", nr, bufptr);
			bufptr[strlen(bufptr)-1] = '\0';
			shells[nr-1] = bufptr;
			bufptr += strlen(bufptr)+1;
			nr++;
		}
		fclose(fp);
		
		do {
			printf("Enter a number between 1 and %d: ", nr-1);
			fflush(stdout);
			scanf("%d", &n);
		} until(1 <= n && n <= nr-1);
		newsh = shells[n-1];
	} else {
		printf("Enter the full path of the new shell: ");
		fflush(stdout);
		fgets(buffer, 70, stdin);
		buffer[strlen(buffer)-1] = '\0';
		newsh = buffer;
	}
	
	if(access(newsh, X_OK) < 0) {
		printf("Can't find %s, try again...\n", newsh);
		goto redo_it;
	}

	/* now write new passwd file */
	if(access("/etc/ptmp", F_OK) == 0) {
		puts("/etc/ptmp exists, can't change shell");
		exit(1);
	}
	
	if(!(fp = fopen("/etc/ptmp", "w"))) {
		puts("Can't open /etc/ptmp, can't change shell");
		exit(1);
	}

	setpwent();
	while(pe = getpwent()) {
		if(!strcmp(user, pe->pw_name)) {
			pe->pw_shell = newsh;
		}
		if(putpwent(pe, fp) < 0) {
			puts("Error while writing new password file, shell not changed.");
			fclose(fp);
			endpwent();
			unlink("/etc/ptmp");
			exit(1);
		}
	}
	fclose(fp);
	endpwent();

	unlink("/etc/passwd.OLD");
	link("/etc/passwd", "/etc/passwd.OLD");
	unlink("/etc/passwd");
	link("/etc/ptmp", "/etc/passwd");
	unlink("/etc/ptmp");
	chmod("/etc/passwd", 0644);

	puts("Shell changed.");	
	return 0;
}
