#include "h/common.h"
#include <termios.h>
#include "h/terminal.h"

static struct termios oldterm;

void 
term_save(fd)
	int fd;
{
	tcgetattr(fd, &oldterm);
}

int
term_raw(fd, vmin, vtime, baud)
	int fd;
	u_int vmin;
	u_int vtime;
	int baud;
{
	struct termios tempio;
	
	tcgetattr(fd, &tempio);
	
	tempio.c_iflag = 0;
	tempio.c_oflag = 0;
	tempio.c_lflag = 0;
	tempio.c_cc[VMIN] = vmin;
	tempio.c_cc[VTIME] = vtime;
	
/*	cfsetospeed(&tempio, baud);
 *	cfsetispeed(&tempio, baud);
 */
	return tcsetattr(fd, TCSANOW, &tempio);
}

void 
term_restore(fd)
	int fd;
{
	tcsetattr(fd, TCSANOW, &oldterm);
}

