/* Our virtual file system layer */

enum {
    copy_through_temporal,
    direct_copy
};

typedef struct {
    int  (*load_dir)      (dir_list *list, sortfn *sort, int reverse);
    int  (*reload_dir)    (dir_list *list, sortfn *sort, int reverse);
    void (*copy_file_in)  (const char *, const char *);
    void (*copy_file_out) (const char *, const char *);
    void (*erase_file)    (const char *);
    void (*rmdir)         (const char *);
    void (*chdir)         (const char *);
    void (*mkdir)         (const char *);
    void (*link)          (const char *, const char *);

    int  copy_mode;
} vfs;
    
