/*-----------------------------------------------------------------------------
  Am.h
  
  (c) Simon Marlow 1990-1993
  (c) Albert Graef 1994
-----------------------------------------------------------------------------*/

#ifndef AM_H
#define AM_H

#include "Fm.h"
#include <sys/param.h>

/*--FmAw---------------------------------------------------------------------*/

#define MAXAPPSTRINGLEN MAXPATHLEN

typedef struct {
	char *name;
	char *directory;
	char *fname;
	char *icon;
	char *push_action;
	char *drop_action;
	Pixmap icon_bm;
	Boolean loaded;
	Widget form, toggle, label;
	Boolean selected;
} AppRec, *AppList;

typedef struct {
	Widget shell, form, viewport, icon_box;
	AppList apps;
	int n_apps;
	int n_selections;
	Boolean modified;
} AppWindowRec;
 
extern AppWindowRec aw;
extern Widget app_popup_widget, *app_popup_items, app_popup_widget1;

void createApplicationWindow();
void createApplicationDisplay();
void updateApplicationDisplay();
void readApplicationData(String path);
int writeApplicationData(String path);
void installApplication(char *name, char *directory, char *fname, char *icon,
			char *push_action, char *drop_action);
void replaceApplication(AppRec *app, char *name, char *directory, char *fname,
			char *icon, char *push_action, char *drop_action);
void removeApplication(int i);
void moveApplication(int i);
void freeApplicationResources(AppRec *app);

/*--FmAwCb-------------------------------------------------------------------*/

FmCallbackProc 
  appInstallCb, appEditCb, appMoveCb, appCopyCb, appRemoveCb, appSaveCb,
  appLoadCb, appOpenCb, appCloseCb;

/*--FmAwActions--------------------------------------------------------------*/

int  findAppWidget(Widget w);

FmActionProc appPopup, appMaybeHighlight, runApp, appSelect, appToggle;

void appEndMove(int i);
void appEndMoveInBox(void);

/*--FmAwPopup----------------------------------------------------------------*/

void installNewPopup();
void installExistingPopup();
void createInstallPopup();

#endif
