------------------------------------------------------------------------------
--                                                                          --
--                        GBIND BINDER COMPONENTS                           --
--                                                                          --
--                             B I N D U S G                                --
--                                                                          --
--                                B o d y                                   --
--                                                                          --
--                            $Revision: 1.16 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Osint;  use Osint;
with Output; use Output;

procedure Bindusg is

   procedure Write_Switch_Char is
   begin
      Write_Str ("  ");
      Write_Char (Switch_Character);
   end Write_Switch_Char;

--  Start of processing for Bindusg

begin
   --  Usage line

   Write_Str ("Usage: ");
   Write_Program_Name;
   Write_Char (' ');
   Write_Str ("switches lfile");
   Write_Eol;
   Write_Eol;

   --  Line for -a switch

   Write_Switch_Char;
   Write_Str ("a      Require all source files to be");
   Write_Str (" present");
   Write_Eol;

   --  Line for -b switch

   Write_Switch_Char;
   Write_Str ("b      Generate brief messages to std");
   Write_Str ("err even if verbose mode set");
   Write_Eol;

   --  Line for -c switch

   Write_Switch_Char;
   Write_Str ("c      Check only, no generation of b");
   Write_Str ("inder output file");
   Write_Eol;

   --  Line for -e switch

   Write_Switch_Char;
   Write_Str ("e      Output complete list of elabor");
   Write_Str ("ation order dependencies");
   Write_Eol;

   --  Line for -i switch

   Write_Switch_Char;
   Write_Str ("ix     Identifier char set (x=1/2/3/4/p");
   Write_Str ("/f/n) default = ");

   pragma Assert (Default_Identifier_Character_Set = 'p'
                    or else Default_Identifier_Character_Set = '1');
   if Default_Identifier_Character_Set = 'p' then
      Write_Str ("p (IBM/PC)");
   elsif Default_Identifier_Character_Set = '1' then
      Write_Str ("1 (Latin-1)");
   end if;

   Write_Eol;

   --  Line for -l switch

   Write_Switch_Char;
   Write_Str ("l      Output chosen elaboration order");
   Write_Eol;

   --  Line for -m switch

   Write_Switch_Char;
   Write_Str ("mnnn   Limit number of detected error");
   Write_Str ("s to nnn (1-999)");
   Write_Eol;

   --  Line for -n switch

   Write_Switch_Char;
   Write_Str ("n      No main program");
   Write_Eol;

   --  Line for -o switch

   Write_Switch_Char;
   Write_Str ("o file give the Output name (default is b_xxx.c) ");
   Write_Eol;

   --  Line for -s switch

   Write_Switch_Char;
   Write_Str ("s      Check consistency of any source ");
   Write_Str ("files that can be located");
   Write_Eol;

   --  Line for -t switch

   Write_Switch_Char;
   Write_Str ("t      Ignore time stamp errors");
   Write_Eol;

   --  Line for -v switch

   Write_Switch_Char;
   Write_Str ("v      Verbose mode. Error messages,");
   Write_Str ("header, summary output to stdout");
   Write_Eol;

   --  Lines for -w switch

   Write_Switch_Char;
   Write_Str ("wx     Warning mode. (x=s/e for supp");
   Write_Str ("ress/treat as error)");
   Write_Eol;

   --  Line for sfile

   Write_Str ("  lfile   Library file names");

--  ??? Wild cards don't work under OS/2 at present.
--  if OS_2 then
--     Write_Str (" (wild cards allowed for multiple files)");
--  end if;

   Write_Eol;

end Bindusg;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.14
--  date: Wed May 25 21:07:21 1994;  author: rupp
--  Changed if MS_DOS ... to if MS_DOS or OS_2 ... for character set (-i).
--  ----------------------------
--  revision 1.15
--  date: Sat May 28 07:22:15 1994;  author: figueroa
--  Use Switch_Character and Default_Identifier_Character_Set instead of
--   testing for MS_DOS or OS_2
--  Comment out the writing of the message about wild cards being allowed
--   under OS/2
--  ----------------------------
--  revision 1.16
--  date: Sat May 28 09:05:51 1994;  author: dewar
--  Avoid dynamic concatentations introduced in revision 1.15
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
