------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                B I N D E                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines to determine elaboration order

with ALI;   use ALI;
with Table;
with Types; use Types;

package Binde is

   --  The following table records the chosen elaboration order. It is used
   --  by Gen_Elab_Call to generate the sequence of elaboration calls. Note
   --  that units are included in this table even if they have no elaboration
   --  routine, since the table is also used to drive the generation of object
   --  files in the binder output. Gen_Elab_Call skips any units that have no
   --  elaboration routine.

   package Elab_Order is new Table (
     Table_Component_Type => Unit_Id,
     Table_Index_Type     => Nat,
     Table_Low_Bound      => 1,
     Table_Initial        => 500,
     Table_Increment      => 200,
     Table_Name           => "Elab_Order");

   procedure Find_Elab_Order;
   --  Determine elaboration order

end Binde;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.5
--  date: Fri Jan 14 02:16:04 1994;  author: dewar
--  Remove Elab_Order_First, no longer needed
--  ----------------------------
--  revision 1.6
--  date: Wed Jun 29 09:44:10 1994;  author: dewar
--  Clarify in comments that preelaborable units appear in Elab_Order.Table
--  ----------------------------
--  revision 1.7
--  date: Thu Jun 30 10:49:32 1994;  author: dewar
--  Documentation for new view of preelaborable units
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
