/*
 * windiv.c	Some extra window routines for minicom, that
 *		I did not want to fold into window.c
 *
 *		This file is part of the minicom communications package,
 *		Copyright 1991,1992,1993,1994 Miquel van Smoorenburg.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */
#include "port.h"
#include "minicom.h"

/*
 * Popup a window and put a text in it.
 */  
/*VARARGS1*/
WIN *tell(s, a1, a2, a3, a4)
char *s, *a1, *a2, *a3, *a4;
{
  WIN *w;
  char buf[128];

  sprintf(buf, s, a1, a2, a3, a4);

  w = wopen((COLS / 2) - 2 - strlen(buf) / 2, 8,
	    (COLS / 2) + 2 + strlen(buf) / 2, 10,
  	     BDOUBLE, stdattr, MFG, MBG, 0, 0, 0);
  wcursor(w, CNONE);	
  wlocate(w, 2, 1);
  wputs(w, buf);
  wredraw(w, 1);
  return(w);
}

/*
 * Show an error message.
 */
/*VARARGS1*/
void werror(s, a1, a2, a3, a4)
char *s, *a1, *a2, *a3, *a4;
{
  WIN *tellwin;
  
  tellwin = tell(s, a1, a2, a3, a4);
  sleep(2);
  wclose(tellwin, 1);
}

/*
 * Vertical "wselect" function.
 */
int ask(what, s)
char *what;
char *s[];
{
  int num = 0;
  int cur = 0, ocur = 0;
  int f, c;
  WIN *w;

  for(f = 0; s[f]; f++) num++;

  w = wopen((COLS / 2) - 5*num , 8, (COLS / 2) + 1 + 5*num, 9,
		BSINGLE, stdattr, MFG, MBG, 0, 0, 1);
	
  dirflush = 0;

  wcursor(w, CNONE);
  wlocate(w, 1 + 5*num - (strlen(what) / 2), 0);
  wputs(w, what);

  for(f = 1; f < num; f++) {
  	wlocate(w, 2 + 10*f, 1);
  	wputs(w, s[f]);
  }
  wredraw(w, 1);

  while(1) {
  	wlocate(w, 2 + 10*cur, 1);
	if (!useattr)
		wprintf(w, ">%s", s[cur] + 1);
	else {
	  	wsetattr(w, A_REVERSE | stdattr);
  		wputs(w, s[cur]);
	}
  	ocur = cur;
  	wflush();
  	switch(c = getch()) {
  		case ' ':
  		case 27:
  		case 3:
  			dirflush = 1;
  			wclose(w, 1);
  			return(-1);
  		case '\r':
  		case '\n':
  			dirflush = 1;
  			wclose(w, 1);
  			return(cur);
  		case K_LT:
  		case 'h':
  			cur--;
  			if (cur < 0) cur = num - 1;
  			break;
  		default:
  			cur = (cur + 1) % num;
  			break;
  	}
  	wlocate(w, 2 + 10*ocur, 1);
  	wsetattr(w, stdattr);
	if (!useattr)
		wputs(w, " ");
	else
  		wputs(w, s[ocur]);
  }
}

extern int editline();

/*
 * Popup a window and ask for input.
 */
char *input(s, buf)
char *s;
char *buf;
{
  WIN *w;

  w = wopen((COLS / 2) - 20, 11, (COLS / 2) + 20, 12,
		BDOUBLE, stdattr, MFG, MBG, 1, 0, 1);
  wputs(w, s);
  wlocate(w, 0, 1);
  wprintf(w, "> %-38.38s", buf);
  wlocate(w, 2, 1);
  if (wgets(w, buf, 38, 128) < 0) buf = CNULL;
  wclose(w, 1);
  return(buf);
}

#if 0
/* Here I mean to work on a file selection window. */
/* Maybe minicom 1.70 - MvS. */

struct file {
  char *name;
  char isdir;
};
static struct filelist **list;
static int nrlist;

/* Compare two directory entries. */
static int cmpdir(d1, d2)
struct file *d1;
struct file *d2;
{
  if (strcmp(d1->name, "..")) return(-1);
  return(strcmp(d1->name, d2->name));
}

/* Sort the directory list. */
static int sortdir()
{
  qsort(list, nrlist, sizeof(struct file *), cmpdir);
}

/* Create file list of directory. */
static int makelist()
{
  DIR *dir;
  struct dirent *d;
  struct file **new;
  int left = 0;
  int f;

  if ((dir = opendir(".")) == NULL) {
	wbell();
	return(-1);
  }

  /* Free the old list if nessecary. */
  if (list) {
	for(f = 0; f < nrlist; f++) free(list[f]);
	free(list);
	list = NULL;
  }

  while(d = readdir(dir)) {

	/* Skip "." entry. */
	if (strcmp(d->d_name, ".") == 0) continue;

	/* Add this to our list. */
	if (left == 0) {
		/* Re-malloc. */
		if ((new = malloc(nrents + 10 * sizeof(void *))) == NULL) {
			closedir(dir);
			return(-1);
		}
		if (list) {
			memcpy(new, list, nrlist * sizeof(struct file **));
			free(list);
		}
		list = new;
		left = 10;
	}

	/* Stat this file. */
#ifdef S_IFLNK
	(void) lstat(d->d_name, &st);
#else
	(void) stat(d->d_name, &st);
#endif
	list[nrlist]->isdir = S_ISDIR(st.st_mode);
	f = 0;
	if (S_ISDIR(st.st_mode)) f = '/';
#ifdef S_ISLNK
	if (S_ISLNK(st.st_mode)) f = '@';
#endif
#ifdef S_ISFIFO
	if (S_ISFIFO(st.st_mode)) f = '|';
#endif
#ifdef S_ISSOCK
	if (S_ISSOCK(st.st_mode)) f = '=';
#endif
	if (S_ISREG(st.st_mode) && (st.st_mode & 0x111)) f = '*';

	/* Fill in name. */
	if ((list[nrlist]->name = malloc(strlen(d->d_name + 2))) == NULL) {
		closedir(dir);
		return(-1);
	}
	sprintf(list[nrlist]->name, "%s%c", d->d_name, f);
	nrlist++;
	left--;
  }
  closedir(dir);
  return(0);
}

/* Select a file. */
char *wfilesel()
{
  WIN *w;
  char cwd[64];

  /* Open one window. */
  w = wopen((COLS / 2) - 20, 5, (COLS / 2) + 20, 20,
		BDOUBLE, stdattr, MFG, MBG, 1, 0, 1);
  getcwd(cwd, 64);

  while(1) {
	makelist();
	sortdir();


#endif /* DEVEL */
