#include <stdio.h>
#include <nl_types.h>
#include "gripes.h"

#ifdef STDC_HEADERS
#include <stdlib.h>
#else
extern int fprintf ();
extern int fflush ();
extern int exit ();
extern char *malloc ();
extern char *getenv ();
#endif

extern char *progname;
char *mantexts = "man";		/* e.g. /usr/lib/locale/%L/man.cat */
extern char *msg[];
extern int debug;

nl_catd catfd = -1;
int cat_is_open = 0;

catinit () {
    if (!cat_is_open) {
	catfd = catopen(mantexts,0);
	if (catfd == -1) {
	    /* Only complain if at least one of NLSPATH and LANG exists,
	       and LANG != "en" (or when debugging) */
	    char *s, *lg;
	    s = getenv("NLSPATH");
	    lg = getenv("LANG");
	    if ((s || lg) && (!lg || strcmp(lg, "en"))) {
		perror(mantexts);
		fprintf(stderr,
"Failed to open the message catalog %s on the path NLSPATH=%s\n\n",
			mantexts, s ? s : "<none>");
	    } else if (debug) {
		perror(mantexts);
		fprintf(stderr,
"Looked whether there exists a message catalog %s, but there is none
(and for English messages none is needed)\n\n",
			mantexts);
            }
	}
    }
    cat_is_open = 1;
}

void
gripe (n) int n; {
    char *s;

    catinit ();
    if (catfd != -1 && *(s = catgets(catfd, 1, n, "")))
      fprintf (stderr, s);
    else if (0 < n && n <= MAXMSG)
      fprintf (stderr, msg[n]);
    else {
	fprintf (stderr, "man: internal error - cannot find message %d\n", n);
	exit (1);
    }
    fflush (stderr);
}

void
gripe1 (n,ss) int n; char *ss; {
    char *s;

    catinit ();
    if (catfd != -1 && *(s = catgets(catfd, 1, n, "")))
      fprintf (stderr, s, ss);
    else if (0 < n && n <= MAXMSG)
      fprintf (stderr, msg[n], ss);
    else {
	fprintf (stderr, "man: internal error - cannot find message %d\n", n);
	exit (1);
    }
    fflush (stderr);
}

void
gripe1i (n,i) int n, i; {
    char *s;

    catinit ();
    if (catfd != -1 && *(s = catgets(catfd, 1, n, "")))
      fprintf (stderr, s, i);
    else if (0 < n && n <= MAXMSG)
      fprintf (stderr, msg[n], i);
    else {
	fprintf (stderr, "man: internal error - cannot find message %d\n", n);
	exit (1);
    }
    fflush (stderr);
}

void
gripe2 (n,ss,tt) int n; char *ss, *tt; {
    char *s;

    catinit ();
    if (catfd != -1 && *(s = catgets(catfd, 1, n, "")))
      fprintf (stderr, s, ss, tt);
    else if (0 < n && n <= MAXMSG)
      fprintf (stderr, msg[n], ss, tt);
    else {
	fprintf (stderr, "man: internal error - cannot find message %d\n", n);
	exit (1);
    }
    fflush (stderr);
}

void
gripe2i (n,ss,i) int n; char *ss; int i; {
    char *s;

    catinit ();
    if (catfd != -1 && *(s = catgets(catfd, 1, n, "")))
      fprintf (stderr, s, ss, i);
    else if (0 < n && n <= MAXMSG)
      fprintf (stderr, msg[n], ss, i);
    else {
	fprintf (stderr, "man: internal error - cannot find message %d\n", n);
	exit (1);
    }
    fflush (stderr);
}

void
fatal1 (n,ss) int n; char *ss; {
    char *s;

    fprintf (stderr, "%s: ", progname);
    gripe1 (n,ss);
    exit (1);
}

void
fatal2 (n,ss,tt) int n; char *ss, *tt; {
    char *s;

    fprintf (stderr, "%s: ", progname);
    gripe2 (n,ss,tt);
    exit (1);
}

char *
my_malloc (n) int n; {
    char *s = malloc(n);
    if (!s)
	fatal1 (OUT_OF_MEMORY, n);
    return s;
}

char *
strdup (s) char *s; {
    char *t = my_malloc(strlen(s) + 1);
    strcpy(t, s);
    return t;
}
