"======================================================================
|
|   Semaphore Method Definitions
|
 ======================================================================"


"======================================================================
|
| Copyright (C) 1990, 1991 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 1, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
|
 ======================================================================"


"
|     Change Log
| ============================================================================
| Author       Date       Change 
| sbyrne     19 Sep 89	  Converted to use real method categories.
|
| sbyrne     25 Apr 89	  created.
|
"

LinkedList subclass: #Semaphore
	   instanceVariableNames: 'signals'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: nil.

Semaphore comment: 
'My instances represent counting semaphores.  I provide methods for signalling
the semaphore''s availability, and methods for waiting for its availability.
I also provide some methods for implementing critical sections.  I currently
do not (because the underlying system does not) support asynchronous
signals, such as might be generated by C signals.' !

!Semaphore class methodsFor: 'instance creation'!

new
    ^self basicNew initSemaphore
!

forMutualExclusion
    | sem |
    sem _ self new.
    sem signal.
    ^sem
!!



!Semaphore methodsFor: 'mutual exclusion'!

critical: aBlock
    | result |
    self wait.
    result _ aBlock value.
    self signal.
    ^result
!!



!Semaphore methodsFor: 'private'!

initSemaphore
    signals _ 0
!!
