/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	help.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_help class header
 *		This is the hypertext help object used by OI_app_window
 *
 *	RCSid = "$Id: help.H,v 4.9.1.1 1993/06/01 22:54:47 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_help_H
#define OI_help_H

#ifndef OI_dlgbox_H
#include <OI/dlgbox.H>
#endif /* OI_dlgbox_H */

	// class forward reference declarations
	class	OI_mdl_help;
	class	OI_hlp_fil;
	class	OI_hlp_lst_ele;
	class	OI_hlp_inline;
	class	OI_hlp_itm;
	class	OI_menu_cell;
	class	OI_menu;
	class	OI_button_menu;
	class	OI_dialog_box;
	class	OI_scroll_text;

#define		OI_MX_C_HELP	50						/* max # chars in hypertext help line */

 /* object specific control bits */
#define					OI_HELP_KEY_HELP		0x1L	/* keyboard activated help in process */
#define					OI_HELP_IN_CONSTRUCTOR		0x2L	/* 1 => in constructor for this object */
#define					OI_HELP_RET_PREV		0x4L	/* 1 => performing return to previous */
#define					OI_HELP_NO_MSG			0x8L	/* 1 => do not print missing help topic/file messages */
#define					OI_HELP_INLINE_UNDER		0x10L	/* 1 => inline links are underlined; 0 => reverse */
#define					OI_HELP_BUSY			0x20L	/* 1 => help object is busy, don't bother it */
#define					OI_HELP_VIEW_FITS_TEXT		0x40L	/* 1 => viewport should expand to fit all text */

	class OI_help : public OI_dialog_box	{				/* help object */
		static	XrmQuark	q_cbKeyHelp ;				/* quark for keyboard help callback */
		static	OI_compiled_action_table	txt_actions ;		/* actions for text object inline callbacks */
		static	OI_translation_table		*txt_translations ;	/* translations for inline callbacks */
			OI_mdl_help	*mdl_dep ;				/* ptr to model dependent aspects of object */
			unsigned long	ctl_bits ;				/* object specific control bits */
			OI_hlp_fil	*fil_lstp ;				/* ptr to list of help files opened for use */
			OI_hlp_lst_ele	*curp ;					/* ptr to current context */
			OI_hlp_lst_ele	*actp ;					/* ptr to active context (the one currently displayed) */
			OI_hlp_lst_ele	*pgm_lst ;				/* ptr to top level list of program specified help items */
			OI_hlp_lst_ele	*trav_lst ;				/* ptr to list of help items traversed by user */
			OI_hlp_lst_ele	*dscd_lst ;				/* ptr to list of obsolete help items */
			OI_menu_cell	*dscd_cellp ;				/* ptr to "Discard" cell where obsolete items hang */
			OI_xy		mag_loc ;				/* location of magnifying glass */
			Pixmap		img_pm ;				/* image in case help context cannot be located */
			OI_button_menu	*dflt_topics;				/* the default topics menu */
			OI_hlp_inline	*inlinp ;				/* ptr to inline references for current context (curp) */
			XrmQuark	dflt_filq ;				/* quark corresponding to file where default pulldown extracted */
	 public:
		static	OI_class		*clsp ;				/* ptr to class record */
		friend	void		dmpOI_help(OI_help*) ;
	 private:
			void		allow_help_diag()	{ ctl_bits &= ~OI_HELP_NO_MSG; }
			void		allow_key_help()	{ctl_bits|=OI_HELP_KEY_HELP;}
			void		construct(const char*,const char*) ;
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_HELP_IN_CONSTRUCTOR;}
			void		disallow_help_diag()	{ ctl_bits |= OI_HELP_NO_MSG; }
			void		disallow_key_help()	{ctl_bits&= ~OI_HELP_KEY_HELP;}
			void		fetch_default_topics();
			OI_bool		in_my_constructor()	{return((ctl_bits&OI_HELP_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			OI_enhance	inline_enhance() ;
			void		inline_ref(OI_d_tech*,const XEvent*,const char* const *,unsigned int*) ;
			OI_bool		is_key_help()		{return((OI_bool)((ctl_bits&OI_HELP_KEY_HELP) != 0 ? OI_YES : OI_NO));}
			void		mark_inline_refs() ;				/* mark all in-line text references */
			void		on_context(OI_menu_cell*,void*,OI_number) ;
			void		on_context_click(const XEvent*,void*) ;
			void		on_context_grab(OI_menu*,OI_menu_cell*,void*,OI_number) ;
			OI_bool		set_help_internal(const char *topic, const char *file, OI_bool pgm) ;
			OI_bool		insert_help_internal(XrmQuark t, XrmQuark f=(XrmQuark)NULL, OI_bool pgm=OI_YES) ;
			OI_bool		insert_help_internal(const char *topic, const char *file=NULL, OI_bool pgm=OI_YES) ;
			OI_hlp_lst_ele	*last_program_help() ;				/* get ptr to most recent program help stack item */
			OI_bool		pop_help_internal(const char *t, const char *f=NULL) ;
			OI_bool		pop_help_internal(XrmQuark t=(XrmQuark)NULL, XrmQuark f=(XrmQuark)NULL) ;
			OI_bool		ret_previous()		{return((ctl_bits&OI_HELP_RET_PREV) ? OI_YES : OI_NO);}
			void		traverse(OI_hlp_lst_ele*) ;			/* add / readjust item in traversal list */
			void		remove_from_traverse(OI_hlp_lst_ele*) ;		/* remove item from traversal list */
			void		res_inline_enhance(void*) ;
			void		res_viewport_fits_text(void*) ;
			void		set_inline_enhance(OI_enhance) ;
			void		set_in_my_constructor()	{ctl_bits|=OI_HELP_IN_CONSTRUCTOR;}
			void		select_default(OI_menu_cell *, void *, OI_number);
			void		new_viewport_fits_text(OI_bool) ;
			void		update_menu_tree(OI_hlp_lst_ele*) ;		/* update menu tree for topics visited */
			void		void_default_topics(OI_d_tech*,void*) ;
	 protected:
					OI_help(OI_class *clsp, const char *name, const char *topic=NULL, const char *file=NULL) ;
		virtual	OI_stat		create() ;
		virtual	void		new_model(OI_model_type) ;
		virtual	void		paint(const XEvent *, void* =NULL) ;
			void		current_context_init() ;			/* initialize current_context() fetch  */
			void		key_resize(OI_bool) ;				/* resize for display due to help key activation */
			Pixmap		build_image(int,int) ;				/* build magnified image */
			OI_menu		*navigation_menu() ;
			OI_dialog_box	*search_box() ;
	 public:
		/* functions reserved for toolkit use */
					OI_help(const char *name, const char *topic=NULL, const char *file=NULL) ;
					~OI_help() ;
			OI_hlp_lst_ele	*active_context()	{ return(actp); }
			void		allow_busy()		{ ctl_bits |= OI_HELP_BUSY; }
			void		allow_viewport_fits_text() ;
			void		disallow_busy()		{ ctl_bits &= ~OI_HELP_BUSY; }
			void		disallow_viewport_fits_text() ;
			OI_bool		is_busy()		{ return ((ctl_bits&OI_HELP_BUSY)?OI_YES:OI_NO); }
			OI_bool		is_help_diag()		{ return((OI_bool)((ctl_bits&OI_HELP_NO_MSG) != 0 ? OI_NO : OI_YES)); }
			OI_button_menu 	*default_topics() ;
		virtual	void		suspend_obj() ;					/* suspend input processing */
		virtual	void		key_hlp(OI_d_tech*, const XEvent*, const char* const *, unsigned int *) ;
											/* initiate help with key press */
			void		ret_prev() ;					/* return to prev entry from help stack */
			OI_stat		update() ;					/* make object reflect current context */
			void		client_message(const XEvent*) ;			/* field client message events */
			char		*current_context() ;				/* get next line of current context */
			void		done(OI_menu_cell*,void*,OI_number) ;		/* take down help object */
			OI_bool		find_default_help(OI_d_tech*) ;			/* attempt to find default help for object */
			OI_bool		find_help(OI_d_tech*) ;				/* attempt to find help for object */
		static	OI_bool		init(OI_connection*) ;
		static	OI_help		*make_minimal(const char*,OI_minimal_type) ;
			void		menu_topic(OI_menu_cell*,void*,OI_number) ;	/* change topic due to navig. menu button press */
			void		tree_topic(OI_menu_cell*,void*,OI_number) ;	/* change topic due to click in subtree menu */
			void		srch_in_topic(OI_menu_cell*,void*,OI_number) ;	/* search for item within current topic */
//			void		srch_in_file(OI_menu_cell*,void*,OI_number) ;	/* search for item within current file */
			void		srch_for_topic(OI_menu_cell*,void*,OI_number) ;	/* search for topic within current file */
			void		duplicate(OI_menu_cell*,void*,OI_number) ;	/* duplicate help object */
			OI_d_tech	*magnifier() ;
			Pixmap		image_pixmap() ;
			void		set_mag_loc(OI_number x, OI_number y) ;
			OI_hlp_fil	*post_file(XrmQuark) ;				/* post file to file list */
			OI_hlp_itm	*active_topic() ;
			OI_stat		set_default_help(const char *t, const char *f=NULL) ;
			char		*default_help_file() ;
			XrmQuark	default_help_file_quark() ;
			OI_hlp_lst_ele	*find_program_item(XrmQuark qf, XrmQuark qt) ;
		/* normal public functions */
		virtual	void		clone_adjust(OI_d_tech*) ;
			char		*file() ;
			XrmQuark	file_quark() ;
			OI_stat		pop_help(const char *t=NULL, const char *f=NULL) ;
			OI_stat		push_help(const char *t, const char *f=NULL) ;
			OI_scroll_text	*scroll_text() ;
			void		set_key_help(OI_help_fnp fp, void *argp=NULL) ;
			void		set_key_help(OI_callback *objp, OI_help_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_help(const char *t, const char *f=NULL) ;
			OI_bool		stage(const char *) ;				/* stage file */
			char		*topic() ;
			XrmQuark	topic_quark() ;
			OI_bool		viewport_fits_text() ;
			void		void_context() ;				/* void all current context data */
	} ;

 /* interface to the outside world */
	OI_help *oi_create_help(const char *name, const char *topic=NULL, const char *file=NULL) ;

#endif /* OI_help_H */
