/* recedit.h -- Include file for using the GNU Record Editor library. */

/* Copyright (C) 1988,1990 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   GNU Finger is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 1, or (at your
   option) any later version.

   GNU Finger is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Finger; see the file COPYING.  If not, write to the
   Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Types of fields that this record editor can handle.  */
#define Char 1
#define Int  2
#define Date 3
#define Phone 4

/* A structure defining a historical date. */
typedef struct {
  int day;
  int month;
  int year;
} DATE;

/* A structure defining a complete phone number. */
typedef struct {
  int area_code;
  int prefix;
  int number;
} PHONE;

/* Various attributes that a field can have. */ 
#define FieldPrivileged 0x01	/* Can only edit if you are root. */
#define FieldInvisible  0x02	/* Can't see unless you are root. */
#define FieldKey	0x04	/* This is one of the key fields. */

typedef struct {
  char *name;			/* The name of this field. */
  int type;			/* What type of data is stored here. */
  int attributes;		/* Attributes of this field. */
  union {
    char *chardata;
    int intdata;
    DATE date;
    PHONE phone;
  } data;
} FIELD_DESC;

/* Passed a pointer to some packed data, and a pointer to an array of
   field descriptors, fill in the data slots in the array of fields from
   the contents of the packed data.  Storage space for character strings
   is malloc'ed.  */
void re_extract_fields ();

/* Return the total storage space needed to store this set of fields. */
int re_data_length ();

/* Return a pointer to a string of bytes which is the packed representation
   of the info in FIELDS.  ATTRIBUTES, if non-zero, specifies which
   attributes the fields must have.  The space for the returned data
   is malloc'ed. */
char *re_extract_data ();

/* Read the format of the database from FILENAME.  Return
   a pointer to an array of pointers to fields. */
FIELD_DESC **re_read_description_file ();

/* Read the description of a record from STREAM.  Return a pointer to
   an array of pointers of FIELD_DESC which describe what a record
   looks like.  */
FIELD_DESC **re_read_description ();

/* Output the field names and contents of FIELDS to STREAM. */
void re_print_fields ();

/* Modify the contents of FIELDS from the data read from STREAM.
   Each line read from stream has a field name followed by a colon,
   and then the value for that field.  Stop reading values when the
   stream is exhausted, or if a line containing "End." is read. */
void re_eval_fields ();

/* Return a copy of the fields in FIELDS. */
FIELD_DESC **re_copy_fields ();

/* Directly modify the field with name NAME in FIELDS, forcing the
   data value to be DATA.  If the field wasn't found, then return
   non-zero, else zero. */
int re_set_field ();

/* Search through FIELDS, and return the data value associated with
   FIELD_NAME.  This returns a pointer to the data field. */
void *re_get_field_value ();

/* Free the memory used by the FIELDS. */
void re_free_fields ();

/* Return a FIELD_DESC * to the field in FIELDS that has FIELD_NAME as
   its name.  Return a NULL pointer if that field cannot be found. */
FIELD_DESC *re_find_field ();
