/* packet.h -- Data structure of a packet. */

/* Copyright (C) 1988,1990,1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (_PACKET_H_)
#define _PACKET_H_

/* Length of the informative items that are returned in a FINGER_PACKET. */

#define USERNAME_LEN 16
#define HOSTNAME_LEN 64
#define REALNAME_LEN 64
#define TTYNAME_LEN 32
#define TTYLOC_LEN 128
#define WHAT_LEN 16

/* What a packet of finger information from a client looks like.  Note that
   times are stored in 32 bits of SECONDS.  Absolute time values are stored
   as seconds since 1970. */

typedef struct {
  char name[USERNAME_LEN];
  char real_name[REALNAME_LEN];
  char host[HOSTNAME_LEN];
  long login_time;
  long idle_time;
  char ttyname[TTYNAME_LEN];
  char ttyloc[TTYLOC_LEN];
  char what[WHAT_LEN];
} FINGER_PACKET;

FINGER_PACKET **read_packets (), **read_network_packets (), **receive_packets ();
FINGER_PACKET **generic_read_packets (), **finger_at_address ();
FINGER_PACKET **filter_packets (), **console_users ();
int read_packet ();
void remove_packets ();
void write_packets (), print_packet (), ascii_packet ();
void write_packet ();
void sort_packets ();
#endif /* _PACKET_H_ */
